/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.x.imageio.plugins.jpeg;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;
import org.apache.harmony.luni.util.NotImplementedException;
import org.apache.harmony.x.imageio.internal.OutputStreamWrapper;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class JPEGImageWriter
extends ImageWriter {
    private Raster sourceRaster;
    private WritableRaster scanRaster;
    private int srcXOff = 0;
    private int srcYOff = 0;
    private int srcWidth;
    private int srcHeight;
    private int deltaY = 1;
    private int deltaX = 1;
    private ImageOutputStream ios;

    public JPEGImageWriter(ImageWriterSpi imageWriterSpi) {
        super(imageWriterSpi);
    }

    @Override
    public void write(IIOMetadata iioMetadata, IIOImage iioImage, ImageWriteParam param) throws IOException {
        if (this.ios == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.7F"));
        }
        RenderedImage img = null;
        this.sourceRaster = !iioImage.hasRaster() ? ((img = iioImage.getRenderedImage()) instanceof BufferedImage ? ((BufferedImage)img).getRaster() : img.getData()) : iioImage.getRaster();
        HashMap<String, Object> params = new HashMap<String, Object>();
        try {
            Imaging.writeImage((BufferedImage)img, this.wrapOutput(this.ios), (ImageFormat)ImageFormats.JPEG, params);
        }
        catch (ImageWriteException e) {
            e.printStackTrace();
        }
    }

    private OutputStream wrapOutput(Object output) {
        if (output instanceof OutputStream) {
            return (OutputStream)output;
        }
        if (output instanceof ImageOutputStream) {
            return new OutputStreamWrapper((ImageOutputStream)output);
        }
        throw new UnsupportedOperationException(output.getClass().getName());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.ios = null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam imageWriteParam) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata iioMetadata, ImageWriteParam imageWriteParam) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata iioMetadata, ImageTypeSpecifier imageTypeSpecifier, ImageWriteParam imageWriteParam) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public void setOutput(Object output) {
        super.setOutput(output);
        this.ios = (ImageOutputStream)output;
        this.sourceRaster = null;
        this.scanRaster = null;
        this.srcXOff = 0;
        this.srcYOff = 0;
        this.srcWidth = 0;
        this.srcHeight = 0;
        this.deltaY = 1;
    }

    private void getScanLine(int scanline) {
        Raster child = this.sourceRaster.createChild(this.srcXOff, this.srcYOff + scanline * this.deltaY, this.srcWidth, 1, 0, 0, null);
        this.scanRaster.setRect(child);
        this.processImageProgress((float)scanline / (float)this.srcHeight * 100.0f);
    }

    private int getSourceCSType(RenderedImage image) {
        int type = 0;
        ColorModel cm = image.getColorModel();
        if (null == cm) {
            return type;
        }
        if (cm instanceof IndexColorModel) {
            throw new UnsupportedOperationException(Messages.getString("imageio.80"));
        }
        boolean hasAlpha = cm.hasAlpha();
        ColorSpace cs = cm.getColorSpace();
        switch (cs.getType()) {
            case 6: {
                type = 1;
                break;
            }
            case 5: {
                type = hasAlpha ? 6 : 2;
                break;
            }
            case 3: {
                type = hasAlpha ? 7 : 3;
                break;
            }
            case 13: {
                type = hasAlpha ? 10 : 5;
                break;
            }
            case 9: {
                type = 4;
            }
        }
        return type;
    }

    private int getDestinationCSType(RenderedImage image) {
        int type = 0;
        ColorModel cm = image.getColorModel();
        if (null != cm) {
            boolean hasAlpha = cm.hasAlpha();
            ColorSpace cs = cm.getColorSpace();
            switch (cs.getType()) {
                case 6: {
                    type = 1;
                    break;
                }
                case 5: {
                    type = hasAlpha ? 7 : 3;
                    break;
                }
                case 3: {
                    type = hasAlpha ? 7 : 3;
                    break;
                }
                case 13: {
                    type = hasAlpha ? 10 : 5;
                    break;
                }
                case 9: {
                    type = 4;
                }
            }
        }
        return type;
    }

    @Override
    public ImageWriteParam getDefaultWriteParam() {
        return new JPEGImageWriteParam(this.getLocale());
    }
}

