/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.x.imageio.plugins;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.harmony.awt.gl.image.DecodingImageSource;
import org.apache.harmony.awt.gl.image.OffscreenImage;
import org.apache.harmony.x.imageio.internal.nls.Messages;
import org.apache.harmony.x.imageio.plugins.PluginUtils;

public class AwtImageReader
extends ImageReader {
    private ImageInputStream iis;
    private OffscreenImage image;

    public AwtImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public int getHeight(int i) throws IOException {
        return this.getImage(i).getHeight(new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return (infoflags & 2) == 0;
            }
        });
    }

    @Override
    public int getWidth(int i) throws IOException {
        return this.getImage(i).getWidth(new ImageObserver(){

            @Override
            public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
                return (infoflags & 1) == 0;
            }
        });
    }

    @Override
    public int getNumImages(boolean b) throws IOException {
        return 1;
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int i) throws IOException {
        ColorModel model = this.getImage(i).getColorModel();
        ImageTypeSpecifier[] spec = new ImageTypeSpecifier[]{new ImageTypeSpecifier(model, model.createCompatibleSampleModel(1, 1))};
        return Arrays.asList(spec).iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int i) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int i, ImageReadParam imageReadParam) throws IOException {
        return this.getImage(i).getBufferedImage();
    }

    @Override
    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        super.setInput(input, seekForwardOnly, ignoreMetadata);
        this.iis = (ImageInputStream)input;
        this.image = null;
    }

    @Override
    public ImageReadParam getDefaultReadParam() {
        return new ImageReadParam();
    }

    private OffscreenImage getImage(int index) throws IOException {
        if (index >= this.getNumImages(false)) {
            throw new IndexOutOfBoundsException("index >= getNumImages()");
        }
        if (this.image == null) {
            if (this.iis == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.2", "input"));
            }
            IISDecodingImageSource source = new IISDecodingImageSource(this.iis);
            this.image = new OffscreenImage(source);
            source.addConsumer(this.image);
            source.load();
        }
        return this.image;
    }

    private static class IISDecodingImageSource
    extends DecodingImageSource {
        private final InputStream is;

        IISDecodingImageSource(ImageInputStream iis) {
            this.is = PluginUtils.wrapIIS(iis);
        }

        @Override
        protected boolean checkConnection() {
            return true;
        }

        @Override
        protected InputStream getInputStream() {
            return this.is;
        }
    }
}

