/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.render;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.TextRenderer;
import org.apache.harmony.awt.gl.font.CommonGlyphVector;
import org.apache.harmony.awt.gl.font.FontPeerImpl;
import org.apache.harmony.awt.gl.font.Glyph;
import org.apache.harmony.awt.gl.image.BufferedImageGraphics2D;

public class JavaTextRenderer
extends TextRenderer {
    public static final JavaTextRenderer inst = new JavaTextRenderer();

    @Override
    public void drawGlyphVector(Graphics2D g, GlyphVector glyphVector, float x, float y) {
        int atType;
        AffineTransform at = g.getTransform();
        Rectangle c = g.getClipBounds();
        if (at != null && (atType = at.getType()) == 1) {
            c.translate((int)Math.round(at.getTranslateX()), (int)Math.round(at.getTranslateY()));
        }
        WritableRaster wr = ((BufferedImageGraphics2D)g).getWritableRaster();
        ColorModel cm = ((BufferedImageGraphics2D)g).getColorModel();
        Rectangle rBounds = wr.getBounds();
        Object color = cm.getDataElements(g.getColor().getRGB(), null);
        this.drawClipGlyphVector(wr, color, glyphVector, (int)Math.round((double)x + at.getTranslateX()), (int)Math.round((double)y + at.getTranslateY()), Math.max(c.x, rBounds.x), Math.max(c.y, rBounds.y), Math.min((int)Math.round(c.getMaxX()), (int)Math.round(rBounds.getMaxX())), Math.min((int)Math.round(c.getMaxY()), (int)Math.round(rBounds.getMaxY())));
    }

    @Override
    public void drawString(Graphics2D g, String str, float x, float y) {
        int atType;
        AffineTransform at = g.getTransform();
        Rectangle c = g.getClipBounds();
        if (at != null && (atType = at.getType()) == 1) {
            c.translate((int)Math.round(at.getTranslateX()), (int)Math.round(at.getTranslateY()));
        }
        WritableRaster wr = ((BufferedImageGraphics2D)g).getWritableRaster();
        ColorModel cm = ((BufferedImageGraphics2D)g).getColorModel();
        Rectangle rBounds = wr.getBounds();
        Object color = cm.getDataElements(g.getColor().getRGB(), null);
        this.drawClipString(wr, color, str, (FontPeerImpl)g.getFont().getPeer(), (int)Math.round((double)x + at.getTranslateX()), (int)Math.round((double)y + at.getTranslateY()), Math.max(c.x, rBounds.x), Math.max(c.y, rBounds.y), Math.min((int)Math.round(c.getMaxX()), (int)Math.round(rBounds.getMaxX())), Math.min((int)Math.round(c.getMaxY()), (int)Math.round(rBounds.getMaxY())));
    }

    public void drawClipGlyphVector(WritableRaster raster, Object color, GlyphVector glyphVector, int x, int y, int cMinX, int cMinY, int cMaxX, int cMaxY) {
        for (int i = 0; i < glyphVector.getNumGlyphs(); ++i) {
            int clHeight;
            int clWidth;
            byte[] data;
            Glyph gl = ((CommonGlyphVector)glyphVector).vector[i];
            if (gl.getPointWidth() == 0 || (data = gl.getBitmap()) == null) continue;
            Point2D pos = glyphVector.getGlyphPosition(i);
            int xSrcSurf = 0;
            int ySrcSurf = 0;
            int xDstSurf = x + (int)pos.getX() + (int)gl.getGlyphPointMetrics().getLSB();
            int yDstSurf = y - gl.bmp_top + (int)pos.getY();
            int textWidth = gl.bmp_width;
            int textHeight = gl.getPointHeight();
            if (xDstSurf > cMaxX || yDstSurf > cMaxY || xDstSurf + textWidth < cMinX || yDstSurf + textHeight < cMinY) continue;
            if (xDstSurf >= cMinX) {
                clWidth = Math.min(textWidth, cMaxX - xDstSurf);
            } else {
                xSrcSurf += cMinX - xDstSurf;
                clWidth = Math.min(cMaxX - cMinX, textWidth - (cMinX - xDstSurf));
                xDstSurf = cMinX;
            }
            if (yDstSurf >= cMinY) {
                clHeight = Math.min(textHeight, cMaxY - yDstSurf);
            } else {
                ySrcSurf += cMinY - yDstSurf;
                clHeight = Math.min(cMaxY - cMinY, textHeight - (cMinY - yDstSurf));
                yDstSurf = cMinY;
            }
            for (int h = 0; h < clHeight; ++h) {
                for (int w = 0; w < clWidth; ++w) {
                    boolean emptyByte;
                    byte currByte = data[(ySrcSurf + h) * gl.bmp_pitch + (xSrcSurf + w) / 8];
                    boolean bl = emptyByte = (currByte & 1 << 7 - (xSrcSurf + w) % 8) != 0;
                    if (!emptyByte) continue;
                    raster.setDataElements(xDstSurf + w, yDstSurf + h, color);
                }
            }
        }
    }

    public void drawClipString(WritableRaster raster, Object color, String str, FontPeerImpl font, int x, int y, int cMinX, int cMinY, int cMaxX, int cMaxY) {
        char[] chars = str.toCharArray();
        int xBaseLine = x;
        int yBaseLine = y;
        for (char element : chars) {
            Glyph gl = font.getGlyph(element);
            GlyphMetrics pointMetrics = gl.getGlyphPointMetrics();
            if (gl.getWidth() == 0) {
                xBaseLine = (int)((float)xBaseLine + pointMetrics.getAdvanceX());
                continue;
            }
            byte[] data = gl.getBitmap();
            if (data == null) {
                xBaseLine = (int)((float)xBaseLine + pointMetrics.getAdvanceX());
                continue;
            }
            int xSrcSurf = 0;
            int ySrcSurf = 0;
            int xDstSurf = Math.round((float)xBaseLine + gl.getGlyphPointMetrics().getLSB());
            int yDstSurf = yBaseLine - gl.bmp_top;
            int textWidth = gl.bmp_width;
            int textHeight = gl.getPointHeight();
            if (xDstSurf <= cMaxX && yDstSurf <= cMaxY && xDstSurf + textWidth >= cMinX && yDstSurf + textHeight >= cMinY) {
                int clHeight;
                int clWidth;
                if (xDstSurf >= cMinX) {
                    clWidth = Math.min(textWidth, cMaxX - xDstSurf);
                } else {
                    xSrcSurf += cMinX - xDstSurf;
                    clWidth = Math.min(cMaxX - cMinX, textWidth - (cMinX - xDstSurf));
                    xDstSurf = cMinX;
                }
                if (yDstSurf >= cMinY) {
                    clHeight = Math.min(textHeight, cMaxY - yDstSurf);
                } else {
                    ySrcSurf += cMinY - yDstSurf;
                    clHeight = Math.min(cMaxY - cMinY, textHeight - (cMinY - yDstSurf));
                    yDstSurf = cMinY;
                }
                for (int h = 0; h < clHeight; ++h) {
                    for (int w = 0; w < clWidth; ++w) {
                        boolean emptyByte;
                        byte currByte = data[(ySrcSurf + h) * gl.bmp_pitch + (xSrcSurf + w) / 8];
                        boolean bl = emptyByte = (currByte & 1 << 7 - (xSrcSurf + w) % 8) != 0;
                        if (!emptyByte) continue;
                        raster.setDataElements(xDstSurf + w, yDstSurf + h, color);
                    }
                }
            }
            xBaseLine = (int)((float)xBaseLine + pointMetrics.getAdvanceX());
        }
    }
}

