/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.render;

import org.apache.harmony.awt.gl.MultiRectArea;

public class JavaLineRasterizer {
    static int clip(int dX1, int dX2, int cX, boolean top) {
        int adX2;
        int adX1 = dX1 < 0 ? -dX1 : dX1;
        int n = adX2 = dX2 < 0 ? -dX2 : dX2;
        if (adX1 <= adX2) {
            return ((dX1 << 1) * cX + (dX1 > 0 ? dX2 : -dX2)) / (dX2 << 1);
        }
        int k = top ? -dX1 + (dX2 < 0 ? 0 : (dX1 > 0 ? dX2 << 1 : -(dX2 << 1))) : dX1 + (dX2 > 0 ? 0 : (dX1 > 0 ? dX2 << 1 : -(dX2 << 1)));
        return ((dX1 << 1) * cX + (k += dX1 > 0 == dX2 > 0 ? -1 : 1)) / (dX2 << 1);
    }

    static int clipX(int dx, int dy, int cy, boolean top) {
        return JavaLineRasterizer.clip(dy, dx, cy, top);
    }

    static int clipY(int dx, int dy, int cx, boolean top) {
        return JavaLineRasterizer.clip(dx, dy, cx, top);
    }

    public static MultiRectArea rasterize(int x1, int y1, int x2, int y2, MultiRectArea clip, LineDasher dasher, boolean invert) {
        MultiRectArea dst = new MultiRectArea(false);
        int dx = x2 - x1;
        int dy = y2 - y1;
        if (dx == 0 && dy == 0) {
            if ((clip == null || clip.contains(x1, y1)) && (dasher == null || dasher.visible)) {
                dst = new MultiRectArea(x1, y1, x1, y1);
            }
            return dst;
        }
        if (dy < 0) {
            return JavaLineRasterizer.rasterize(x2, y2, x1, y1, clip, dasher, true);
        }
        Line line = dasher == null ? (dx == 0 ? new Line.Ortog.Ver(x1, y1, x2, y2, dst) : (dy == 0 ? new Line.Ortog.Hor(x1, y1, x2, y2, dst) : (dy < Math.abs(dx) ? new Line.Diag.Hor(x1, y1, x2, y2, dst) : new Line.Diag.Ver(x1, y1, x2, y2, dst)))) : (dx == 0 ? new Line.Ortog.VerDashed(x1, y1, x2, y2, dst, dasher, invert) : (dy == 0 ? new Line.Ortog.HorDashed(x1, y1, x2, y2, dst, dasher) : (dy < Math.abs(dx) ? new Line.Diag.HorDashed(x1, y1, x2, y2, dst, dasher, invert) : new Line.Diag.VerDashed(x1, y1, x2, y2, dst, dasher, invert))));
        if (clip == null || clip.isEmpty()) {
            line.rasterize();
        } else {
            for (int i = 1; i < clip.rect[0]; i += 4) {
                line.rasterize(clip.rect, i);
            }
        }
        return dst;
    }

    static abstract class Line {
        int x1;
        int y1;
        int x2;
        int y2;
        int x;
        int y;
        MultiRectArea dst;

        Line(int x1, int y1, int x2, int y2, MultiRectArea dst) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.dst = dst;
        }

        abstract void rasterize();

        abstract void rasterize(int[] var1, int var2);

        abstract void rasterize(int var1);

        abstract void skip(int var1);

        void rasterizeDash(int count, LineDasher dasher) {
            float delta = dasher.dash[dasher.index] - dasher.phase;
            int step = (int)delta;
            delta -= (float)step;
            while (count > step) {
                if (dasher.visible) {
                    this.rasterize(step);
                } else {
                    this.skip(step);
                }
                count -= step;
                step = (int)(delta += dasher.nextDash());
                delta -= (float)step;
            }
            if (count > 0 && dasher.visible) {
                this.rasterize(count);
                dasher.move(count);
            }
        }

        static abstract class Ortog
        extends Line {
            Ortog(int x1, int y1, int x2, int y2, MultiRectArea dst) {
                super(x1, y1, x2, y2, dst);
            }

            static class VerDashed
            extends Ver {
                LineDasher local;

                VerDashed(int x1, int y1, int x2, int y2, MultiRectArea dst, LineDasher dasher, boolean invert) {
                    super(x1, y1, x2, y2, dst);
                    this.dy = y2 - y1;
                    this.local = dasher.createOrtogonal(this.dy, invert);
                }

                @Override
                void rasterize() {
                    this.x = this.x1;
                    this.y = this.y1;
                    this.rasterizeDash(this.dy, this.local);
                }

                @Override
                void rasterizeClipped(int ny1, int ny2) {
                    this.x = this.x1;
                    this.y = ny1;
                    this.rasterizeDash(ny2 - ny1, this.local.createChild(ny1));
                }
            }

            static class HorDashed
            extends Hor {
                LineDasher local;

                HorDashed(int x1, int y1, int x2, int y2, MultiRectArea dst, LineDasher dasher) {
                    super(x1, y1, x2, y2, dst);
                    this.dx = x2 - x1;
                    this.local = dasher.createOrtogonal(Math.abs(this.dx), false);
                }

                @Override
                void rasterize() {
                    this.x = this.x1;
                    this.y = this.y1;
                    this.rasterizeDash(Math.abs(this.dx), this.local);
                }

                @Override
                void rasterizeClipped(int nx1, int nx2) {
                    this.x = nx1;
                    this.y = this.y1;
                    this.rasterizeDash(Math.abs(nx2 - nx1), this.local.createChild(Math.abs(nx1 - this.x1)));
                }
            }

            static class Ver
            extends Ortog {
                int dy;

                Ver(int x1, int y1, int x2, int y2, MultiRectArea dst) {
                    super(x1, y1, x2, y2, dst);
                    this.dy = y2 - y1;
                }

                @Override
                void rasterize() {
                    this.dst.addRect(this.x1, this.y1, this.x2, this.y2);
                }

                @Override
                void rasterize(int step) {
                    int py = this.y;
                    this.y += step;
                    this.dst.addRect(this.x1, py, this.x2, this.y - 1);
                }

                @Override
                void skip(int step) {
                    this.y += step;
                }

                void rasterizeClipped(int ny1, int ny2) {
                    this.dst.addRect(this.x1, ny1, this.x1, ny2);
                }

                @Override
                void rasterize(int[] clip, int index) {
                    if (this.x1 >= clip[index] && this.x1 <= clip[index + 2]) {
                        int cy1 = clip[index + 1];
                        int cy2 = clip[index + 3];
                        if (this.y1 <= cy2 && this.y2 >= cy1) {
                            this.rasterizeClipped(Math.max(this.y1, cy1), Math.min(this.y2, cy2));
                        }
                    }
                }
            }

            static class Hor
            extends Ortog {
                int dx;

                Hor(int x1, int y1, int x2, int y2, MultiRectArea dst) {
                    super(x1, y1, x2, y2, dst);
                    this.dx = x2 - x1;
                }

                @Override
                void rasterize() {
                    if (this.dx > 0) {
                        this.dst.addRect(this.x1, this.y1, this.x2, this.y2);
                    } else {
                        this.dst.addRect(this.x2, this.y2, this.x1, this.y1);
                    }
                }

                @Override
                void rasterize(int step) {
                    int px = this.x;
                    if (this.dx > 0) {
                        this.x += step;
                        this.dst.addRect(px, this.y1, this.x - 1, this.y2);
                    } else {
                        this.x -= step;
                        this.dst.addRect(this.x + 1, this.y2, px, this.y1);
                    }
                }

                @Override
                void skip(int step) {
                    this.x = this.dx > 0 ? (this.x += step) : (this.x -= step);
                }

                void rasterizeClipped(int nx1, int nx2) {
                    if (nx1 < nx2) {
                        this.dst.addRect(nx1, this.y1, nx2, this.y1);
                    } else {
                        this.dst.addRect(nx2, this.y1, nx1, this.y1);
                    }
                }

                @Override
                void rasterize(int[] clip, int index) {
                    if (this.y1 >= clip[index + 1] && this.y1 <= clip[index + 3]) {
                        int cx1 = clip[index + 0];
                        int cx2 = clip[index + 2];
                        if (this.x1 <= cx2 && this.x2 >= cx1) {
                            int nx2;
                            int nx1;
                            if (this.dx > 0) {
                                nx1 = Math.max(this.x1, cx1);
                                nx2 = Math.min(this.x2, cx2);
                            } else {
                                nx2 = Math.max(this.x2, cx1);
                                nx1 = Math.min(this.x1, cx2);
                            }
                            this.rasterizeClipped(nx1, nx2);
                        }
                    }
                }
            }
        }

        static abstract class Diag
        extends Line {
            int dx;
            int dy;
            int adx;
            int ady;
            int sx;
            int sy;
            int eBase;
            int ePos;
            int eNeg;
            int xcount;
            int e;

            Diag(int x1, int y1, int x2, int y2, MultiRectArea dst) {
                super(x1, y1, x2, y2, dst);
                this.dx = x2 - x1;
                this.dy = y2 - y1;
                this.sy = 1;
                if (this.dx > 0) {
                    this.adx = this.dx;
                    this.sx = 1;
                } else {
                    this.adx = -this.dx;
                    this.sx = -1;
                }
                this.ady = this.dy;
            }

            float getLength() {
                return (float)Math.sqrt(this.dx * this.dx + this.dy * this.dy);
            }

            @Override
            void rasterize(int[] clip, int index) {
                int code2;
                int cy2;
                int cy1;
                int cx2;
                int cx1 = clip[index + 0];
                int code1 = (this.x1 < cx1 ? 1 : 0) | (this.x1 >= (cx2 = clip[index + 2] + 1) ? 2 : 0) | (this.y1 < (cy1 = clip[index + 1]) ? 8 : 0) | (this.y1 >= (cy2 = clip[index + 3] + 1) ? 4 : 0);
                if ((code1 & (code2 = (this.x2 < cx1 ? 1 : 0) | (this.x2 >= cx2 ? 2 : 0) | (this.y2 < cy1 ? 8 : 0) | (this.y2 >= cy2 ? 4 : 0))) != 0) {
                    return;
                }
                if (code1 == 0 && code2 == 0) {
                    this.rasterize();
                    return;
                }
                int nx1 = this.x1;
                int ny1 = this.y1;
                int nx2 = this.x2;
                int ny2 = this.y2;
                cx1 -= this.x1;
                cx2 -= this.x1;
                cy1 -= this.y1;
                cy2 -= this.y1;
                int newx1 = 0;
                int newy1 = 0;
                int newx2 = 0;
                int newy2 = 0;
                if (code1 != 0) {
                    newx1 = Integer.MAX_VALUE;
                    if ((code1 & 8) != 0) {
                        newy1 = cy1;
                        newx1 = JavaLineRasterizer.clipY(this.dx, this.dy, newy1, true);
                    } else if ((code1 & 4) != 0) {
                        newy1 = cy2 - 1;
                        newx1 = JavaLineRasterizer.clipY(this.dx, this.dy, newy1, false);
                    }
                    if ((code1 & 1) != 0 && (cx1 > newx1 || newx1 == Integer.MAX_VALUE)) {
                        newx1 = cx1;
                        newy1 = JavaLineRasterizer.clipX(this.dx, this.dy, newx1, false);
                    } else if ((code1 & 2) != 0 && (newx1 >= cx2 || newx1 == Integer.MAX_VALUE)) {
                        newx1 = cx2 - 1;
                        newy1 = JavaLineRasterizer.clipX(this.dx, this.dy, newx1, false);
                    }
                    if (newx1 < cx1 || newx1 >= cx2 || newy1 < cy1 || newy1 >= cy2) {
                        return;
                    }
                }
                if (code2 != 0) {
                    newx2 = Integer.MAX_VALUE;
                    if ((code2 & 8) != 0) {
                        newy2 = cy1;
                        newx2 = JavaLineRasterizer.clipY(this.dx, this.dy, newy2, true);
                    } else if ((code2 & 4) != 0) {
                        newy2 = cy2 - 1;
                        newx2 = JavaLineRasterizer.clipY(this.dx, this.dy, newy2, false);
                    }
                    if ((code2 & 1) != 0 && (cx1 > newx2 || newx2 == Integer.MAX_VALUE)) {
                        newx2 = cx1;
                        newy2 = JavaLineRasterizer.clipX(this.dx, this.dy, newx2, false);
                    } else if ((code2 & 2) != 0 && (newx2 >= cx2 || newx2 == Integer.MAX_VALUE)) {
                        newx2 = cx2 - 1;
                        newy2 = JavaLineRasterizer.clipX(this.dx, this.dy, newx2, false);
                    }
                    if (newx2 < cx1 || newx2 >= cx2 || newy2 < cy1 || newy2 >= cy2) {
                        return;
                    }
                    nx2 = this.x1 + newx2;
                    ny2 = this.y1 + newy2;
                }
                nx1 = this.x1 + newx1;
                ny1 = this.y1 + newy1;
                this.rasterizeClipped(nx1, ny1, nx2, ny2);
            }

            abstract void rasterizeClipped(int var1, int var2, int var3, int var4);

            static class VerDashed
            extends Ver {
                LineDasher local;

                VerDashed(int x1, int y1, int x2, int y2, MultiRectArea dst, LineDasher dasher, boolean invert) {
                    super(x1, y1, x2, y2, dst);
                    float length = this.getLength();
                    this.local = dasher.createDiagonal((float)this.xcount / length, length, invert);
                }

                @Override
                void rasterize() {
                    this.e = this.eBase;
                    this.x = this.x1;
                    this.y = this.y1;
                    this.rasterizeDash(this.xcount, this.local);
                }

                @Override
                void rasterizeClipped(int nx1, int ny1, int nx2, int ny2) {
                    this.e = this.eBase + 2 * (this.adx * Math.abs(ny1 - this.y1) - this.ady * Math.abs(nx1 - this.x1));
                    this.x = nx1;
                    this.y = ny1;
                    this.rasterizeDash(ny2 - ny1, this.local.createChild(ny1 - this.y1));
                }
            }

            static class HorDashed
            extends Hor {
                LineDasher local;

                HorDashed(int x1, int y1, int x2, int y2, MultiRectArea dst, LineDasher dasher, boolean invert) {
                    super(x1, y1, x2, y2, dst);
                    float length = this.getLength();
                    this.local = dasher.createDiagonal((float)this.xcount / length, length, invert);
                }

                @Override
                void rasterize() {
                    this.e = this.eBase;
                    this.x = this.x1;
                    this.y = this.y1;
                    this.rasterizeDash(this.xcount, this.local);
                }

                @Override
                void rasterizeClipped(int nx1, int ny1, int nx2, int ny2) {
                    this.e = this.eBase + 2 * (this.ady * Math.abs(nx1 - this.x1) - this.adx * Math.abs(ny1 - this.y1));
                    this.x = nx1;
                    this.y = ny1;
                    this.rasterizeDash(Math.abs(nx2 - nx1), this.local.createChild(Math.abs(nx1 - this.x1)));
                }
            }

            static class Ver
            extends Diag {
                Ver(int x1, int y1, int x2, int y2, MultiRectArea dst) {
                    super(x1, y1, x2, y2, dst);
                    this.eBase = this.adx + this.adx - this.ady;
                    this.ePos = 2 * (this.adx - this.ady);
                    this.eNeg = this.adx + this.adx;
                    this.xcount = this.ady;
                }

                @Override
                void rasterize() {
                    this.e = this.eBase;
                    this.x = this.x1;
                    this.y = this.y1;
                    this.rasterize(this.xcount);
                }

                @Override
                void rasterizeClipped(int nx1, int ny1, int nx2, int ny2) {
                    this.e = this.eBase + 2 * (this.adx * Math.abs(ny1 - this.y1) - this.ady * Math.abs(nx1 - this.x1));
                    this.x = nx1;
                    this.y = ny1;
                    this.rasterize(ny2 - ny1);
                }

                @Override
                void rasterize(int count) {
                    int py = this.y;
                    while (count-- > 0) {
                        if (this.e >= 0) {
                            this.dst.addRect(this.x, py, this.x, this.y);
                            this.x += this.sx;
                            this.y += this.sy;
                            this.e += this.ePos;
                            py = this.y;
                            continue;
                        }
                        this.y += this.sy;
                        this.e += this.eNeg;
                    }
                    this.dst.addRect(this.x, py, this.x, this.y);
                }

                @Override
                void skip(int count) {
                    while (count-- > 0) {
                        this.y += this.sy;
                        if (this.e >= 0) {
                            this.x += this.sx;
                            this.e += this.ePos;
                            continue;
                        }
                        this.e += this.eNeg;
                    }
                }
            }

            static class Hor
            extends Diag {
                Hor(int x1, int y1, int x2, int y2, MultiRectArea dst) {
                    super(x1, y1, x2, y2, dst);
                    this.eBase = this.ady + this.ady - this.adx;
                    this.ePos = 2 * (this.ady - this.adx);
                    this.eNeg = this.ady + this.ady;
                    this.xcount = this.adx;
                }

                @Override
                void rasterize() {
                    this.e = this.eBase;
                    this.x = this.x1;
                    this.y = this.y1;
                    this.rasterize(this.xcount);
                }

                @Override
                void rasterizeClipped(int nx1, int ny1, int nx2, int ny2) {
                    this.e = this.eBase + 2 * (this.ady * Math.abs(nx1 - this.x1) - this.adx * Math.abs(ny1 - this.y1));
                    this.x = nx1;
                    this.y = ny1;
                    this.rasterize(this.dx > 0 ? nx2 - nx1 : nx1 - nx2);
                }

                @Override
                void rasterize(int count) {
                    int px = this.x;
                    while (count-- > 0) {
                        if (this.e >= 0) {
                            if (this.sx > 0) {
                                this.dst.addRect(px, this.y, this.x, this.y);
                            } else {
                                this.dst.addRect(this.x, this.y, px, this.y);
                            }
                            this.x += this.sx;
                            this.y += this.sy;
                            this.e += this.ePos;
                            px = this.x;
                            continue;
                        }
                        this.e += this.eNeg;
                        this.x += this.sx;
                    }
                    if (this.sx > 0) {
                        this.dst.addRect(px, this.y, this.x, this.y);
                    } else {
                        this.dst.addRect(this.x, this.y, px, this.y);
                    }
                }

                @Override
                void skip(int count) {
                    while (count-- > 0) {
                        this.x += this.sx;
                        if (this.e >= 0) {
                            this.y += this.sy;
                            this.e += this.ePos;
                            continue;
                        }
                        this.e += this.eNeg;
                    }
                }
            }
        }
    }

    public static class LineDasher {
        int index;
        float pos;
        float phase;
        float[] dash;
        float[] inv;
        boolean visible;

        public LineDasher() {
        }

        public LineDasher(float[] dash, float phase) {
            this.dash = dash;
            this.phase = phase;
            this.inv = new float[dash.length];
            int j = dash.length;
            for (float element : dash) {
                this.inv[--j] = element;
            }
            this.index = 0;
            while (phase > dash[this.index]) {
                phase -= dash[this.index];
                this.index = (this.index + 1) % dash.length;
            }
            this.visible = this.index % 2 == 0;
        }

        void move(float step) {
            this.pos += step;
            step += this.phase;
            while (step >= this.dash[this.index]) {
                step -= this.dash[this.index];
                this.index = (this.index + 1) % this.dash.length;
                this.visible = !this.visible;
            }
            this.phase = step;
        }

        float nextDash() {
            this.phase = 0.0f;
            this.index = (this.index + 1) % this.dash.length;
            this.visible = !this.visible;
            return this.dash[this.index];
        }

        LineDasher createDiagonal(double k, float length, boolean invert) {
            LineDasher local = new LineDasher();
            local.dash = new float[this.dash.length];
            if (invert) {
                this.move(length);
                local.phase = (float)((double)(this.dash[this.index] - this.phase) * k);
                local.visible = this.visible;
                local.index = this.inv.length - this.index - 1;
                for (int i = 0; i < this.inv.length; ++i) {
                    local.dash[i] = (float)((double)this.inv[i] * k);
                }
            } else {
                local.phase = (float)((double)this.phase * k);
                local.visible = this.visible;
                local.index = this.index;
                for (int i = 0; i < this.dash.length; ++i) {
                    local.dash[i] = (float)((double)this.dash[i] * k);
                }
                this.move(length);
            }
            return local;
        }

        LineDasher createOrtogonal(float length, boolean invert) {
            LineDasher local = new LineDasher();
            local.dash = new float[this.dash.length];
            if (invert) {
                this.move(length);
                local.phase = this.dash[this.index] - this.phase;
                local.visible = this.visible;
                local.index = this.inv.length - this.index - 1;
                local.dash = this.inv;
            } else {
                local.phase = this.phase;
                local.visible = this.visible;
                local.index = this.index;
                local.dash = this.dash;
                this.move(length);
            }
            return local;
        }

        LineDasher createChild(float start) {
            LineDasher child = new LineDasher();
            child.phase = this.phase;
            child.visible = this.visible;
            child.index = this.index;
            child.dash = this.dash;
            child.move(start);
            return child;
        }
    }
}

