/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.harmony.awt.gl.image.DecodingImageSource;
import org.apache.harmony.awt.gl.image.ImageDecoder;
import org.apache.harmony.awt.internal.nls.Messages;

public class PngDecoder
extends ImageDecoder {
    private static final int hintflags = 22;
    private static final int PNG_COLOR_TYPE_GRAY = 0;
    private static final int PNG_COLOR_TYPE_RGB = 2;
    private static final int PNG_COLOR_TYPE_PLTE = 3;
    private static final int PNG_COLOR_TYPE_GRAY_ALPHA = 4;
    private static final int PNG_COLOR_TYPE_RGBA = 6;
    private static final int MIN_BUFFER_SIZE = 4096;
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private int buffer_size;
    private byte[] buffer;
    byte[] byteOut;
    int[] intOut;
    private long hNativeDecoder;
    int imageWidth;
    int imageHeight;
    int colorType;
    int bitDepth;
    byte[] cmap;
    boolean transferInts;
    int dataElementsPerPixel = 1;
    ColorModel cm;
    int updateFromScanline;
    int numScanlines;

    private native long decode(byte[] var1, int var2, long var3);

    private static native void releaseNativeDecoder(long var0);

    public PngDecoder(DecodingImageSource src, InputStream is) {
        super(src, is);
        try {
            int available_bytes = is.available();
            this.buffer_size = available_bytes < 4096 ? 4096 : (available_bytes > 0x200000 ? 0x200000 : available_bytes);
        }
        catch (IOException e) {
            this.buffer_size = 4096;
        }
        this.buffer = new byte[this.buffer_size];
    }

    @Override
    public void decodeImage() throws IOException {
        try {
            int bytesRead = 0;
            do {
                if ((bytesRead = this.inputStream.read(this.buffer, 0, this.buffer_size)) < 0) {
                    PngDecoder.releaseNativeDecoder(this.hNativeDecoder);
                    break;
                }
                this.hNativeDecoder = this.decode(this.buffer, bytesRead, this.hNativeDecoder);
                this.returnData();
            } while (this.hNativeDecoder != 0L);
            this.imageComplete(3);
        }
        catch (IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.imageComplete(1);
            throw e;
        }
        finally {
            this.closeStream();
        }
    }

    private void returnHeader() {
        this.setDimensions(this.imageWidth, this.imageHeight);
        switch (this.colorType) {
            case 0: {
                if (this.bitDepth != 8 && this.bitDepth != 4 && this.bitDepth != 2 && this.bitDepth != 1) {
                    throw new IllegalArgumentException(Messages.getString("awt.3C"));
                }
                int numEntries = 1 << this.bitDepth;
                int scaleFactor = 255 / (numEntries - 1);
                byte[] comps = new byte[numEntries];
                for (int i = 0; i < numEntries; ++i) {
                    comps[i] = (byte)(i * scaleFactor);
                }
                this.cm = new IndexColorModel(8, numEntries, comps, comps, comps);
                this.transferInts = false;
                break;
            }
            case 2: {
                if (this.bitDepth != 8) {
                    throw new IllegalArgumentException(Messages.getString("awt.3C"));
                }
                this.cm = new DirectColorModel(24, 0xFF0000, 65280, 255);
                this.transferInts = true;
                break;
            }
            case 3: {
                if (this.bitDepth != 8 && this.bitDepth != 4 && this.bitDepth != 2 && this.bitDepth != 1) {
                    throw new IllegalArgumentException(Messages.getString("awt.3C"));
                }
                this.cm = new IndexColorModel(8, this.cmap.length / 3, this.cmap, 0, false);
                this.transferInts = false;
                break;
            }
            case 4: {
                if (this.bitDepth != 8) {
                    throw new IllegalArgumentException(Messages.getString("awt.3C"));
                }
                this.cm = new ComponentColorModel(ColorSpace.getInstance(1003), true, false, 3, 0);
                this.transferInts = false;
                this.dataElementsPerPixel = 2;
                break;
            }
            case 6: {
                if (this.bitDepth != 8) {
                    throw new IllegalArgumentException(Messages.getString("awt.3C"));
                }
                this.cm = ColorModel.getRGBdefault();
                this.transferInts = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.3C"));
            }
        }
        if (this.transferInts) {
            this.intOut = new int[this.imageWidth * this.imageHeight];
        } else {
            this.byteOut = new byte[this.imageWidth * this.imageHeight * this.dataElementsPerPixel];
        }
        this.setColorModel(this.cm);
        this.setHints(22);
        this.setProperties(new Hashtable());
    }

    private void returnData() {
        if (this.numScanlines > 0) {
            int pass2;
            int pass1;
            if (this.updateFromScanline + this.numScanlines > this.imageHeight) {
                pass1 = this.imageHeight - this.updateFromScanline;
                pass2 = this.updateFromScanline + this.numScanlines - this.imageHeight;
            } else {
                pass1 = this.numScanlines;
                pass2 = 0;
            }
            this.transfer(this.updateFromScanline, pass1);
            if (pass2 != 0) {
                this.transfer(0, pass2);
            }
        }
    }

    private void transfer(int updateFromScanline, int numScanlines) {
        if (this.transferInts) {
            this.setPixels(0, updateFromScanline, this.imageWidth, numScanlines, this.cm, this.intOut, updateFromScanline * this.imageWidth, this.imageWidth);
        } else {
            this.setPixels(0, updateFromScanline, this.imageWidth, numScanlines, this.cm, this.byteOut, updateFromScanline * this.imageWidth * this.dataElementsPerPixel, this.imageWidth * this.dataElementsPerPixel);
        }
    }
}

