/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.harmony.awt.gl.AwtImageBackdoorAccessor;
import org.apache.harmony.awt.gl.ImageSurface;
import org.apache.harmony.awt.internal.nls.Messages;

public class OffscreenImage
extends Image
implements ImageConsumer {
    static final ColorModel rgbCM = ColorModel.getRGBdefault();
    ImageProducer src;
    BufferedImage image;
    ColorModel cm;
    WritableRaster raster;
    boolean isIntRGB;
    Hashtable<?, ?> properties;
    Vector<ImageObserver> observers;
    int width;
    int height;
    int imageState = 0;
    int hints;
    private boolean producing;
    private boolean done;
    private ImageSurface imageSurf;
    AwtImageBackdoorAccessor ba = AwtImageBackdoorAccessor.getInstance();

    public OffscreenImage(ImageProducer ip) {
        this.src = ip;
        this.width = -1;
        this.height = -1;
        this.observers = new Vector();
        this.producing = false;
        this.done = false;
    }

    @Override
    public Object getProperty(String name, ImageObserver observer) {
        if (name == null) {
            throw new NullPointerException(Messages.getString("awt.38"));
        }
        if (!this.done && this.properties == null) {
            this.startProduction(observer);
        }
        if (this.properties == null) {
            return null;
        }
        Object prop = this.properties.get(name);
        if (prop == null) {
            prop = UndefinedProperty;
        }
        return prop;
    }

    @Override
    public ImageProducer getSource() {
        return this.src;
    }

    @Override
    public int getWidth(ImageObserver observer) {
        if (!this.done && (this.imageState & 1) == 0) {
            this.startProduction(observer);
        }
        return this.width;
    }

    @Override
    public int getHeight(ImageObserver observer) {
        if (!this.done && (this.imageState & 2) == 0) {
            this.startProduction(observer);
        }
        return this.height;
    }

    @Override
    public Graphics getGraphics() {
        throw new UnsupportedOperationException(Messages.getString("awt.39"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        this.imageUpdate(128, -1, -1, -1, -1);
        OffscreenImage offscreenImage = this;
        synchronized (offscreenImage) {
            this.imageState = 0;
            this.image = null;
            this.imageSurf = null;
            this.cm = null;
            this.raster = null;
            this.hints = 0;
            this.width = -1;
            this.height = -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperties(Hashtable<?, ?> properties) {
        OffscreenImage offscreenImage = this;
        synchronized (offscreenImage) {
            this.properties = properties;
        }
        this.imageUpdate(4);
    }

    @Override
    public synchronized void setColorModel(ColorModel cm) {
        this.cm = cm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        Object surfData;
        if (this.raster == null) {
            if (this.cm == null) {
                if (model == null) {
                    throw new NullPointerException(Messages.getString("awt.3A"));
                }
                this.cm = model;
            }
            this.createRaster();
        }
        if (model == null) {
            model = this.cm;
        }
        if (this.cm != model) {
            this.forceToIntARGB();
        }
        DataBuffer db = this.raster.getDataBuffer();
        Object object = surfData = this.ba.getData(db);
        synchronized (object) {
            if (this.cm == model && model.getTransferType() == 3 && this.raster.getNumDataElements() == 1) {
                int[] data = (int[])surfData;
                int scanline = this.raster.getWidth();
                DataBufferInt dbi = (DataBufferInt)db;
                int rof = dbi.getOffset() + y * scanline + x;
                int lineOff = off;
                int line = y;
                while (line < y + h) {
                    System.arraycopy(pixels, lineOff, data, rof, w);
                    ++line;
                    lineOff += scansize;
                    rof += scanline;
                }
            } else if (this.isIntRGB) {
                int[] buff = new int[w];
                int[] data = (int[])surfData;
                int scanline = this.raster.getWidth();
                DataBufferInt dbi = (DataBufferInt)db;
                int rof = dbi.getOffset() + y * scanline + x;
                int sy = y;
                int sOff = off;
                while (sy < y + h) {
                    int sx = x;
                    int idx = 0;
                    while (sx < x + w) {
                        buff[idx] = model.getRGB(pixels[sOff + idx]);
                        ++sx;
                        ++idx;
                    }
                    System.arraycopy(buff, 0, data, rof, w);
                    ++sy;
                    sOff += scansize;
                    rof += scanline;
                }
            } else {
                Object buf = null;
                int sy = y;
                int sOff = off;
                while (sy < y + h) {
                    int sx = x;
                    int idx = 0;
                    while (sx < x + w) {
                        int rgb = model.getRGB(pixels[sOff + idx]);
                        buf = this.cm.getDataElements(rgb, buf);
                        this.raster.setDataElements(sx, sy, buf);
                        ++sx;
                        ++idx;
                    }
                    ++sy;
                    sOff += scansize;
                }
            }
        }
        this.ba.releaseData(db);
        if (this.imageSurf != null) {
            this.imageSurf.addDirtyRegion(new Rectangle(x, y, w, h));
        }
        this.imageUpdate(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        Object surfData;
        if (this.raster == null) {
            if (this.cm == null) {
                if (model == null) {
                    throw new NullPointerException(Messages.getString("awt.3A"));
                }
                this.cm = model;
            }
            this.createRaster();
        }
        if (model == null) {
            model = this.cm;
        }
        if (model != this.cm && this.cm != rgbCM) {
            this.forceToIntARGB();
        }
        DataBuffer db = this.raster.getDataBuffer();
        Object object = surfData = this.ba.getData(db);
        synchronized (object) {
            if (this.isIntRGB) {
                int[] buff = new int[w];
                int[] data = (int[])surfData;
                int scanline = this.raster.getWidth();
                DataBufferInt dbi = (DataBufferInt)db;
                int rof = dbi.getOffset() + y * scanline + x;
                if (model instanceof IndexColorModel) {
                    IndexColorModel icm = (IndexColorModel)model;
                    int[] colorMap = new int[icm.getMapSize()];
                    icm.getRGBs(colorMap);
                    int sy = y;
                    int sOff = off;
                    while (sy < y + h) {
                        int sx = x;
                        int idx = 0;
                        while (sx < x + w) {
                            buff[idx] = colorMap[pixels[sOff + idx] & 0xFF];
                            ++sx;
                            ++idx;
                        }
                        System.arraycopy(buff, 0, data, rof, w);
                        ++sy;
                        sOff += scansize;
                        rof += scanline;
                    }
                } else {
                    int sy = y;
                    int sOff = off;
                    while (sy < y + h) {
                        int sx = x;
                        int idx = 0;
                        while (sx < x + w) {
                            buff[idx] = model.getRGB(pixels[sOff + idx] & 0xFF);
                            ++sx;
                            ++idx;
                        }
                        System.arraycopy(buff, 0, data, rof, w);
                        ++sy;
                        sOff += scansize;
                        rof += scanline;
                    }
                }
            } else if (model == this.cm && model.getTransferType() == 0 && this.raster.getNumDataElements() == 1) {
                byte[] data = (byte[])surfData;
                int scanline = this.raster.getWidth();
                DataBufferByte dbb = (DataBufferByte)db;
                int rof = dbb.getOffset() + y * scanline + x;
                int lineOff = off;
                int line = y;
                while (line < y + h) {
                    System.arraycopy(pixels, lineOff, data, rof, w);
                    ++line;
                    lineOff += scansize;
                    rof += scanline;
                }
            } else if (model == this.cm && model.getTransferType() == 0 && this.cm instanceof ComponentColorModel) {
                byte[] stride = new byte[scansize];
                int sy = y;
                int sOff = off;
                while (sy < y + h) {
                    System.arraycopy(pixels, sOff, stride, 0, scansize);
                    this.raster.setDataElements(x, sy, w, 1, stride);
                    ++sy;
                    sOff += scansize;
                }
            } else {
                int sy = y;
                int sOff = off;
                while (sy < y + h) {
                    int sx = x;
                    int idx = 0;
                    while (sx < x + w) {
                        int rgb = model.getRGB(pixels[sOff + idx] & 0xFF);
                        this.raster.setDataElements(sx, sy, this.cm.getDataElements(rgb, null));
                        ++sx;
                        ++idx;
                    }
                    ++sy;
                    sOff += scansize;
                }
            }
        }
        this.ba.releaseData(db);
        if (this.imageSurf != null) {
            this.imageSurf.addDirtyRegion(new Rectangle(x, y, w, h));
        }
        this.imageUpdate(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDimensions(int width, int height) {
        if (width <= 0 || height <= 0) {
            this.imageComplete(1);
            return;
        }
        OffscreenImage offscreenImage = this;
        synchronized (offscreenImage) {
            this.width = width;
            this.height = height;
        }
        this.imageUpdate(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHints(int hints) {
        OffscreenImage offscreenImage = this;
        synchronized (offscreenImage) {
            this.hints = hints;
        }
    }

    @Override
    public void imageComplete(int state) {
        int flag;
        switch (state) {
            case 4: {
                flag = 128;
                break;
            }
            case 1: {
                flag = 192;
                break;
            }
            case 2: {
                flag = 16;
                break;
            }
            case 3: {
                flag = 32;
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.3B"));
            }
        }
        this.imageUpdate(flag);
        if ((this.imageState & 0xE0) != 0) {
            this.stopProduction();
        }
    }

    public BufferedImage getBufferedImage() {
        if (this.image == null) {
            ColorModel model = this.getColorModel();
            WritableRaster wr = this.getRaster();
            if (model != null && wr != null) {
                this.image = new BufferedImage(model, wr, model.isAlphaPremultiplied(), null);
            }
        }
        return this.image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int checkImage(ImageObserver observer) {
        OffscreenImage offscreenImage = this;
        synchronized (offscreenImage) {
            this.addObserver(observer);
        }
        return this.imageState;
    }

    public boolean prepareImage(ImageObserver observer) {
        if (!this.done) {
            if ((this.imageState & 0x40) != 0) {
                if (observer != null) {
                    observer.imageUpdate(this, 192, -1, -1, -1, -1);
                }
                return false;
            }
            this.startProduction(observer);
        }
        return (this.imageState & 0x20) != 0;
    }

    public ColorModel getColorModel() {
        if (this.cm == null) {
            this.startProduction(null);
        }
        return this.cm;
    }

    public WritableRaster getRaster() {
        if (this.raster == null) {
            this.startProduction(null);
        }
        return this.raster;
    }

    public int getState() {
        return this.imageState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addObserver(ImageObserver observer) {
        if (observer != null) {
            if (this.observers.contains(observer)) {
                return;
            }
            if ((this.imageState & 0x40) != 0) {
                observer.imageUpdate(this, 192, -1, -1, -1, -1);
                return;
            }
            if ((this.imageState & 0x20) != 0) {
                observer.imageUpdate(this, this.imageState, 0, 0, this.width, this.height);
                return;
            }
            Vector<ImageObserver> vector = this.observers;
            synchronized (vector) {
                this.observers.add(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProduction(ImageObserver observer) {
        this.addObserver(observer);
        if (!this.producing && !this.done) {
            OffscreenImage offscreenImage = this;
            synchronized (offscreenImage) {
                this.imageState &= 0xFFFFFF7F;
                this.producing = true;
                this.src.startProduction(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void stopProduction() {
        this.producing = false;
        this.src.removeConsumer(this);
        Vector<ImageObserver> vector = this.observers;
        synchronized (vector) {
            this.observers.clear();
        }
    }

    private void createRaster() {
        try {
            DirectColorModel dcm;
            this.raster = this.cm.createCompatibleWritableRaster(this.width, this.height);
            this.isIntRGB = false;
            if (this.cm instanceof DirectColorModel && (dcm = (DirectColorModel)this.cm).getTransferType() == 3 && dcm.getRedMask() == 0xFF0000 && dcm.getGreenMask() == 65280 && dcm.getBlueMask() == 255) {
                this.isIntRGB = true;
            }
        }
        catch (Exception e) {
            this.cm = ColorModel.getRGBdefault();
            this.raster = this.cm.createCompatibleWritableRaster(this.width, this.height);
            this.isIntRGB = true;
        }
    }

    private void imageUpdate(int state) {
        this.imageUpdate(state, 0, 0, this.width, this.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void imageUpdate(int state, int x, int y, int width, int height) {
        OffscreenImage offscreenImage = this;
        synchronized (offscreenImage) {
            this.imageState |= state;
            if ((this.imageState & 0x20) != 0) {
                this.done = true;
            }
        }
        ImageObserver observer = null;
        Iterator<ImageObserver> i = this.observers.iterator();
        while (i.hasNext()) {
            try {
                observer = i.next();
            }
            catch (ConcurrentModificationException e) {
                i = this.observers.iterator();
                continue;
            }
            observer.imageUpdate(this, this.imageState, x, y, width, height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceToIntARGB() {
        int w = this.raster.getWidth();
        int h = this.raster.getHeight();
        WritableRaster destRaster = rgbCM.createCompatibleWritableRaster(w, h);
        Object obj = null;
        int[] pixels = new int[w];
        if (this.cm instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)this.cm;
            int[] colorMap = new int[icm.getMapSize()];
            icm.getRGBs(colorMap);
            for (int y = 0; y < h; ++y) {
                obj = this.raster.getDataElements(0, y, w, 1, obj);
                byte[] ba = (byte[])obj;
                for (int x = 0; x < ba.length; ++x) {
                    pixels[x] = colorMap[ba[x] & 0xFF];
                }
                destRaster.setDataElements(0, y, w, 1, pixels);
            }
        } else {
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w; ++x) {
                    obj = this.raster.getDataElements(x, y, obj);
                    pixels[x] = this.cm.getRGB(obj);
                }
                destRaster.setDataElements(0, y, w, 1, pixels);
            }
        }
        OffscreenImage offscreenImage = this;
        synchronized (offscreenImage) {
            if (this.imageSurf != null) {
                this.imageSurf.dispose();
                this.imageSurf = null;
            }
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
            this.cm = rgbCM;
            this.raster = destRaster;
            this.isIntRGB = true;
        }
    }

    public ImageSurface getImageSurface() {
        if (this.imageSurf == null) {
            ColorModel model = this.getColorModel();
            WritableRaster wr = this.getRaster();
            if (model != null && wr != null) {
                this.imageSurf = new ImageSurface(model, wr);
            }
        }
        return this.imageSurf;
    }
}

