/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.apache.harmony.awt.Utils;
import org.apache.harmony.awt.gl.image.DecodingImageSource;
import org.apache.harmony.awt.gl.image.ImageDecoder;
import org.apache.harmony.awt.internal.nls.Messages;

public class JpegDecoder
extends ImageDecoder {
    public static final int JCS_GRAYSCALE = 1;
    public static final int JCS_RGB = 2;
    private static final int hintflagsProgressive = 22;
    private static final int hintflagsSingle = 30;
    private static final int MIN_BUFFER_SIZE = 1024;
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private int buffer_size;
    private byte[] buffer;
    private static ColorModel cmRGB;
    private static ColorModel cmGray;
    private long hNativeDecoder = 0L;
    private boolean headerDone = false;
    private int imageWidth = -1;
    private int imageHeight = -1;
    private boolean progressive = false;
    private int jpegColorSpace = 0;
    private int bytesConsumed = 0;
    private int currScanline = 0;
    private ColorModel cm = null;

    public JpegDecoder(DecodingImageSource src, InputStream is) {
        super(src, is);
        try {
            int available_bytes = is.available();
            this.buffer_size = available_bytes < 1024 ? 1024 : (available_bytes > 0x200000 ? 0x200000 : available_bytes);
        }
        catch (IOException e) {
            this.buffer_size = 1024;
        }
        this.buffer = new byte[this.buffer_size];
    }

    private native Object decode(byte[] var1, int var2, long var3);

    private static native void releaseNativeDecoder(long var0);

    @Override
    public void decodeImage() throws IOException {
        try {
            block12: {
                int bytesRead = 0;
                int dataLength = 0;
                boolean eosReached = false;
                int bytesInBuffer = 0;
                byte[] byteOut = null;
                int[] intOut = null;
                do {
                    int needBytes;
                    int offset;
                    if ((bytesRead = this.inputStream.read(this.buffer, offset = bytesInBuffer, needBytes = this.buffer_size - bytesInBuffer)) < 0) {
                        bytesRead = 0;
                        eosReached = true;
                    }
                    Object arr = this.decode(this.buffer, bytesInBuffer += bytesRead, this.hNativeDecoder);
                    bytesInBuffer -= this.bytesConsumed;
                    if (!this.headerDone && this.imageWidth != -1) {
                        this.returnHeader();
                        this.headerDone = true;
                    }
                    if (this.bytesConsumed < 0) break block12;
                    if (arr instanceof byte[]) {
                        byteOut = (byte[])arr;
                        dataLength = byteOut.length;
                        this.returnData(byteOut, this.currScanline);
                    } else if (arr instanceof int[]) {
                        intOut = (int[])arr;
                        dataLength = intOut.length;
                        this.returnData(intOut, this.currScanline);
                    } else {
                        dataLength = 0;
                    }
                    if (this.hNativeDecoder == 0L) break block12;
                } while (dataLength != 0 || !eosReached);
                JpegDecoder.releaseNativeDecoder(this.hNativeDecoder);
            }
            this.imageComplete(3);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            this.closeStream();
        }
    }

    public void returnHeader() {
        this.setDimensions(this.imageWidth, this.imageHeight);
        switch (this.jpegColorSpace) {
            case 1: {
                this.cm = cmGray;
                break;
            }
            case 2: {
                this.cm = cmRGB;
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.3D"));
            }
        }
        this.setColorModel(this.cm);
        this.setHints(this.progressive ? 22 : 30);
        this.setProperties(new Hashtable());
    }

    public void returnData(int[] data, int currScanLine) {
        int numScanlines = data.length / this.imageWidth;
        if (numScanlines > 0) {
            this.setPixels(0, currScanLine - numScanlines, this.imageWidth, numScanlines, this.cm, data, 0, this.imageWidth);
        }
    }

    public void returnData(byte[] data, int currScanLine) {
        int numScanlines = data.length / this.imageWidth;
        if (numScanlines > 0) {
            this.setPixels(0, currScanLine - numScanlines, this.imageWidth, numScanlines, this.cm, data, 0, this.imageWidth);
        }
    }

    static {
        Utils.loadLibrary("jpegdecoder");
        cmGray = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        cmRGB = new DirectColorModel(24, 0xFF0000, 65280, 255);
    }
}

