/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.harmony.awt.gl.image.DecodingImageSource;
import org.apache.harmony.awt.gl.image.ImageDecoder;
import org.apache.harmony.awt.gl.image.ImageLoader;

public class GifDecoder
extends ImageDecoder {
    private static final int baseHints = 28;
    private static final int interlacedHints = 29;
    static final int IMPOSSIBLE_VALUE = 0xFFFFFFF;
    private static final int MIN_BUFFER_SIZE = 1024;
    private static final int MAX_BUFFER_SIZE = 0x200000;
    private int buffer_size;
    private byte[] buffer;
    GifDataStream gifDataStream = new GifDataStream();
    GifGraphicBlock currBlock;
    private long hNativeDecoder;
    private int bytesConsumed;
    private boolean consumersPrepared;
    private Hashtable<String, String> properties = new Hashtable();
    private boolean forceRGB;
    private byte[] screenBuffer;
    private int[] screenRGBBuffer;
    ColorModel gcm;

    public GifDecoder(DecodingImageSource src, InputStream is) {
        super(src, is);
        try {
            int available_bytes = is.available();
            this.buffer_size = available_bytes < 1024 ? 1024 : (available_bytes > 0x200000 ? 0x200000 : available_bytes);
        }
        catch (IOException e) {
            this.buffer_size = 1024;
        }
        this.buffer = new byte[this.buffer_size];
    }

    private int[] getScreenRGBBuffer() {
        if (this.screenRGBBuffer == null) {
            if (this.screenBuffer != null) {
                int transparentColor = this.gifDataStream.logicalScreen.globalColorTable.cm.getTransparentPixel();
                transparentColor = transparentColor > 0 ? transparentColor : 0xFFFFFFF;
            } else {
                int size = this.gifDataStream.logicalScreen.logicalScreenHeight * this.gifDataStream.logicalScreen.logicalScreenWidth;
                this.screenRGBBuffer = new int[size];
            }
        }
        return this.screenRGBBuffer;
    }

    private void prepareConsumers() {
        GifLogicalScreen gls = this.gifDataStream.logicalScreen;
        this.setDimensions(gls.logicalScreenWidth, gls.logicalScreenHeight);
        this.setProperties(this.properties);
        this.currBlock = this.gifDataStream.graphicBlocks.get(0);
        if (this.forceRGB) {
            this.setColorModel(ColorModel.getRGBdefault());
        } else {
            this.gcm = gls.globalColorTable.getColorModel(this.currBlock.transparentColor);
            this.setColorModel(this.gcm);
        }
        if (this.forceRGB) {
            int fillColor = -16777216;
            if (gls.backgroundColor != 0xFFFFFFF) {
                fillColor = gls.backgroundColor;
            }
            Arrays.fill(this.getScreenRGBBuffer(), fillColor);
        } else {
            int fillColor = 0;
            fillColor = gls.backgroundColor != 0xFFFFFFF ? gls.backgroundColor : gls.globalColorTable.cm.getTransparentPixel();
            this.screenBuffer = new byte[gls.logicalScreenHeight * gls.logicalScreenWidth];
            Arrays.fill(this.screenBuffer, (byte)fillColor);
        }
        this.setHints(29);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decodeImage() throws IOException {
        try {
            int numLines;
            int bytesRead = 0;
            int bytesInBuffer = 0;
            boolean eosReached = false;
            GifGraphicBlock blockToDispose = null;
            if (this.currBlock == null) {
                this.currBlock = new GifGraphicBlock();
                this.gifDataStream.graphicBlocks.add(this.currBlock);
            }
            do {
                int needBytes;
                int offset;
                if ((bytesRead = this.inputStream.read(this.buffer, offset = bytesInBuffer, needBytes = this.buffer_size - bytesInBuffer)) < 0) {
                    eosReached = true;
                    bytesRead = 0;
                }
                bytesInBuffer += bytesRead;
                numLines = 0;
                bytesInBuffer -= this.bytesConsumed;
                if (!this.consumersPrepared && this.gifDataStream.logicalScreen.completed && this.gifDataStream.logicalScreen.globalColorTable.completed && (this.currBlock.imageData != null || this.currBlock.rgbImageData != null)) {
                    this.prepareConsumers();
                    this.consumersPrepared = true;
                }
                if (this.bytesConsumed < 0) {
                } else {
                    if (this.currBlock != null) {
                        if (numLines != 0) {
                            if (blockToDispose != null) {
                                blockToDispose.dispose();
                                blockToDispose = null;
                            }
                            this.currBlock.sendNewData(this, numLines);
                        }
                        if (this.currBlock.completed && this.hNativeDecoder != 0L) {
                            blockToDispose = this.currBlock;
                            this.currBlock = new GifGraphicBlock();
                            this.gifDataStream.graphicBlocks.add(this.currBlock);
                        }
                    }
                    if (this.hNativeDecoder != 0L) continue;
                }
                break;
            } while (!eosReached || numLines != 0);
        }
        finally {
            this.closeStream();
        }
        if (this.gifDataStream.loopCount != 1) {
            if (!this.currBlock.completed) {
                this.gifDataStream.graphicBlocks.remove(this.currBlock);
            }
            int numFrames = this.gifDataStream.graphicBlocks.size();
            GifGraphicBlock gb = this.gifDataStream.graphicBlocks.get(numFrames - 1);
            ImageLoader.beginAnimation();
            while (this.gifDataStream.loopCount != 1) {
                if (this.gifDataStream.loopCount != 0) {
                    --this.gifDataStream.loopCount;
                }
                for (int i = 0; i < numFrames; ++i) {
                    gb.dispose();
                    gb = this.gifDataStream.graphicBlocks.get(i);
                    if (this.forceRGB) {
                        this.setPixels(gb.imageLeft, gb.imageTop, gb.imageWidth, gb.imageHeight, ColorModel.getRGBdefault(), gb.getRgbImageData(), 0, gb.imageWidth);
                        continue;
                    }
                    this.setPixels(gb.imageLeft, gb.imageTop, gb.imageWidth, gb.imageHeight, this.gcm, gb.imageData, 0, gb.imageWidth);
                }
            }
            ImageLoader.endAnimation();
        }
        this.imageComplete(3);
    }

    void setComment(String newComment) {
        String currComment = this.properties.get("comment");
        if (currComment == null) {
            this.properties.put("comment", newComment);
        } else {
            this.properties.put("comment", currComment + "\n" + newComment);
        }
        this.setProperties(this.properties);
    }

    class GifColorTable {
        boolean completed = false;
        IndexColorModel cm = null;
        int size = 0;
        byte[] colors = new byte[768];

        GifColorTable() {
        }

        IndexColorModel getColorModel(int transparentColor) {
            if (this.cm != null) {
                if (transparentColor != this.cm.getTransparentPixel()) {
                    this.cm = null;
                    return null;
                }
                return this.cm;
            }
            if (this.completed && this.size > 0) {
                if (transparentColor == 0xFFFFFFF) {
                    this.cm = new IndexColorModel(8, this.size, this.colors, 0, false);
                    return this.cm;
                }
                if (transparentColor > this.size) {
                    this.size = transparentColor + 1;
                }
                this.cm = new IndexColorModel(8, this.size, this.colors, 0, false, transparentColor);
                return this.cm;
            }
            this.cm = null;
            return null;
        }
    }

    class GifGraphicBlock {
        boolean completed = false;
        static final int DISPOSAL_NONE = 0;
        static final int DISPOSAL_NODISPOSAL = 1;
        static final int DISPOSAL_BACKGROUND = 2;
        static final int DISPOSAL_RESTORE = 3;
        int disposalMethod;
        int delayTime;
        int transparentColor = 0xFFFFFFF;
        int imageLeft;
        int imageTop;
        int imageWidth;
        int imageHeight;
        int imageRight;
        int imageBottom;
        boolean interlace;
        byte[] imageData = null;
        int[] rgbImageData = null;
        private int currY = 0;

        GifGraphicBlock() {
        }

        int[] getRgbImageData() {
            if (this.rgbImageData == null && this.transparentColor != 0xFFFFFFF) {
                this.transparentColor = GifDecoder.this.gifDataStream.logicalScreen.globalColorTable.cm.getRGB(this.transparentColor);
                this.transparentColor &= 0xFFFFFF;
            }
            return this.rgbImageData;
        }

        private void replaceTransparentPixels(int numLines) {
            List<GifGraphicBlock> graphicBlocks = GifDecoder.this.gifDataStream.graphicBlocks;
            int prevBlockIndex = graphicBlocks.indexOf(this) - 1;
            if (prevBlockIndex >= 0) {
                int maxY = this.currY + numLines + this.imageTop;
                int offset = this.currY * this.imageWidth;
                this.imageRight = this.imageLeft + this.imageWidth;
                this.imageBottom = this.imageTop + this.imageHeight;
                int globalWidth = GifDecoder.this.gifDataStream.logicalScreen.logicalScreenWidth;
                int[] rgbData = GifDecoder.this.forceRGB ? this.getRgbImageData() : null;
                for (int y = this.currY + this.imageTop; y < maxY; ++y) {
                    int imageOffset = globalWidth * y + this.imageLeft;
                    for (int x = this.imageLeft; x < this.imageRight; ++x) {
                        int pixelValue;
                        int n = pixelValue = GifDecoder.this.forceRGB ? rgbData[offset] : this.imageData[offset] & 0xFF;
                        if (pixelValue == this.transparentColor) {
                            if (GifDecoder.this.forceRGB) {
                                rgbData[offset] = pixelValue = GifDecoder.this.getScreenRGBBuffer()[imageOffset];
                            } else {
                                pixelValue = GifDecoder.this.screenBuffer[imageOffset];
                                this.imageData[offset] = (byte)pixelValue;
                            }
                        }
                        ++offset;
                        ++imageOffset;
                    }
                }
            }
        }

        public void sendNewData(GifDecoder decoder, int numLines) {
            if (this.transparentColor != 0xFFFFFFF) {
                this.replaceTransparentPixels(numLines);
            }
            if (GifDecoder.this.forceRGB) {
                decoder.setPixels(this.imageLeft, this.imageTop + this.currY, this.imageWidth, numLines, ColorModel.getRGBdefault(), this.getRgbImageData(), this.currY * this.imageWidth, this.imageWidth);
            } else {
                decoder.setPixels(this.imageLeft, this.imageTop + this.currY, this.imageWidth, numLines, GifDecoder.this.gcm, this.imageData, this.currY * this.imageWidth, this.imageWidth);
            }
            this.currY += numLines;
        }

        public void dispose() {
            GifDecoder.this.imageComplete(2);
            if (this.delayTime > 0) {
                try {
                    Thread.sleep(this.delayTime);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else {
                Thread.yield();
            }
            if (this.imageLeft > GifDecoder.this.gifDataStream.logicalScreen.logicalScreenWidth || this.imageTop > GifDecoder.this.gifDataStream.logicalScreen.logicalScreenHeight) {
                this.disposalMethod = 0;
            }
            switch (this.disposalMethod) {
                case 2: {
                    if (GifDecoder.this.forceRGB) {
                        this.getRgbImageData();
                        int[] data = new int[this.imageWidth * this.imageHeight];
                        if (this.transparentColor != 0xFFFFFFF) {
                            Arrays.fill(data, this.transparentColor);
                        } else {
                            Arrays.fill(data, GifDecoder.this.gifDataStream.logicalScreen.backgroundColor);
                        }
                        GifDecoder.this.setPixels(this.imageLeft, this.imageTop, this.imageWidth, this.imageHeight, ColorModel.getRGBdefault(), data, 0, this.imageWidth);
                        this.sendToScreenBuffer(data);
                        break;
                    }
                    byte[] data = new byte[this.imageWidth * this.imageHeight];
                    if (this.transparentColor != 0xFFFFFFF) {
                        Arrays.fill(data, (byte)this.transparentColor);
                    } else {
                        Arrays.fill(data, (byte)GifDecoder.this.gifDataStream.logicalScreen.backgroundColor);
                    }
                    GifDecoder.this.setPixels(this.imageLeft, this.imageTop, this.imageWidth, this.imageHeight, GifDecoder.this.gcm, data, 0, this.imageWidth);
                    this.sendToScreenBuffer(data);
                    break;
                }
                case 3: {
                    this.screenBufferToScreen();
                    break;
                }
                default: {
                    Object[] data = GifDecoder.this.forceRGB ? this.getRgbImageData() : (Object[])this.imageData;
                    this.sendToScreenBuffer(data);
                    break;
                }
            }
        }

        private void sendToScreenBuffer(Object data) {
            int width = GifDecoder.this.gifDataStream.logicalScreen.logicalScreenWidth;
            if (GifDecoder.this.forceRGB) {
                int[] dataInt = (int[])data;
                if (this.imageWidth == width) {
                    System.arraycopy(dataInt, 0, GifDecoder.this.getScreenRGBBuffer(), this.imageLeft + this.imageTop * width, dataInt.length);
                } else {
                    this.copyScanlines(dataInt, GifDecoder.this.getScreenRGBBuffer(), width);
                }
            } else {
                byte[] dataByte = (byte[])data;
                if (this.imageWidth == width) {
                    System.arraycopy(dataByte, 0, GifDecoder.this.screenBuffer, this.imageLeft + this.imageTop * width, dataByte.length);
                } else {
                    this.copyScanlines(dataByte, GifDecoder.this.screenBuffer, width);
                }
            }
        }

        private void copyScanlines(Object src, Object dst, int width) {
            for (int i = 0; i < this.imageHeight; ++i) {
                System.arraycopy(src, i * this.imageWidth, dst, this.imageLeft + i * width + this.imageTop * width, this.imageWidth);
            }
        }

        private void screenBufferToScreen() {
            Object[] toSend;
            int width = GifDecoder.this.gifDataStream.logicalScreen.logicalScreenWidth;
            Object[] dst = GifDecoder.this.forceRGB ? new int[this.imageWidth * this.imageHeight] : (Object[])new byte[this.imageWidth * this.imageHeight];
            Object[] src = GifDecoder.this.forceRGB ? GifDecoder.this.getScreenRGBBuffer() : (Object[])GifDecoder.this.screenBuffer;
            int offset = 0;
            if (width == this.imageWidth) {
                offset = this.imageWidth * this.imageTop;
                toSend = src;
            } else {
                for (int i = 0; i < this.imageHeight; ++i) {
                    System.arraycopy(src, this.imageLeft + i * width + this.imageTop * width, dst, i * this.imageWidth, this.imageWidth);
                }
                toSend = dst;
            }
            if (GifDecoder.this.forceRGB) {
                GifDecoder.this.setPixels(this.imageLeft, this.imageTop, this.imageWidth, this.imageHeight, ColorModel.getRGBdefault(), (int[])toSend, offset, this.imageWidth);
            } else {
                GifDecoder.this.setPixels(this.imageLeft, this.imageTop, this.imageWidth, this.imageHeight, GifDecoder.this.gcm, (byte[])toSend, offset, this.imageWidth);
            }
        }
    }

    class GifLogicalScreen {
        boolean completed = false;
        int logicalScreenWidth;
        int logicalScreenHeight;
        int backgroundColor = 0xFFFFFFF;
        GifColorTable globalColorTable = new GifColorTable();

        GifLogicalScreen() {
        }
    }

    class GifDataStream {
        boolean completed = false;
        int loopCount = 1;
        GifLogicalScreen logicalScreen = new GifLogicalScreen();
        List<GifGraphicBlock> graphicBlocks = new ArrayList<GifGraphicBlock>(10);
        String[] comments;

        GifDataStream() {
        }
    }
}

