/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.harmony.awt.gl.image.ImageDecoder;
import org.apache.harmony.awt.gl.image.ImageLoader;

public abstract class DecodingImageSource
implements ImageProducer {
    List<ImageConsumer> consumers = new ArrayList<ImageConsumer>(5);
    List<ImageDecoder> decoders = new ArrayList<ImageDecoder>(5);
    boolean loading;
    ImageDecoder decoder;

    protected abstract boolean checkConnection();

    protected abstract InputStream getInputStream();

    @Override
    public synchronized void addConsumer(ImageConsumer ic) {
        if (!this.checkConnection()) {
            ic.imageComplete(1);
            return;
        }
        ImageConsumer cons = DecodingImageSource.findConsumer(this.consumers, ic);
        if (cons == null) {
            ImageDecoder d2 = null;
            for (ImageDecoder d2 : this.decoders) {
                cons = DecodingImageSource.findConsumer(d2.consumers, ic);
                if (cons == null) continue;
            }
        }
        if (cons == null) {
            this.consumers.add(ic);
        }
    }

    private void abortConsumer(ImageConsumer ic) {
        ic.imageComplete(1);
        this.consumers.remove(ic);
    }

    private void abortAllConsumers(List<ImageConsumer> consumersList) {
        for (ImageConsumer imageConsumer : consumersList) {
            this.abortConsumer(imageConsumer);
        }
    }

    @Override
    public synchronized void removeConsumer(ImageConsumer ic) {
        ImageDecoder d2 = null;
        for (ImageDecoder d2 : this.decoders) {
            DecodingImageSource.removeConsumer(d2.consumers, ic);
            if (d2.consumers.size() > 0) continue;
            d2.terminate();
        }
        DecodingImageSource.removeConsumer(this.consumers, ic);
    }

    private static void removeConsumer(List<ImageConsumer> consumersList, ImageConsumer ic) {
        ImageConsumer cons = null;
        Iterator<ImageConsumer> i = consumersList.iterator();
        while (i.hasNext()) {
            cons = i.next();
            if (!cons.equals(ic)) continue;
            i.remove();
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
    }

    @Override
    public synchronized void startProduction(ImageConsumer ic) {
        if (ic != null) {
            this.addConsumer(ic);
        }
        if (!this.loading && this.consumers.size() > 0) {
            ImageLoader.addImageSource(this);
            this.loading = true;
        }
    }

    @Override
    public synchronized boolean isConsumer(ImageConsumer ic) {
        ImageDecoder d2 = null;
        for (ImageDecoder d2 : this.decoders) {
            if (DecodingImageSource.findConsumer(d2.consumers, ic) == null) continue;
            return true;
        }
        return DecodingImageSource.findConsumer(this.consumers, ic) != null;
    }

    private static ImageConsumer findConsumer(List<ImageConsumer> consumersList, ImageConsumer ic) {
        ImageConsumer res2 = null;
        for (ImageConsumer res2 : consumersList) {
            if (!res2.equals(ic)) continue;
            return res2;
        }
        return null;
    }

    synchronized void lockDecoder(ImageDecoder d) {
        if (d == this.decoder) {
            this.decoder = null;
            this.startProduction(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageDecoder createDecoder() {
        List<ImageConsumer> cs;
        InputStream is = this.getInputStream();
        ImageDecoder decoder = is == null ? null : ImageDecoder.createDecoder(this, is);
        if (decoder != null) {
            DecodingImageSource decodingImageSource = this;
            synchronized (decodingImageSource) {
                this.decoders.add(decoder);
                this.decoder = decoder;
                this.loading = false;
                this.consumers = new ArrayList<ImageConsumer>(5);
            }
            return decoder;
        }
        DecodingImageSource decodingImageSource = this;
        synchronized (decodingImageSource) {
            cs = this.consumers;
            this.consumers = new ArrayList<ImageConsumer>(5);
            this.loading = false;
        }
        this.abortAllConsumers(cs);
        return null;
    }

    private synchronized void removeDecoder(ImageDecoder dr) {
        this.lockDecoder(dr);
        this.decoders.remove(dr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        DecodingImageSource decodingImageSource = this;
        synchronized (decodingImageSource) {
            if (this.consumers.size() == 0) {
                this.loading = false;
                return;
            }
        }
        ImageDecoder d = this.createDecoder();
        if (d != null) {
            try {
                this.decoder.decodeImage();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.removeDecoder(d);
                this.abortAllConsumers(d.consumers);
            }
        }
    }
}

