/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class BufferedImageSource
implements ImageProducer {
    private Hashtable<?, ?> properties;
    private ColorModel cm;
    private WritableRaster raster;
    private int width;
    private int height;
    private ImageConsumer ic;

    public BufferedImageSource(BufferedImage image, Hashtable<?, ?> properties) {
        this.properties = properties == null ? new Hashtable() : properties;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.cm = image.getColorModel();
        this.raster = image.getRaster();
    }

    public BufferedImageSource(BufferedImage image) {
        this(image, null);
    }

    @Override
    public boolean isConsumer(ImageConsumer ic) {
        return this.ic == ic;
    }

    @Override
    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer ic) {
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
        if (this.ic == ic) {
            this.ic = null;
        }
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
        this.ic = ic;
        this.startProduction();
    }

    private void startProduction() {
        block10: {
            try {
                this.ic.setDimensions(this.width, this.height);
                this.ic.setProperties(this.properties);
                this.ic.setColorModel(this.cm);
                this.ic.setHints(30);
                if (this.cm instanceof IndexColorModel && this.raster.getTransferType() == 0 || this.cm instanceof ComponentColorModel && this.raster.getTransferType() == 0 && this.raster.getNumDataElements() == 1) {
                    DataBufferByte dbb = (DataBufferByte)this.raster.getDataBuffer();
                    byte[] data = dbb.getData();
                    int off = dbb.getOffset();
                    this.ic.setPixels(0, 0, this.width, this.height, this.cm, data, off, this.width);
                } else if (this.cm instanceof DirectColorModel && this.raster.getTransferType() == 3) {
                    DataBufferInt dbi = (DataBufferInt)this.raster.getDataBuffer();
                    int[] data = dbi.getData();
                    int off = dbi.getOffset();
                    this.ic.setPixels(0, 0, this.width, this.height, this.cm, data, off, this.width);
                } else if (this.cm instanceof DirectColorModel && this.raster.getTransferType() == 0) {
                    DataBufferByte dbb = (DataBufferByte)this.raster.getDataBuffer();
                    byte[] data = dbb.getData();
                    int off = dbb.getOffset();
                    this.ic.setPixels(0, 0, this.width, this.height, this.cm, data, off, this.width);
                } else {
                    ColorModel rgbCM = ColorModel.getRGBdefault();
                    int[] pixels = new int[this.width];
                    Object pix = null;
                    for (int y = 0; y < this.height; ++y) {
                        for (int x = 0; x < this.width; ++x) {
                            pix = this.raster.getDataElements(x, y, pix);
                            pixels[x] = this.cm.getRGB(pix);
                        }
                        this.ic.setPixels(0, y, this.width, 1, rgbCM, pixels, 0, this.width);
                    }
                }
                this.ic.imageComplete(3);
            }
            catch (NullPointerException e) {
                if (this.ic == null) break block10;
                this.ic.imageComplete(1);
            }
        }
    }
}

