/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.image;

import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.CommonGraphics2D;
import org.apache.harmony.awt.gl.Surface;
import org.apache.harmony.awt.gl.render.JavaBlitter;

public class BufferedImageGraphics2D
extends CommonGraphics2D {
    private BufferedImage bi = null;
    private Rectangle bounds = null;

    public BufferedImageGraphics2D(BufferedImage bi) {
        this.bi = bi;
        this.bounds = new Rectangle(0, 0, bi.getWidth(), bi.getHeight());
        this.clip(this.bounds);
        this.dstSurf = Surface.getImageSurface(bi);
        this.blitter = JavaBlitter.getInstance();
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public Graphics create() {
        BufferedImageGraphics2D res = new BufferedImageGraphics2D(this.bi);
        this.copyInternalFields(res);
        return res;
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return null;
    }

    public ColorModel getColorModel() {
        return this.bi.getColorModel();
    }

    public WritableRaster getWritableRaster() {
        return this.bi.getRaster();
    }

    @Override
    public void drawString(String str, float x, float y) {
        Shape sh = this.font.createGlyphVector(this.getFontRenderContext(), str).getOutline(x, y);
        this.fill(sh);
    }

    @Override
    public void drawGlyphVector(GlyphVector gv, float x, float y) {
        Shape sh = gv.getOutline(x, y);
        this.fill(sh);
    }
}

