/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphVector;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.TextHitInfo;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.apache.harmony.awt.gl.font.BasicMetrics;
import org.apache.harmony.awt.gl.font.TextDecorator;
import org.apache.harmony.awt.gl.font.TextRunBreaker;
import org.apache.harmony.awt.gl.font.TextRunSegment;
import org.apache.harmony.awt.internal.nls.Messages;

public class TextRunSegmentImpl {

    public static class TextRunSegmentGraphic
    extends TextRunSegment {
        GraphicAttribute ga;
        int start;
        int length;
        float fullAdvance;

        TextRunSegmentGraphic(GraphicAttribute attr, int len, int start) {
            this.start = start;
            this.length = len;
            this.ga = attr;
            this.metrics = new BasicMetrics(this.ga);
            this.fullAdvance = this.ga.getAdvance() * (float)this.length;
        }

        @Override
        public Object clone() {
            return new TextRunSegmentGraphic(this.ga, this.length, this.start);
        }

        @Override
        void draw(Graphics2D g2d, float xOffset, float yOffset) {
            if (this.decoration != null) {
                TextDecorator.prepareGraphics(this, g2d, xOffset, yOffset);
            }
            float xPos = this.x + xOffset;
            float yPos = this.y + yOffset;
            for (int i = 0; i < this.length; ++i) {
                this.ga.draw(g2d, xPos, yPos);
                xPos += this.ga.getAdvance();
            }
            if (this.decoration != null) {
                TextDecorator.drawTextDecorations(this, g2d, xOffset, yOffset);
                TextDecorator.restoreGraphics(this.decoration, g2d);
            }
        }

        @Override
        Rectangle2D getVisualBounds() {
            if (this.visualBounds == null) {
                Rectangle2D bounds = this.ga.getBounds();
                bounds.setRect(bounds.getMinX() + (double)this.x, bounds.getMinY() + (double)this.y, bounds.getWidth() - (double)this.ga.getAdvance() + (double)this.getAdvance(), bounds.getHeight());
                this.visualBounds = TextDecorator.extendVisualBounds(this, bounds, this.decoration);
            }
            return (Rectangle2D)this.visualBounds.clone();
        }

        @Override
        Rectangle2D getLogicalBounds() {
            if (this.logicalBounds == null) {
                this.logicalBounds = new Rectangle2D.Float(this.x, this.y - this.metrics.ascent, this.getAdvance(), this.metrics.ascent + this.metrics.descent);
            }
            return (Rectangle2D)this.logicalBounds.clone();
        }

        @Override
        float getAdvance() {
            return this.fullAdvance;
        }

        @Override
        float getAdvanceDelta(int start, int end) {
            return this.ga.getAdvance() * (float)(end - start);
        }

        @Override
        int getCharIndexFromAdvance(float advance, int start) {
            int charOffset;
            if ((start -= this.start) < 0) {
                start = 0;
            }
            if ((charOffset = (int)(advance / this.ga.getAdvance())) + start > this.length) {
                return this.length + this.start;
            }
            return charOffset + start + this.start;
        }

        @Override
        int getStart() {
            return this.start;
        }

        @Override
        int getEnd() {
            return this.start + this.length;
        }

        @Override
        int getLength() {
            return this.length;
        }

        @Override
        Shape getCharsBlackBoxBounds(int start, int limit) {
            start -= this.start;
            if ((limit -= this.start) > this.length) {
                limit = this.length;
            }
            Rectangle2D charBounds = this.ga.getBounds();
            charBounds.setRect(charBounds.getX() + (double)(this.ga.getAdvance() * (float)start) + (double)this.x, charBounds.getY() + (double)this.y, charBounds.getWidth() + (double)(this.ga.getAdvance() * (float)(limit - start)), charBounds.getHeight());
            return charBounds;
        }

        @Override
        float getCharPosition(int index) {
            if ((index -= this.start) > this.length) {
                index = this.length;
            }
            return this.ga.getAdvance() * (float)index + this.x;
        }

        @Override
        float getCharAdvance(int index) {
            return this.ga.getAdvance();
        }

        @Override
        Shape getOutline() {
            AffineTransform t = AffineTransform.getTranslateInstance(this.x, this.y);
            return t.createTransformedShape(TextDecorator.extendOutline(this, this.getVisualBounds(), this.decoration));
        }

        @Override
        boolean charHasZeroAdvance(int index) {
            return false;
        }

        @Override
        TextHitInfo hitTest(float hitX, float hitY) {
            int hitIndex;
            float tmp = (hitX -= this.x) / this.ga.getAdvance();
            if (tmp > (float)(hitIndex = Math.round(tmp))) {
                return TextHitInfo.leading(hitIndex + this.start);
            }
            return TextHitInfo.trailing(hitIndex + this.start);
        }

        @Override
        void updateJustificationInfo(TextRunBreaker.JustificationInfo jInfo) {
        }

        @Override
        float doJustification(TextRunBreaker.JustificationInfo[] jInfos) {
            return 0.0f;
        }
    }

    public static class TextRunSegmentCommon
    extends TextRunSegment {
        TextSegmentInfo info;
        private GlyphVector gv;
        private float[] advanceIncrements;
        private int[] char2glyph;
        private GlyphJustificationInfo[] gjis;

        TextRunSegmentCommon(TextSegmentInfo i, TextDecorator.Decoration d) {
            i.flags &= 0xFFFFFFF6;
            if ((i.level & 1) != 0) {
                i.flags |= 1;
            }
            this.info = i;
            this.decoration = d;
            LineMetrics lm = i.font.getLineMetrics(i.text, i.start, i.end, i.frc);
            this.metrics = new BasicMetrics(lm, i.font);
            if (lm.getNumChars() != i.length) {
                throw new UnsupportedOperationException(Messages.getString("awt.41"));
            }
        }

        @Override
        public Object clone() {
            return new TextRunSegmentCommon(this.info, this.decoration);
        }

        private GlyphVector getGlyphVector() {
            if (this.gv == null) {
                this.gv = this.info.font.layoutGlyphVector(this.info.frc, this.info.text, this.info.start, this.info.end - this.info.start, this.info.flags);
            }
            return this.gv;
        }

        @Override
        void draw(Graphics2D g2d, float xOffset, float yOffset) {
            if (this.decoration == null) {
                g2d.drawGlyphVector(this.getGlyphVector(), xOffset + this.x, yOffset + this.y);
            } else {
                TextDecorator.prepareGraphics(this, g2d, xOffset, yOffset);
                g2d.drawGlyphVector(this.getGlyphVector(), xOffset + this.x, yOffset + this.y);
                TextDecorator.drawTextDecorations(this, g2d, xOffset, yOffset);
                TextDecorator.restoreGraphics(this.decoration, g2d);
            }
        }

        @Override
        Rectangle2D getVisualBounds() {
            if (this.visualBounds == null) {
                this.visualBounds = TextDecorator.extendVisualBounds(this, this.getGlyphVector().getVisualBounds(), this.decoration);
                this.visualBounds.setRect((double)this.x + this.visualBounds.getX(), (double)this.y + this.visualBounds.getY(), this.visualBounds.getWidth(), this.visualBounds.getHeight());
            }
            return (Rectangle2D)this.visualBounds.clone();
        }

        @Override
        Rectangle2D getLogicalBounds() {
            if (this.logicalBounds == null) {
                this.logicalBounds = this.getGlyphVector().getLogicalBounds();
                this.logicalBounds.setRect((double)this.x + this.logicalBounds.getX(), (double)this.y + this.logicalBounds.getY(), this.logicalBounds.getWidth(), this.logicalBounds.getHeight());
            }
            return (Rectangle2D)this.logicalBounds.clone();
        }

        @Override
        float getAdvance() {
            return (float)this.getLogicalBounds().getWidth();
        }

        void initAdvanceMapping() {
            GlyphVector gv = this.getGlyphVector();
            int[] charIndicies = gv.getGlyphCharIndices(0, gv.getNumGlyphs(), null);
            this.advanceIncrements = new float[this.info.length];
            for (int i = 0; i < charIndicies.length; ++i) {
                this.advanceIncrements[charIndicies[i]] = gv.getGlyphMetrics(i).getAdvance();
            }
        }

        @Override
        float getAdvanceDelta(int start, int end) {
            start -= this.info.start;
            end -= this.info.start;
            if (this.advanceIncrements == null) {
                this.initAdvanceMapping();
            }
            if (start < 0) {
                start = 0;
            }
            if (end > this.info.length) {
                end = this.info.length;
            }
            float sum = 0.0f;
            for (int i = start; i < end; ++i) {
                sum += this.advanceIncrements[i];
            }
            return sum;
        }

        @Override
        int getCharIndexFromAdvance(float advance, int start) {
            int i;
            if (this.advanceIncrements == null) {
                this.initAdvanceMapping();
            }
            if ((start -= this.info.start) < 0) {
                start = 0;
            }
            for (i = start; i < this.info.length && !((advance -= this.advanceIncrements[i]) < 0.0f); ++i) {
            }
            return i + this.info.start;
        }

        @Override
        int getStart() {
            return this.info.start;
        }

        @Override
        int getEnd() {
            return this.info.end;
        }

        @Override
        int getLength() {
            return this.info.length;
        }

        private int[] getChar2Glyph() {
            if (this.char2glyph == null) {
                GlyphVector gv = this.getGlyphVector();
                this.char2glyph = new int[this.info.length];
                Arrays.fill(this.char2glyph, -1);
                int[] charIndicies = gv.getGlyphCharIndices(0, gv.getNumGlyphs(), null);
                for (int i = 0; i < charIndicies.length; ++i) {
                    this.char2glyph[charIndicies[i]] = i;
                }
                int currIndex = 0;
                for (int i = 0; i < this.char2glyph.length; ++i) {
                    if (this.char2glyph[i] < 0) {
                        this.char2glyph[i] = currIndex;
                        continue;
                    }
                    currIndex = this.char2glyph[i];
                }
            }
            return this.char2glyph;
        }

        @Override
        Shape getCharsBlackBoxBounds(int start, int limit) {
            start -= this.info.start;
            if ((limit -= this.info.start) > this.info.length) {
                limit = this.info.length;
            }
            GeneralPath result = new GeneralPath();
            int glyphIndex = 0;
            for (int i = start; i < limit; ++i) {
                glyphIndex = this.getChar2Glyph()[i];
                result.append(this.getGlyphVector().getGlyphVisualBounds(glyphIndex), false);
            }
            result.transform(AffineTransform.getTranslateInstance(this.x, this.y));
            return result;
        }

        @Override
        float getCharPosition(int index) {
            if ((index -= this.info.start) > this.info.length) {
                index = this.info.length;
            }
            float result = 0.0f;
            int glyphIndex = this.getChar2Glyph()[index];
            result = (float)this.getGlyphVector().getGlyphPosition(glyphIndex).getX();
            return result += this.x;
        }

        @Override
        float getCharAdvance(int index) {
            if (this.advanceIncrements == null) {
                this.initAdvanceMapping();
            }
            return this.advanceIncrements[index - this.getStart()];
        }

        @Override
        Shape getOutline() {
            AffineTransform t = AffineTransform.getTranslateInstance(this.x, this.y);
            return t.createTransformedShape(TextDecorator.extendOutline(this, this.getGlyphVector().getOutline(), this.decoration));
        }

        @Override
        boolean charHasZeroAdvance(int index) {
            if (this.advanceIncrements == null) {
                this.initAdvanceMapping();
            }
            return this.advanceIncrements[index - this.getStart()] == 0.0f;
        }

        @Override
        TextHitInfo hitTest(float hitX, float hitY) {
            int glyphIdx;
            hitX -= this.x;
            float[] glyphPositions = this.getGlyphVector().getGlyphPositions(0, this.info.length + 1, null);
            boolean leading = false;
            for (glyphIdx = 1; glyphIdx <= this.info.length; ++glyphIdx) {
                if (!(glyphPositions[glyphIdx * 2] >= hitX)) continue;
                float advance = glyphPositions[glyphIdx * 2] - glyphPositions[(glyphIdx - 1) * 2];
                leading = glyphPositions[(glyphIdx - 1) * 2] + advance / 2.0f > hitX;
                --glyphIdx;
                break;
            }
            if (glyphIdx == this.info.length) {
                --glyphIdx;
            }
            int charIdx = this.getGlyphVector().getGlyphCharIndex(glyphIdx);
            return leading ^ (this.info.level & 1) == 1 ? TextHitInfo.leading(charIdx + this.info.start) : TextHitInfo.trailing(charIdx + this.info.start);
        }

        private GlyphJustificationInfo[] getGlyphJustificationInfos() {
            if (this.gjis == null) {
                GlyphVector gv = this.getGlyphVector();
                int nGlyphs = gv.getNumGlyphs();
                int[] charIndicies = gv.getGlyphCharIndices(0, nGlyphs, null);
                this.gjis = new GlyphJustificationInfo[nGlyphs];
                float fontSize = this.info.font.getSize2D();
                GlyphJustificationInfo defaultInfo = new GlyphJustificationInfo(0.0f, false, 3, 0.0f, 0.0f, false, 3, 0.0f, 0.0f);
                GlyphJustificationInfo spaceInfo = new GlyphJustificationInfo(fontSize, true, 1, 0.0f, fontSize, true, 1, 0.0f, fontSize);
                for (int i = 0; i < nGlyphs; ++i) {
                    char c = this.info.text[charIndicies[i] + this.info.start];
                    this.gjis[i] = Character.isWhitespace(c) ? spaceInfo : defaultInfo;
                }
            }
            return this.gjis;
        }

        @Override
        void updateJustificationInfo(TextRunBreaker.JustificationInfo jInfo) {
            int i;
            int lastChar = Math.min(jInfo.lastIdx, this.info.end) - this.info.start;
            boolean haveFirst = this.info.start <= jInfo.firstIdx;
            boolean haveLast = this.info.end >= jInfo.lastIdx + 1;
            int prevGlyphIdx = -1;
            if (jInfo.grow) {
                for (i = 0; i < lastChar; ++i) {
                    int currGlyphIdx = this.getChar2Glyph()[i];
                    if (currGlyphIdx == prevGlyphIdx) continue;
                    prevGlyphIdx = currGlyphIdx;
                    GlyphJustificationInfo gji = this.getGlyphJustificationInfos()[currGlyphIdx];
                    if (gji.growPriority != jInfo.priority) continue;
                    jInfo.weight += gji.weight * 2.0f;
                    jInfo.growLimit += gji.growLeftLimit;
                    jInfo.growLimit += gji.growRightLimit;
                    if (!gji.growAbsorb) continue;
                    jInfo.absorbedWeight += gji.weight * 2.0f;
                }
            } else {
                for (i = 0; i < lastChar; ++i) {
                    int currGlyphIdx = this.getChar2Glyph()[i];
                    if (currGlyphIdx == prevGlyphIdx) continue;
                    prevGlyphIdx = currGlyphIdx;
                    GlyphJustificationInfo gji = this.getGlyphJustificationInfos()[currGlyphIdx];
                    if (gji.shrinkPriority != jInfo.priority) continue;
                    jInfo.weight += gji.weight * 2.0f;
                    jInfo.growLimit -= gji.shrinkLeftLimit;
                    jInfo.growLimit -= gji.shrinkRightLimit;
                    if (!gji.shrinkAbsorb) continue;
                    jInfo.absorbedWeight += gji.weight * 2.0f;
                }
            }
            if (haveFirst) {
                GlyphJustificationInfo gji = this.getGlyphJustificationInfos()[this.getChar2Glyph()[0]];
                jInfo.weight -= gji.weight;
                if (jInfo.grow) {
                    jInfo.growLimit -= gji.growLeftLimit;
                    if (gji.growAbsorb) {
                        jInfo.absorbedWeight -= gji.weight;
                    }
                } else {
                    jInfo.growLimit += gji.shrinkLeftLimit;
                    if (gji.shrinkAbsorb) {
                        jInfo.absorbedWeight -= gji.weight;
                    }
                }
            }
            if (haveLast) {
                GlyphJustificationInfo gji = this.getGlyphJustificationInfos()[this.getChar2Glyph()[lastChar]];
                jInfo.weight -= gji.weight;
                if (jInfo.grow) {
                    jInfo.growLimit -= gji.growRightLimit;
                    if (gji.growAbsorb) {
                        jInfo.absorbedWeight -= gji.weight;
                    }
                } else {
                    jInfo.growLimit += gji.shrinkRightLimit;
                    if (gji.shrinkAbsorb) {
                        jInfo.absorbedWeight -= gji.weight;
                    }
                }
            }
        }

        @Override
        float doJustification(TextRunBreaker.JustificationInfo[] jInfos) {
            Point2D glyphPos;
            GlyphJustificationInfo gji;
            int i;
            TextRunBreaker.JustificationInfo currInfo;
            int lastGlyph;
            int highestPriority;
            int lastPriority = jInfos[jInfos.length - 1] == null ? -1 : jInfos[jInfos.length - 1].priority;
            for (highestPriority = 0; highestPriority < jInfos.length && jInfos[highestPriority] == null; ++highestPriority) {
            }
            if (highestPriority == jInfos.length) {
                return 0.0f;
            }
            TextRunBreaker.JustificationInfo firstInfo = jInfos[highestPriority];
            TextRunBreaker.JustificationInfo lastInfo = lastPriority > 0 ? jInfos[lastPriority] : null;
            boolean haveFirst = this.info.start <= firstInfo.firstIdx;
            boolean haveLast = this.info.end >= firstInfo.lastIdx + 1;
            int firstGlyph = haveFirst ? this.getChar2Glyph()[firstInfo.firstIdx - this.info.start] : this.getChar2Glyph()[0];
            int n = lastGlyph = haveLast ? this.getChar2Glyph()[firstInfo.lastIdx - this.info.start] : this.getChar2Glyph()[this.info.length - 1];
            if (haveLast) {
                --lastGlyph;
            }
            float glyphOffset = 0.0f;
            float positionIncrement = 0.0f;
            float sideIncrement = 0.0f;
            if (haveFirst) {
                GlyphJustificationInfo gji2 = this.getGlyphJustificationInfos()[firstGlyph];
                currInfo = jInfos[gji2.growPriority];
                if (currInfo != null) {
                    if (currInfo.useLimits) {
                        if (currInfo.absorb) {
                            glyphOffset += gji2.weight * currInfo.absorbedGapPerUnit;
                        } else if (lastInfo != null && lastInfo.priority == currInfo.priority) {
                            glyphOffset += gji2.weight * lastInfo.absorbedGapPerUnit;
                        }
                        glyphOffset += firstInfo.grow ? gji2.growRightLimit : -gji2.shrinkRightLimit;
                    } else {
                        glyphOffset += gji2.weight * currInfo.gapPerUnit;
                    }
                }
                ++firstGlyph;
            }
            if (firstInfo.grow) {
                for (i = firstGlyph; i <= lastGlyph; ++i) {
                    gji = this.getGlyphJustificationInfos()[i];
                    currInfo = jInfos[gji.growPriority];
                    if (currInfo == null) {
                        glyphPos = this.getGlyphVector().getGlyphPosition(i);
                        glyphPos.setLocation(glyphPos.getX() + (double)glyphOffset, glyphPos.getY());
                        this.getGlyphVector().setGlyphPosition(i, glyphPos);
                        continue;
                    }
                    if (currInfo.useLimits) {
                        glyphOffset += gji.growLeftLimit;
                        if (currInfo.absorb) {
                            sideIncrement = gji.weight * currInfo.absorbedGapPerUnit;
                            positionIncrement = glyphOffset += sideIncrement;
                            glyphOffset += sideIncrement;
                        } else if (lastInfo != null && lastInfo.priority == currInfo.priority) {
                            sideIncrement = gji.weight * lastInfo.absorbedGapPerUnit;
                            positionIncrement = glyphOffset += sideIncrement;
                            glyphOffset += sideIncrement;
                        } else {
                            positionIncrement = glyphOffset;
                        }
                        glyphOffset += gji.growRightLimit;
                    } else {
                        sideIncrement = gji.weight * currInfo.gapPerUnit;
                        positionIncrement = glyphOffset += sideIncrement;
                        glyphOffset += sideIncrement;
                    }
                    glyphPos = this.getGlyphVector().getGlyphPosition(i);
                    glyphPos.setLocation(glyphPos.getX() + (double)positionIncrement, glyphPos.getY());
                    this.getGlyphVector().setGlyphPosition(i, glyphPos);
                }
            } else {
                for (i = firstGlyph; i <= lastGlyph; ++i) {
                    gji = this.getGlyphJustificationInfos()[i];
                    currInfo = jInfos[gji.shrinkPriority];
                    if (currInfo == null) {
                        glyphPos = this.getGlyphVector().getGlyphPosition(i);
                        glyphPos.setLocation(glyphPos.getX() + (double)glyphOffset, glyphPos.getY());
                        this.getGlyphVector().setGlyphPosition(i, glyphPos);
                        continue;
                    }
                    if (currInfo.useLimits) {
                        glyphOffset -= gji.shrinkLeftLimit;
                        if (currInfo.absorb) {
                            sideIncrement = gji.weight * currInfo.absorbedGapPerUnit;
                            positionIncrement = glyphOffset += sideIncrement;
                            glyphOffset += sideIncrement;
                        } else if (lastInfo != null && lastInfo.priority == currInfo.priority) {
                            sideIncrement = gji.weight * lastInfo.absorbedGapPerUnit;
                            positionIncrement = glyphOffset += sideIncrement;
                            glyphOffset += sideIncrement;
                        } else {
                            positionIncrement = glyphOffset;
                        }
                        glyphOffset -= gji.shrinkRightLimit;
                    } else {
                        sideIncrement = gji.weight * currInfo.gapPerUnit;
                        positionIncrement = glyphOffset += sideIncrement;
                        glyphOffset += sideIncrement;
                    }
                    glyphPos = this.getGlyphVector().getGlyphPosition(i);
                    glyphPos.setLocation(glyphPos.getX() + (double)positionIncrement, glyphPos.getY());
                    this.getGlyphVector().setGlyphPosition(i, glyphPos);
                }
            }
            if (haveLast) {
                GlyphJustificationInfo gji3 = this.getGlyphJustificationInfos()[++lastGlyph];
                currInfo = jInfos[gji3.growPriority];
                if (currInfo != null) {
                    if (currInfo.useLimits) {
                        glyphOffset += firstInfo.grow ? gji3.growLeftLimit : -gji3.shrinkLeftLimit;
                        if (currInfo.absorb) {
                            glyphOffset += gji3.weight * currInfo.absorbedGapPerUnit;
                        } else if (lastInfo != null && lastInfo.priority == currInfo.priority) {
                            glyphOffset += gji3.weight * lastInfo.absorbedGapPerUnit;
                        }
                    } else {
                        glyphOffset += gji3.weight * currInfo.gapPerUnit;
                    }
                }
                for (int i2 = lastGlyph; i2 < this.getGlyphVector().getNumGlyphs() + 1; ++i2) {
                    glyphPos = this.getGlyphVector().getGlyphPosition(i2);
                    glyphPos.setLocation(glyphPos.getX() + (double)glyphOffset, glyphPos.getY());
                    this.getGlyphVector().setGlyphPosition(i2, glyphPos);
                }
            } else {
                Point2D glyphPos2 = this.getGlyphVector().getGlyphPosition(lastGlyph + 1);
                glyphPos2.setLocation(glyphPos2.getX() + (double)glyphOffset, glyphPos2.getY());
                this.getGlyphVector().setGlyphPosition(lastGlyph + 1, glyphPos2);
            }
            this.gjis = null;
            this.visualBounds = null;
            this.logicalBounds = null;
            return glyphOffset;
        }
    }

    public static class TextSegmentInfo {
        Font font;
        FontRenderContext frc;
        char[] text;
        int start;
        int end;
        int length;
        int flags = 0;
        byte level = 0;

        TextSegmentInfo(byte level, Font font, FontRenderContext frc, char[] text, int start, int end) {
            this.font = font;
            this.frc = frc;
            this.text = text;
            this.start = start;
            this.end = end;
            this.level = level;
            this.length = end - start;
        }
    }
}

