/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.awt.gl.font.FontFinder;
import org.apache.harmony.awt.gl.font.TextDecorator;
import org.apache.harmony.awt.gl.font.TextRunSegment;
import org.apache.harmony.awt.gl.font.TextRunSegmentImpl;
import org.apache.harmony.awt.internal.nls.Messages;
import org.apache.harmony.misc.HashCode;

public class TextRunBreaker
implements Cloneable {
    AttributedCharacterIterator aci;
    FontRenderContext frc;
    char[] text;
    byte[] levels;
    HashMap<Integer, Object> fonts;
    HashMap<Integer, TextDecorator.Decoration> decorations;
    int[] forcedFontRunStarts;
    ArrayList<TextRunSegment> runSegments = new ArrayList();
    int[] logical2segment;
    int[] segment2visual;
    int[] visual2segment;
    int[] logical2visual;
    int[] visual2logical;
    SegmentsInfo storedSegments;
    private boolean haveAllSegments = false;
    int segmentsStart;
    int segmentsEnd;
    float justification = 1.0f;

    public TextRunBreaker(AttributedCharacterIterator aci, FontRenderContext frc) {
        this.aci = aci;
        this.frc = frc;
        this.segmentsStart = aci.getBeginIndex();
        this.segmentsEnd = aci.getEndIndex();
        int len = this.segmentsEnd - this.segmentsStart;
        this.text = new char[len];
        aci.setIndex(this.segmentsEnd);
        while (len-- != 0) {
            this.text[len] = aci.previous();
        }
        this.createStyleRuns();
    }

    int getVisualFromSegmentOrder(int segmentNum) {
        return this.segment2visual == null ? segmentNum : this.segment2visual[segmentNum];
    }

    int getSegmentFromVisualOrder(int visual) {
        return this.visual2segment == null ? visual : this.visual2segment[visual];
    }

    int getVisualFromLogical(int logical) {
        return this.logical2visual == null ? logical : this.logical2visual[logical];
    }

    int getLogicalFromVisual(int visual) {
        return this.visual2logical == null ? visual : this.visual2logical[visual];
    }

    int getLevelRunLimit(int runStart, int runEnd) {
        int endLevelRun;
        if (this.levels == null) {
            return runEnd;
        }
        byte level = this.levels[runStart];
        for (endLevelRun = runStart + 1; endLevelRun <= runEnd && this.levels[endLevelRun] == level; ++endLevelRun) {
        }
        return endLevelRun;
    }

    Map<? extends AttributedCharacterIterator.Attribute, ?> unpackAttributes(Map<? extends AttributedCharacterIterator.Attribute, ?> attrs) {
        if (attrs.containsKey(TextAttribute.INPUT_METHOD_HIGHLIGHT)) {
            Map styles = null;
            Object val = attrs.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
            if (val instanceof Annotation) {
                val = ((Annotation)val).getValue();
            }
            if (styles != null) {
                HashMap<AttributedCharacterIterator.Attribute, Object> newAttrs = new HashMap<AttributedCharacterIterator.Attribute, Object>();
                newAttrs.putAll(attrs);
                newAttrs.putAll(styles);
                return newAttrs;
            }
        }
        return attrs;
    }

    void createStyleRuns() {
        this.fonts = new HashMap();
        this.decorations = new HashMap();
        ArrayList<Integer> forcedFontRunStartsList = null;
        Map<AttributedCharacterIterator.Attribute, ?> attributes = null;
        Object val = this.aci.getAttribute(TextAttribute.JUSTIFICATION);
        if (val != null) {
            this.justification = ((Float)val).floatValue();
        }
        int index = this.segmentsStart;
        int nextRunStart = this.segmentsStart;
        while (index < this.segmentsEnd) {
            nextRunStart = this.aci.getRunLimit();
            attributes = this.unpackAttributes(this.aci.getAttributes());
            TextDecorator.Decoration d = TextDecorator.getDecoration(attributes);
            this.decorations.put(new Integer(index), d);
            Object value = attributes.get(TextAttribute.CHAR_REPLACEMENT);
            if (value == null && (value = attributes.get(TextAttribute.FONT)) == null) {
                if (attributes.get(TextAttribute.FAMILY) != null) {
                    value = Font.getFont(attributes);
                }
                if (value == null) {
                    if (forcedFontRunStartsList == null) {
                        forcedFontRunStartsList = new ArrayList<Integer>();
                    }
                    FontFinder.findFonts(this.text, index, nextRunStart, forcedFontRunStartsList, this.fonts);
                    value = this.fonts.get(new Integer(index));
                }
            }
            this.fonts.put(new Integer(index), value);
            index = nextRunStart;
            this.aci.setIndex(index);
        }
        if (forcedFontRunStartsList != null) {
            this.forcedFontRunStarts = new int[forcedFontRunStartsList.size()];
            for (int i = 0; i < forcedFontRunStartsList.size(); ++i) {
                this.forcedFontRunStarts[i] = (Integer)forcedFontRunStartsList.get(i);
            }
        }
    }

    int getStyleRunLimit(int runStart, int maxPos) {
        try {
            this.aci.setIndex(runStart);
        }
        catch (IllegalArgumentException e) {
            if (runStart < this.segmentsStart) {
                this.aci.first();
            }
            this.aci.last();
        }
        if (this.forcedFontRunStarts != null) {
            for (int element : this.forcedFontRunStarts) {
                if (element <= runStart) continue;
                maxPos = Math.min(element, maxPos);
                break;
            }
        }
        return Math.min(this.aci.getRunLimit(), maxPos);
    }

    public void createSegments(int runStart, int runEnd) {
        int pos = runStart;
        this.aci.setIndex(pos);
        int firstRunStart = this.aci.getRunStart();
        TextDecorator.Decoration tdd = this.decorations.get(new Integer(firstRunStart));
        Object fontOrGAttr = this.fonts.get(new Integer(firstRunStart));
        this.logical2segment = new int[runEnd - runStart];
        do {
            int endLevelRun;
            int endStyleRun = this.getStyleRunLimit(pos, runEnd);
            int ajustedPos = pos - runStart;
            int ajustedEndStyleRun = endStyleRun - runStart;
            int levelPos = ajustedPos;
            do {
                endLevelRun = this.getLevelRunLimit(levelPos, ajustedEndStyleRun);
                if (fontOrGAttr instanceof GraphicAttribute) {
                    this.runSegments.add(new TextRunSegmentImpl.TextRunSegmentGraphic((GraphicAttribute)fontOrGAttr, endLevelRun - levelPos, levelPos + runStart));
                    Arrays.fill(this.logical2segment, levelPos, endLevelRun, this.runSegments.size() - 1);
                    continue;
                }
                TextRunSegmentImpl.TextSegmentInfo i = new TextRunSegmentImpl.TextSegmentInfo(this.levels == null ? (byte)0 : this.levels[ajustedPos], (Font)fontOrGAttr, this.frc, this.text, levelPos + runStart, endLevelRun + runStart);
                this.runSegments.add(new TextRunSegmentImpl.TextRunSegmentCommon(i, tdd));
                Arrays.fill(this.logical2segment, levelPos, endLevelRun, this.runSegments.size() - 1);
            } while ((levelPos = endLevelRun) < ajustedEndStyleRun);
            pos = endStyleRun;
            tdd = this.decorations.get(new Integer(pos));
            fontOrGAttr = this.fonts.get(new Integer(pos));
        } while (pos < runEnd);
    }

    public void createAllSegments() {
        if (!(this.haveAllSegments || this.logical2segment != null && this.logical2segment.length == this.segmentsEnd - this.segmentsStart)) {
            this.resetSegments();
            this.createSegments(this.segmentsStart, this.segmentsEnd);
        }
        this.haveAllSegments = true;
    }

    public int getLineBreakIndex(int start, float maxAdvance) {
        TextRunSegment s = null;
        for (int segmentIndex = this.logical2segment[start]; segmentIndex < this.runSegments.size(); ++segmentIndex) {
            s = this.runSegments.get(segmentIndex);
            int breakIndex = s.getCharIndexFromAdvance(maxAdvance, start);
            if (breakIndex < s.getEnd()) {
                return breakIndex;
            }
            maxAdvance -= s.getAdvanceDelta(start, s.getEnd());
            start = s.getEnd();
        }
        return s.getEnd();
    }

    public void insertChar(AttributedCharacterIterator newParagraph, int insertPos) {
        this.aci = newParagraph;
        char insChar = this.aci.setIndex(insertPos);
        Integer key = new Integer(insertPos);
        char[] newText = new char[this.text.length + 1];
        System.arraycopy(this.text, 0, newText, 0, insertPos -= this.aci.getBeginIndex());
        newText[insertPos] = insChar;
        System.arraycopy(this.text, insertPos, newText, insertPos + 1, this.text.length - insertPos);
        this.text = newText;
        if (this.aci.getRunStart() == key.intValue() && this.aci.getRunLimit() == key + 1) {
            this.createStyleRuns();
        } else {
            this.shiftStyleRuns(key, 1);
        }
        this.resetSegments();
        ++this.segmentsEnd;
    }

    public void deleteChar(AttributedCharacterIterator newParagraph, int deletePos) {
        this.aci = newParagraph;
        Integer key = new Integer(deletePos);
        char[] newText = new char[this.text.length - 1];
        System.arraycopy(this.text, 0, newText, 0, deletePos -= this.aci.getBeginIndex());
        System.arraycopy(this.text, deletePos + 1, newText, deletePos, newText.length - deletePos);
        this.text = newText;
        if (this.fonts.get(key) != null) {
            this.fonts.remove(key);
        }
        this.shiftStyleRuns(key, -1);
        this.resetSegments();
        --this.segmentsEnd;
    }

    private void shiftStyleRuns(Integer pos, int shift) {
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (Integer oldkey : this.fonts.keySet()) {
            if (oldkey <= pos) continue;
            keys.add(oldkey);
        }
        for (int i = 0; i < keys.size(); ++i) {
            Integer oldkey;
            oldkey = (Integer)keys.get(i);
            Integer key = new Integer(shift + oldkey);
            this.fonts.put(key, this.fonts.remove(oldkey));
            this.decorations.put(key, this.decorations.remove(oldkey));
        }
    }

    private void resetSegments() {
        this.runSegments = new ArrayList();
        this.logical2segment = null;
        this.segment2visual = null;
        this.visual2segment = null;
        this.levels = null;
        this.haveAllSegments = false;
    }

    public void pushSegments(int newSegStart, int newSegEnd) {
        this.storedSegments = new SegmentsInfo();
        this.storedSegments.runSegments = this.runSegments;
        this.storedSegments.logical2segment = this.logical2segment;
        this.storedSegments.segment2visual = this.segment2visual;
        this.storedSegments.visual2segment = this.visual2segment;
        this.storedSegments.levels = this.levels;
        this.storedSegments.segmentsStart = this.segmentsStart;
        this.storedSegments.segmentsEnd = this.segmentsEnd;
        this.resetSegments();
        this.segmentsStart = newSegStart;
        this.segmentsEnd = newSegEnd;
    }

    public void popSegments() {
        if (this.storedSegments == null) {
            return;
        }
        this.runSegments = this.storedSegments.runSegments;
        this.logical2segment = this.storedSegments.logical2segment;
        this.segment2visual = this.storedSegments.segment2visual;
        this.visual2segment = this.storedSegments.visual2segment;
        this.levels = this.storedSegments.levels;
        this.segmentsStart = this.storedSegments.segmentsStart;
        this.segmentsEnd = this.storedSegments.segmentsEnd;
        this.storedSegments = null;
        this.haveAllSegments = this.runSegments.size() != 0 || this.logical2segment != null;
    }

    public Object clone() {
        try {
            TextRunBreaker res = (TextRunBreaker)super.clone();
            res.storedSegments = null;
            ArrayList<TextRunSegment> newSegments = new ArrayList<TextRunSegment>(this.runSegments.size());
            for (int i = 0; i < this.runSegments.size(); ++i) {
                TextRunSegment seg = this.runSegments.get(i);
                newSegments.add((TextRunSegment)seg.clone());
            }
            res.runSegments = newSegments;
            return res;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException(Messages.getString("awt.3E"));
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextRunBreaker)) {
            return false;
        }
        TextRunBreaker br = (TextRunBreaker)obj;
        return br.getACI().equals(this.aci) && br.frc.equals(this.frc);
    }

    public int hashCode() {
        return HashCode.combine(this.aci.hashCode(), this.frc.hashCode());
    }

    public void drawSegments(Graphics2D g2d, float xOffset, float yOffset) {
        for (int i = 0; i < this.runSegments.size(); ++i) {
            this.runSegments.get(i).draw(g2d, xOffset, yOffset);
        }
    }

    public Shape getBlackBoxBounds(int firstEndpoint, int secondEndpoint) {
        GeneralPath bounds = new GeneralPath();
        int idx = firstEndpoint;
        while (idx < secondEndpoint) {
            TextRunSegment segment = this.runSegments.get(this.logical2segment[idx]);
            bounds.append(segment.getCharsBlackBoxBounds(idx, secondEndpoint), false);
            idx = segment.getEnd();
        }
        return bounds;
    }

    public Rectangle2D getVisualBounds() {
        Rectangle2D bounds = null;
        for (int i = 0; i < this.runSegments.size(); ++i) {
            TextRunSegment s = this.runSegments.get(i);
            if (bounds != null) {
                Rectangle2D.union(bounds, s.getVisualBounds(), bounds);
                continue;
            }
            bounds = s.getVisualBounds();
        }
        return bounds;
    }

    public Rectangle2D getLogicalBounds() {
        Rectangle2D bounds = null;
        for (int i = 0; i < this.runSegments.size(); ++i) {
            TextRunSegment s = this.runSegments.get(i);
            if (bounds != null) {
                Rectangle2D.union(bounds, s.getLogicalBounds(), bounds);
                continue;
            }
            bounds = s.getLogicalBounds();
        }
        return bounds;
    }

    public int getCharCount() {
        return this.segmentsEnd - this.segmentsStart;
    }

    public byte getLevel(int idx) {
        if (this.levels == null) {
            return 0;
        }
        return this.levels[idx];
    }

    public int getBaseLevel() {
        return 0;
    }

    public boolean isLTR() {
        return true;
    }

    public char getChar(int index) {
        return this.text[index];
    }

    public AttributedCharacterIterator getACI() {
        return this.aci;
    }

    public GeneralPath getOutline() {
        GeneralPath outline = new GeneralPath();
        for (int i = 0; i < this.runSegments.size(); ++i) {
            TextRunSegment segment = this.runSegments.get(i);
            outline.append(segment.getOutline(), false);
        }
        return outline;
    }

    public TextHitInfo hitTest(float x, float y) {
        double endOfPrevSeg = -1.0;
        for (int i = 0; i < this.runSegments.size(); ++i) {
            TextRunSegment segment = this.runSegments.get(i);
            Rectangle2D bounds = segment.getVisualBounds();
            if (bounds.getMinX() <= (double)x && bounds.getMaxX() >= (double)x || endOfPrevSeg < (double)x && bounds.getMinX() > (double)x) {
                return segment.hitTest(x, y);
            }
            endOfPrevSeg = bounds.getMaxX();
        }
        return this.isLTR() ? TextHitInfo.trailing(this.text.length) : TextHitInfo.leading(0);
    }

    public float getJustification() {
        return this.justification;
    }

    public int getLastNonWhitespace() {
        int lastNonWhitespace = this.text.length;
        while (lastNonWhitespace >= 0 && Character.isWhitespace(this.text[--lastNonWhitespace])) {
        }
        return lastNonWhitespace;
    }

    public void justify(float gap) {
        int firstIdx = this.segmentsStart;
        int lastIdx = this.getLastNonWhitespace() + this.segmentsStart;
        JustificationInfo[] jInfos = new JustificationInfo[5];
        float gapLeft = gap;
        int highestPriority = -1;
        for (int priority = 0; priority <= 4; ++priority) {
            JustificationInfo jInfo = new JustificationInfo();
            jInfo.lastIdx = lastIdx;
            jInfo.firstIdx = firstIdx;
            jInfo.grow = gap > 0.0f;
            jInfo.gapToFill = gapLeft;
            jInfo.priority = priority <= 3 ? priority : highestPriority;
            for (int i = 0; i < this.runSegments.size(); ++i) {
                TextRunSegment segment = this.runSegments.get(i);
                if (segment.getStart() > lastIdx) continue;
                segment.updateJustificationInfo(jInfo);
            }
            if (jInfo.priority == highestPriority) {
                jInfo.absorb = true;
                jInfo.absorbedWeight = jInfo.weight;
            }
            if (jInfo.weight == 0.0f) continue;
            if (highestPriority < 0) {
                highestPriority = priority;
            }
            jInfos[priority] = jInfo;
            if ((gapLeft -= jInfo.growLimit) > 0.0f ^ jInfo.grow || gapLeft == 0.0f) {
                gapLeft = 0.0f;
                jInfo.gapPerUnit = jInfo.gapToFill / jInfo.weight;
                break;
            }
            jInfo.useLimits = true;
            if (!(jInfo.absorbedWeight > 0.0f)) continue;
            jInfo.absorb = true;
            jInfo.absorbedGapPerUnit = (jInfo.gapToFill - jInfo.growLimit) / jInfo.absorbedWeight;
            break;
        }
        float currJustificationOffset = 0.0f;
        for (int i = 0; i < this.runSegments.size(); ++i) {
            TextRunSegment segment = this.runSegments.get(this.getSegmentFromVisualOrder(i));
            segment.x += currJustificationOffset;
            currJustificationOffset += segment.doJustification(jInfos);
        }
        this.justification = -1.0f;
    }

    class JustificationInfo {
        boolean grow;
        boolean absorb = false;
        boolean useLimits = false;
        int priority = 0;
        float weight = 0.0f;
        float absorbedWeight = 0.0f;
        float growLimit = 0.0f;
        int lastIdx;
        int firstIdx;
        float gapToFill;
        float gapPerUnit = 0.0f;
        float absorbedGapPerUnit = 0.0f;

        JustificationInfo() {
        }
    }

    private class SegmentsInfo {
        ArrayList<TextRunSegment> runSegments;
        int[] logical2segment;
        int[] segment2visual;
        int[] visual2segment;
        byte[] levels;
        int segmentsStart;
        int segmentsEnd;

        private SegmentsInfo() {
        }
    }
}

