/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.harmony.awt.gl.font.BasicMetrics;
import org.apache.harmony.awt.gl.font.TextRunBreaker;
import org.apache.harmony.awt.gl.font.TextRunSegment;
import org.apache.harmony.awt.internal.nls.Messages;

public class TextMetricsCalculator {
    TextRunBreaker breaker;
    float ascent = 0.0f;
    float descent = 0.0f;
    float leading = 0.0f;
    float advance = 0.0f;
    private float[] baselineOffsets;
    int baselineIndex;

    public TextMetricsCalculator(TextRunBreaker breaker) {
        this.breaker = breaker;
        this.checkBaselines();
    }

    float getBaselineOffset(int baselineIndex) {
        if (baselineIndex >= 0) {
            return this.baselineOffsets[baselineIndex];
        }
        if (baselineIndex == -2) {
            return this.descent;
        }
        if (baselineIndex == -1) {
            return -this.ascent;
        }
        throw new IllegalArgumentException(Messages.getString("awt.3F"));
    }

    public float[] getBaselineOffsets() {
        float[] ret = new float[this.baselineOffsets.length];
        System.arraycopy(this.baselineOffsets, 0, ret, 0, this.baselineOffsets.length);
        return ret;
    }

    public void checkBaselines() {
        HashMap<Integer, Object> fonts = this.breaker.fonts;
        Object val = fonts.get(new Integer(0));
        if (val instanceof Font) {
            Font firstFont = (Font)val;
            LineMetrics lm = firstFont.getLineMetrics(this.breaker.text, 0, 1, this.breaker.frc);
            this.baselineOffsets = lm.getBaselineOffsets();
            this.baselineIndex = lm.getBaselineIndex();
        } else if (val instanceof GraphicAttribute) {
            GraphicAttribute ga = (GraphicAttribute)val;
            int align = ga.getAlignment();
            this.baselineIndex = align == -1 || align == -2 ? 0 : align;
            this.baselineOffsets = new float[3];
            this.baselineOffsets[0] = 0.0f;
            this.baselineOffsets[1] = (ga.getDescent() - ga.getAscent()) / 2.0f;
            this.baselineOffsets[2] = -ga.getAscent();
        } else {
            this.baselineIndex = 0;
            this.baselineOffsets = new float[3];
        }
        if (this.baselineOffsets[this.baselineIndex] != 0.0f) {
            float baseOffset = this.baselineOffsets[this.baselineIndex];
            int i = 0;
            while (i < this.baselineOffsets.length) {
                int n = i++;
                this.baselineOffsets[n] = this.baselineOffsets[n] - baseOffset;
            }
        }
    }

    void computeMetrics() {
        ArrayList<TextRunSegment> segments = this.breaker.runSegments;
        float maxHeight = 0.0f;
        float maxHeightLeading = 0.0f;
        for (int i = 0; i < segments.size(); ++i) {
            TextRunSegment segment = segments.get(i);
            BasicMetrics metrics = segment.metrics;
            int baseline = metrics.baseLineIndex;
            if (baseline >= 0) {
                float baselineOffset = this.baselineOffsets[metrics.baseLineIndex];
                float fixedDescent = metrics.descent + baselineOffset;
                this.ascent = Math.max(this.ascent, metrics.ascent - baselineOffset);
                this.descent = Math.max(this.descent, fixedDescent);
                this.leading = Math.max(this.leading, fixedDescent + metrics.leading);
                continue;
            }
            float height = metrics.ascent + metrics.descent;
            maxHeight = Math.max(maxHeight, height);
            maxHeightLeading = Math.max(maxHeightLeading, height + metrics.leading);
        }
        if (maxHeightLeading != 0.0f) {
            this.descent = Math.max(this.descent, maxHeight - this.ascent);
            this.leading = Math.max(this.leading, maxHeightLeading - this.ascent);
        }
        this.leading -= this.descent;
        float currAdvance = 0.0f;
        for (int i = 0; i < segments.size(); ++i) {
            TextRunSegment segment = segments.get(this.breaker.getSegmentFromVisualOrder(i));
            BasicMetrics currMetrics = segment.metrics;
            segment.y = this.getBaselineOffset(currMetrics.baseLineIndex) + currMetrics.superScriptOffset;
            segment.x = currAdvance;
            currAdvance += segment.getAdvance();
        }
        this.advance = currAdvance;
    }

    public BasicMetrics createMetrics() {
        this.computeMetrics();
        return new BasicMetrics(this);
    }

    public void correctAdvance(BasicMetrics metrics) {
        ArrayList<TextRunSegment> segments = this.breaker.runSegments;
        TextRunSegment segment = segments.get(this.breaker.getSegmentFromVisualOrder(segments.size() - 1));
        metrics.advance = this.advance = segment.x + segment.getAdvance();
    }
}

