/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Shape;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.image.BufferedImage;

public abstract class Glyph {
    protected char glChar;
    protected GlyphMetrics glMetrics;
    protected GlyphMetrics glPointMetrics;
    int glCode;
    GlyphJustificationInfo glJustInfo;
    long pFont;
    int fontSize;
    byte[] bitmap = null;
    BufferedImage image;
    protected Shape glOutline = null;
    public int bmp_top = 0;
    public int bmp_left = 0;
    public int bmp_pitch;
    public int bmp_rows;
    public int bmp_width;

    public long getPFont() {
        return this.pFont;
    }

    public char getChar() {
        return this.glChar;
    }

    public int getWidth() {
        return Math.round((float)this.getGlyphMetrics().getBounds2D().getWidth());
    }

    public int getHeight() {
        return Math.round((float)this.getGlyphMetrics().getBounds2D().getHeight());
    }

    public int getGlyphCode() {
        return this.glCode;
    }

    public GlyphMetrics getGlyphMetrics() {
        return this.glMetrics;
    }

    public GlyphMetrics getGlyphPointMetrics() {
        return this.glPointMetrics;
    }

    public GlyphJustificationInfo getGlyphJustificationInfo() {
        return this.glJustInfo;
    }

    public void setGlyphJustificationInfo(GlyphJustificationInfo newJustInfo) {
        this.glJustInfo = newJustInfo;
    }

    public int[] getABC() {
        int[] abc = new int[]{(int)this.getGlyphMetrics().getLSB(), (int)this.getGlyphMetrics().getBounds2D().getWidth(), (int)this.getGlyphMetrics().getRSB()};
        return abc;
    }

    public void setImage(BufferedImage newImage) {
        this.image = newImage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null) {
            try {
                Glyph gl = (Glyph)obj;
                return this.getChar() == gl.getChar() && this.getGlyphMetrics().equals(gl.getGlyphMetrics()) && this.getGlyphCode() == gl.getGlyphCode();
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public int getPointHeight() {
        return (int)this.getGlyphPointMetrics().getBounds2D().getHeight();
    }

    public int getPointWidth() {
        return (int)this.getGlyphPointMetrics().getBounds2D().getWidth();
    }

    public Shape getShape() {
        if (this.glOutline == null) {
            this.glOutline = this.initOutline(this.glChar);
        }
        return this.glOutline;
    }

    public BufferedImage getImage() {
        return null;
    }

    public abstract byte[] getBitmap();

    public abstract Shape initOutline(char var1);
}

