/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.harmony.awt.gl.font.FontExtraMetrics;
import org.apache.harmony.awt.gl.font.Glyph;
import org.apache.harmony.awt.gl.font.LineMetricsImpl;
import org.apache.harmony.awt.internal.nls.Messages;

public abstract class FontPeerImpl
implements FontPeer {
    int ascent;
    int descent;
    int leading;
    int maxAdvance;
    float height;
    protected int style;
    protected int size;
    int logicalHeight;
    protected String name;
    String fontFamilyName;
    String faceName;
    protected Rectangle2D maxCharBounds;
    float italicAngle = 0.0f;
    int numGlyphs = 0;
    protected long pFont;
    protected LineMetricsImpl nlm = null;
    protected String psName = null;
    public char defaultChar = (char)65535;
    boolean uniformLM = true;
    int fontType = 0;
    private boolean createdFromStream = false;
    private String tempFontFileName = null;
    FontExtraMetrics extraMetrix = null;

    public abstract FontExtraMetrics getExtraMetrics();

    public abstract LineMetrics getLineMetrics(String var1, FontRenderContext var2, AffineTransform var3);

    public abstract String getPSName();

    public void setPSName(String name) {
        this.psName = name;
    }

    public abstract int getMissingGlyphCode();

    public abstract Glyph getGlyph(char var1);

    public abstract void dispose();

    public abstract Glyph getDefaultGlyph();

    public abstract boolean canDisplay(char var1);

    public String getFamily(Locale l) {
        return this.getFamily();
    }

    public void setFamily(String familyName) {
        this.fontFamilyName = familyName;
    }

    public String getFontName(Locale l) {
        return this.getFontName();
    }

    public void setFontName(String fontName) {
        this.faceName = fontName;
    }

    public boolean isCreatedFromStream() {
        return this.createdFromStream;
    }

    public void setCreatedFromStream(boolean value) {
        this.createdFromStream = value;
    }

    public String getTempFontFileName() {
        return this.tempFontFileName;
    }

    public void setFontFileName(String value) {
        this.tempFontFileName = value;
    }

    public int charWidth(char ch) {
        Glyph gl = this.getGlyph(ch);
        return (int)gl.getGlyphPointMetrics().getAdvanceX();
    }

    public int charWidth(int ind) {
        return this.charWidth((char)ind);
    }

    public Glyph[] getGlyphs(char uFirst, char uLast) {
        char i = uFirst;
        int len = uLast - uFirst;
        ArrayList<Glyph> lst = new ArrayList<Glyph>(len);
        if (this.size < 0) {
            throw new IllegalArgumentException(Messages.getString("awt.09"));
        }
        while (i < uLast) {
            lst.add(this.getGlyph(i));
        }
        return (Glyph[])lst.toArray();
    }

    public Glyph[] getGlyphs(char[] chars) {
        if (chars == null) {
            return null;
        }
        Glyph[] result = new Glyph[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            result[i] = this.getGlyph(chars[i]);
        }
        return result;
    }

    public Glyph[] getGlyphs(String str) {
        char[] chars = str.toCharArray();
        return this.getGlyphs(chars);
    }

    public String getFamily() {
        return this.fontFamilyName;
    }

    public String getFontName() {
        if (this.fontType == 2) {
            return this.fontFamilyName;
        }
        return this.faceName;
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public void setLogicalHeight(int newHeight) {
        this.logicalHeight = newHeight;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public String getName() {
        return this.name;
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext frc) {
        if (frc != null) {
            AffineTransform at = frc.getTransform();
            return at.createTransformedShape(this.maxCharBounds).getBounds2D();
        }
        return this.maxCharBounds;
    }

    public int getNumGlyphs() {
        return this.numGlyphs;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public float getHeight() {
        return this.height;
    }

    public LineMetrics getLineMetrics() {
        if (this.nlm == null) {
            this.nlm = (LineMetricsImpl)this.getLineMetrics("", null, AffineTransform.getTranslateInstance(0.0, 0.0));
        }
        return this.nlm;
    }

    public long getFontHandle() {
        return this.pFont;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getLeading() {
        return this.leading;
    }

    public boolean hasUniformLineMetrics() {
        return this.uniformLM;
    }

    public int getFontType() {
        return this.fontType;
    }

    public void setFontType(int newType) {
        if (newType == 2 || newType == 4) {
            this.fontType = newType;
        }
    }

    public char getUnicodeByIndex(int glyphCode) {
        return '\u0000';
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }
}

