/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.font.sfntly.SfntlyFontPeer;
import java.awt.peer.FontPeer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import org.apache.harmony.awt.Utils;
import org.apache.harmony.awt.gl.font.CompositeFont;
import org.apache.harmony.awt.gl.font.FontPeerImpl;
import org.apache.harmony.awt.gl.font.FontProperty;

public class FontManager {
    public static final boolean IS_FONTLIB = false;
    public String[] allFamilies;
    public static final String DEFAULT_NAME = "Default";
    public static final String DIALOG_NAME = "Dialog";
    public static final byte FAMILY_NAME_ID = 1;
    public static final byte FONT_NAME_ID = 4;
    public static final byte POSTSCRIPT_NAME_ID = 6;
    public static final short ENGLISH_LANGID = 1033;
    public static final byte FONT_TYPE_TT = 4;
    public static final byte FONT_TYPE_T1 = 2;
    public static final byte FONT_TYPE_UNDEF = 0;
    static final int DIALOG = 3;
    static final int SANSSERIF = 1;
    static final int DIALOGINPUT = 4;
    static final int MONOSPACED = 2;
    static final int SERIF = 0;
    public static final String PLATFORM_FONT_NAME = "PlatformFontName";
    public static final String LOGICAL_FONT_NAME = "LogicalFontName";
    public static final String COMPONENT_INDEX = "ComponentIndex";
    public static final String STYLE_INDEX = "StyleIndex";
    public static final String[] FONT_MAPPING_KEYS = new String[]{"LogicalFontName.StyleName.ComponentIndex", "LogicalFontName.ComponentIndex"};
    public static final String FONT_CHARACTER_ENCODING = "fontcharset.LogicalFontName.ComponentIndex";
    public static final String EXCLUSION_RANGES = "exclusion.LogicalFontName.ComponentIndex";
    public static final String FONT_FILE_NAME = "filename.PlatformFontName";
    public static final String[] LOGICAL_FONT_FAMILIES = new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"};
    public static final String[] LOGICAL_FONT_NAMES = new String[]{"serif", "serif.plain", "serif.bold", "serif.italic", "serif.bolditalic", "sansserif", "sansserif.plain", "sansserif.bold", "sansserif.italic", "sansserif.bolditalic", "monospaced", "monospaced.plain", "monospaced.bold", "monospaced.italic", "monospaced.bolditalic", "dialog", "dialog.plain", "dialog.bold", "dialog.italic", "dialog.bolditalic", "dialoginput", "dialoginput.plain", "dialoginput.bold", "dialoginput.italic", "dialoginput.bolditalic"};
    public static final String[] LOGICAL_FONT_FACES = new String[]{"Serif", "Serif.plain", "Serif.bold", "Serif.italic", "Serif.bolditalic", "Sansserif", "Sansserif.plain", "Sansserif.bold", "Sansserif.italic", "Sansserif.bolditalic", "Monospaced", "Monospaced.plain", "Monospaced.bold", "Monospaced.italic", "Monospaced.bolditalic", "Dialog", "Dialog.plain", "Dialog.bold", "Dialog.italic", "Dialog.bolditalic", "Dialoginput", "Dialoginput.plain", "Dialoginput.bold", "Dialoginput.italic", "Dialoginput.bolditalic"};
    public static final String[] STYLE_NAMES = new String[]{"plain", "bold", "italic", "bolditalic"};
    private static final Hashtable<String, Integer> style_keys = new Hashtable(4);
    public static final String[] OS_VALUES;
    public static final String[] FP_FILE_NAMES;
    public Hashtable<String, Vector<FontProperty>> fProperties = new Hashtable();
    public static final int EMPTY_FONTS_CAPACITY = 10;
    protected Hashtable<String, Short> tableLCID = new Hashtable();
    public Hashtable<String, HashMapReference> fontsTable = new Hashtable();
    public ReferenceQueue<FontPeer> queue = new ReferenceQueue();
    private static FontManager inst;

    public static int getLogicalStyle(String lName) {
        Integer value = style_keys.get(lName);
        return value != null ? value : -1;
    }

    public FontManager() {
        this.allFamilies = this.getAllFamilies();
    }

    public static FontManager getInstance() {
        return new FontManager();
    }

    public FontPeer getFontPeer(String fontName, int _fontStyle, int size) {
        String key;
        String name;
        this.updateFontsTable();
        FontPeer peer = null;
        int fontStyle = _fontStyle;
        int logicalIndex = FontManager.getLogicalFaceIndex(fontName);
        if (logicalIndex != -1) {
            name = this.getLogicalFaceFromFont(fontStyle, logicalIndex);
            fontStyle = this.getStyleFromLogicalFace(name);
            key = name.concat(String.valueOf(size));
        } else {
            name = fontName;
            key = name.concat(String.valueOf(fontStyle)).concat(String.valueOf(size));
        }
        HashMapReference hmr = this.fontsTable.get(key);
        if (hmr != null) {
            peer = (FontPeer)hmr.get();
        }
        if (peer == null) {
            peer = this.createFontPeer(name, fontStyle, size, logicalIndex);
            if (peer == null) {
                peer = this.getFontPeer(DIALOG_NAME, fontStyle, size);
            }
            this.fontsTable.put(key, new HashMapReference(key, peer, this.queue));
        }
        return peer;
    }

    protected FontPeer createFontPeer(String name, int style, int size, int logicalIndex) {
        FontPeer peer = logicalIndex != -1 ? this.createLogicalFontPeer(name, style, size) : this.createPhysicalFontPeer(name, style, size);
        return peer;
    }

    public String getFamilyFromLogicalFace(String faceName) {
        int pos = faceName.indexOf(46);
        if (pos == -1) {
            return faceName;
        }
        return faceName.substring(0, pos);
    }

    private FontPeer createLogicalFontPeer(String faceName, int style, int size) {
        String family = this.getFamilyFromLogicalFace(faceName);
        FontProperty[] fps = this.getFontProperties(family.toLowerCase() + "." + style);
        if (fps != null) {
            int numFonts = fps.length;
            FontPeerImpl[] physicalFonts = new FontPeerImpl[numFonts];
            for (int i = 0; i < numFonts; ++i) {
                int fpStyle;
                FontProperty fp = fps[i];
                String name = fp.getName();
                String key = name.concat(String.valueOf(fpStyle = fp.getStyle())).concat(String.valueOf(size));
                HashMapReference hmr = this.fontsTable.get(key);
                if (hmr != null) {
                    physicalFonts[i] = (FontPeerImpl)hmr.get();
                }
                if (physicalFonts[i] == null) {
                    physicalFonts[i] = (FontPeerImpl)this.createPhysicalFontPeer(name, fpStyle, size);
                    this.fontsTable.put(key, new HashMapReference(key, physicalFonts[i], this.queue));
                }
                if (physicalFonts[i] != null) continue;
                physicalFonts[i] = (FontPeerImpl)this.getDefaultFont(style, size);
            }
            return new CompositeFont(family, faceName, style, size, fps, physicalFonts);
        }
        FontPeerImpl peer = (FontPeerImpl)this.getDefaultFont(style, size);
        return peer;
    }

    public FontPeer createPhysicalFontPeer(String name, int style, int size) {
        return new SfntlyFontPeer(name, style, size);
    }

    public FontPeer getDefaultFont(int style, int size) {
        this.updateFontsTable();
        FontPeer peer = null;
        String key = DEFAULT_NAME.concat(String.valueOf(style)).concat(String.valueOf(size));
        HashMapReference hmr = this.fontsTable.get(key);
        if (hmr != null) {
            peer = (FontPeer)hmr.get();
        }
        if (peer == null) {
            peer = this.createDefaultFont(style, size);
            ((FontPeerImpl)peer).setFamily(DEFAULT_NAME);
            ((FontPeerImpl)peer).setPSName(DEFAULT_NAME);
            ((FontPeerImpl)peer).setFontName(DEFAULT_NAME);
            this.fontsTable.put(key, new HashMapReference(key, peer, this.queue));
        }
        return peer;
    }

    public FontPeer createDefaultFont(int style, int size) {
        return new SfntlyFontPeer("sans serif", style, size);
    }

    public String getLogicalFaceFromFont(int fontStyle, int logicalIndex) {
        int style = 0;
        String name = LOGICAL_FONT_FACES[logicalIndex];
        int pos = name.indexOf(46);
        if (pos == -1) {
            return this.createLogicalFace(name, fontStyle);
        }
        String styleName = name.substring(pos + 1);
        name = name.substring(0, pos);
        style = fontStyle | FontManager.getLogicalStyle(styleName);
        return this.createLogicalFace(name, style);
    }

    public int getStyleFromLogicalFace(String name) {
        int pos = name.indexOf(46);
        if (pos == -1) {
            return 0;
        }
        String styleName = name.substring(pos + 1);
        int style = FontManager.getLogicalStyle(styleName);
        return style;
    }

    public String createLogicalFace(String family, int styleIndex) {
        return family + "." + STYLE_NAMES[styleIndex];
    }

    public Short getLCID(Locale l) {
        if (this.tableLCID.size() == 0) {
            this.initLCIDTable();
        }
        return this.tableLCID.get(l.toString());
    }

    public void initLCIDTable() {
    }

    public File getTempFontFile() throws IOException {
        File fontFile = File.createTempFile("jFont", ".ttf");
        fontFile.deleteOnExit();
        return fontFile;
    }

    public static File getFontPropertyFile() {
        int i;
        File file = null;
        String javaHome = Utils.getSystemProperty("java.home");
        Locale l = Locale.getDefault();
        String language = l.getLanguage();
        String country = l.getCountry();
        String fileEncoding = Utils.getSystemProperty("file.encoding");
        String os = System.getProperty("os.name");
        for (i = 0; i < OS_VALUES.length; ++i) {
            if (!os.endsWith(OS_VALUES[i])) continue;
            os = OS_VALUES[i];
            break;
        }
        if (i == OS_VALUES.length) {
            os = null;
        }
        String version = System.getProperty("os.version");
        for (i = 0; i < FP_FILE_NAMES.length; ++i) {
            StringBuilder result;
            int curPos;
            String pathname = FP_FILE_NAMES[i];
            if (os != null) {
                pathname = pathname.replaceFirst("OS", os);
            }
            if ((curPos = (result = new StringBuilder(pathname = javaHome + pathname)).indexOf("Language")) >= 0) {
                result.replace(curPos, curPos + 8, language);
            }
            if ((curPos = result.indexOf("Country")) >= 0) {
                result.replace(curPos, curPos + 7, country);
            }
            if ((curPos = result.indexOf("Encoding")) >= 0) {
                result.replace(curPos, curPos + 8, fileEncoding);
            }
            if ((curPos = result.indexOf("Version")) >= 0) {
                result.replace(curPos, curPos + 7, version);
            }
            if ((file = new File(pathname = result.toString())).exists()) break;
        }
        return file.exists() ? file : null;
    }

    public static int[] parseIntervals(String exclusionString) {
        int num;
        int[] results = null;
        if (exclusionString == null) {
            return null;
        }
        String[] intervals = exclusionString.split(",");
        if (intervals != null && (num = intervals.length) > 0) {
            results = new int[intervals.length << 1];
            for (int i = 0; i < intervals.length; ++i) {
                String[] ranges = intervals[i].split("-");
                results[i * 2] = Integer.parseInt(ranges[0], 16);
                results[i * 2 + 1] = Integer.parseInt(ranges[1], 16);
            }
        }
        return results;
    }

    public static Properties getProperties(File file) {
        Properties props = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            props = new Properties();
            props.load(fis);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return props;
    }

    public FontProperty[] getFontProperties(String fpName) {
        Vector<FontProperty> props = this.fProperties.get(fpName);
        if (props == null) {
            return null;
        }
        int size = props.size();
        if (size == 0) {
            return null;
        }
        FontProperty[] fps = new FontProperty[size];
        for (int i = 0; i < fps.length; ++i) {
            fps[i] = props.elementAt(i);
        }
        return fps;
    }

    public static int getLogicalFaceIndex(String fontName) {
        for (int i = 0; i < LOGICAL_FONT_NAMES.length; ++i) {
            if (!LOGICAL_FONT_NAMES[i].equalsIgnoreCase(fontName)) continue;
            return i;
        }
        return -1;
    }

    public boolean isFamilyExist(String familyName) {
        return this.getFamilyIndex(familyName) != -1;
    }

    public int getFamilyIndex(String familyName) {
        for (int i = 0; i < this.allFamilies.length; ++i) {
            if (!familyName.equalsIgnoreCase(this.allFamilies[i])) continue;
            return i;
        }
        return -1;
    }

    public String getFamily(int index) {
        return this.allFamilies[index];
    }

    public int getFaceIndex(String faceName) {
        return -1;
    }

    public String[] getAllFamilies() {
        return new String[0];
    }

    public Font[] getAllFonts() {
        return new Font[0];
    }

    private void updateFontsTable() {
        HashMapReference r;
        while ((r = (HashMapReference)this.queue.poll()) != null) {
            this.fontsTable.remove(r.getKey());
        }
    }

    static {
        for (int i = 0; i < STYLE_NAMES.length; ++i) {
            style_keys.put(STYLE_NAMES[i], i);
        }
        OS_VALUES = new String[]{"NT", "98", "2000", "Me", "XP", "Redhat", "Turbo", "SuSE"};
        FP_FILE_NAMES = new String[]{"/lib/font.properties.Language_Country_Encoding.OSVersion", "/lib/font.properties.Language_Country_Encoding.OS", "/lib/font.properties.Language_Country_Encoding.Version", "/lib/font.properties.Language_Country_Encoding", "/lib/font.properties.Language_Country.OSVersion", "/lib/font.properties.Language_Country.OS", "/lib/font.properties.Language_Country.Version", "/lib/font.properties.Language_Country", "/lib/font.properties.Language_Encoding.OSVersion", "/lib/font.properties.Language_Encoding.OS", "/lib/font.properties.Language_Encoding.Version", "/lib/font.properties.Language_Encoding", "/lib/font.properties.Language.OSVersion", "/lib/font.properties.Language.OS", "/lib/font.properties.Language.Version", "/lib/font.properties.Language", "/lib/font.properties.Encoding.OSVersion", "/lib/font.properties.Encoding.OS", "/lib/font.properties.Encoding.Version", "/lib/font.properties.Encoding", "/lib/font.properties.OSVersion", "/lib/font.properties.OS", "/lib/font.properties.Version", "/lib/font.properties"};
        inst = new FontManager();
    }

    protected class HashMapReference
    extends SoftReference<FontPeer> {
        private final String key;

        public HashMapReference(String key, FontPeer value, ReferenceQueue<FontPeer> queue) {
            super(value, queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }
    }
}

