/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.List;
import java.util.Map;

public class FontFinder {
    private static final float DEFAULT_FONT_SIZE = 12.0f;
    private static final Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    private static final int NUM_BLOCKS = 256;
    private static final int BLOCK_SIZE = 256;
    private static final int INDEX_MASK = 255;
    private static final int BLOCK_SHIFT = 8;
    private static final int[][] blocks = new int[256][];

    static Font findFontForChar(char c) {
        int blockNum = c >> 8;
        int index = c & 0xFF;
        if (blocks[blockNum] == null) {
            FontFinder.blocks[blockNum] = new int[256];
        }
        if (blocks[blockNum][index] == 0) {
            FontFinder.blocks[blockNum][index] = 1;
            for (int i = 0; i < fonts.length; ++i) {
                if (!fonts[i].canDisplay(c)) continue;
                FontFinder.blocks[blockNum][index] = i + 1;
                break;
            }
        }
        return FontFinder.getDefaultSizeFont(blocks[blockNum][index] - 1);
    }

    static Font getDefaultSizeFont(int i) {
        if ((float)fonts[i].getSize() != 12.0f) {
            FontFinder.fonts[i] = fonts[i].deriveFont(12.0f);
        }
        return fonts[i];
    }

    static void findFonts(char[] text, int runStart, int runLimit, List<Integer> runStarts, Map<Integer, Object> fonts) {
        Font prevFont = null;
        for (int i = runStart; i < runLimit; ++i) {
            Font currFont = FontFinder.findFontForChar(text[i]);
            if (currFont == prevFont) continue;
            prevFont = currFont;
            Integer idx = new Integer(i);
            fonts.put(idx, currFont);
            if (i == runStart) continue;
            runStarts.add(idx);
        }
    }
}

