/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.apache.harmony.awt.gl.font.FontExtraMetrics;
import org.apache.harmony.awt.gl.font.FontPeerImpl;
import org.apache.harmony.awt.gl.font.FontProperty;
import org.apache.harmony.awt.gl.font.Glyph;
import org.apache.harmony.awt.gl.font.LineMetricsImpl;

public class CompositeFont
extends FontPeerImpl {
    int numFonts;
    String family;
    String face;
    String[] fontNames;
    FontProperty[] fontProperties;
    public FontPeerImpl[] fPhysicalFonts;
    int missingGlyphCode = -1;
    LineMetricsImpl nlm = null;
    int cachedNumGlyphs = -1;

    public CompositeFont(String familyName, String faceName, int _style, int _size, FontProperty[] fProperties, FontPeerImpl[] physFonts) {
        this.size = _size;
        this.name = faceName;
        this.family = familyName;
        this.style = _style;
        this.face = faceName;
        this.psName = faceName;
        this.fontProperties = fProperties;
        this.fPhysicalFonts = physFonts;
        this.numFonts = this.fPhysicalFonts.length;
        this.setDefaultLineMetrics("", null);
        this.uniformLM = false;
    }

    public int getCharFontIndex(char chr) {
        for (int i = 0; i < this.numFonts; ++i) {
            if (this.fontProperties[i].isCharExcluded(chr) || !this.fPhysicalFonts[i].canDisplay(chr)) continue;
            return i;
        }
        return -1;
    }

    public int getCharFontIndex(char chr, int defaultValue) {
        for (int i = 0; i < this.numFonts; ++i) {
            if (this.fontProperties[i].isCharExcluded(chr) || !this.fPhysicalFonts[i].canDisplay(chr)) continue;
            return i;
        }
        return defaultValue;
    }

    @Override
    public boolean canDisplay(char chr) {
        return this.getCharFontIndex(chr) != -1;
    }

    @Override
    public int getAscent() {
        return this.nlm.getLogicalAscent();
    }

    @Override
    public LineMetrics getLineMetrics(String str, FontRenderContext frc, AffineTransform at) {
        AffineTransform frcAt = null;
        LineMetricsImpl lm = (LineMetricsImpl)this.nlm.clone();
        lm.setNumChars(str.length());
        if (frc != null) {
            frcAt = frc.getTransform();
        }
        if (at != null && !at.isIdentity()) {
            if (frcAt != null) {
                at.concatenate(frcAt);
            }
            lm.scale((float)at.getScaleX(), (float)at.getScaleY());
        } else if (frcAt != null && !frcAt.isIdentity()) {
            lm.scale((float)frcAt.getScaleX(), (float)frcAt.getScaleY());
        }
        return lm;
    }

    @Override
    public LineMetrics getLineMetrics() {
        if (this.nlm == null) {
            this.setDefaultLineMetrics("", null);
        }
        return this.nlm;
    }

    private void setDefaultLineMetrics(String str, FontRenderContext frc) {
        LineMetrics lm = this.fPhysicalFonts[0].getLineMetrics(str, frc, null);
        float maxCharWidth = (float)this.fPhysicalFonts[0].getMaxCharBounds(frc).getWidth();
        if (this.numFonts == 1) {
            this.nlm = (LineMetricsImpl)lm;
            return;
        }
        float[] baselineOffsets = lm.getBaselineOffsets();
        int numChars = str.length();
        int baseLineIndex = lm.getBaselineIndex();
        float maxUnderlineThickness = lm.getUnderlineThickness();
        float maxUnderlineOffset = lm.getUnderlineOffset();
        float maxStrikethroughThickness = lm.getStrikethroughThickness();
        float minStrikethroughOffset = lm.getStrikethroughOffset();
        float maxLeading = lm.getLeading();
        float maxHeight = lm.getHeight();
        float maxAscent = lm.getAscent();
        float maxDescent = lm.getDescent();
        for (int i = 1; i < this.numFonts; ++i) {
            float width;
            lm = this.fPhysicalFonts[i].getLineMetrics(str, frc, null);
            if (maxUnderlineThickness < lm.getUnderlineThickness()) {
                maxUnderlineThickness = lm.getUnderlineThickness();
            }
            if (maxUnderlineOffset < lm.getUnderlineOffset()) {
                maxUnderlineOffset = lm.getUnderlineOffset();
            }
            if (maxStrikethroughThickness < lm.getStrikethroughThickness()) {
                maxStrikethroughThickness = lm.getStrikethroughThickness();
            }
            if (minStrikethroughOffset > lm.getStrikethroughOffset()) {
                minStrikethroughOffset = lm.getStrikethroughOffset();
            }
            if (maxLeading < lm.getLeading()) {
                maxLeading = lm.getLeading();
            }
            if (maxAscent < lm.getAscent()) {
                maxAscent = lm.getAscent();
            }
            if (maxDescent < lm.getDescent()) {
                maxDescent = lm.getDescent();
            }
            if (maxCharWidth < (width = (float)this.fPhysicalFonts[i].getMaxCharBounds(frc).getWidth())) {
                maxCharWidth = width;
            }
            for (int j = 0; j < baselineOffsets.length; ++j) {
                float[] offsets = lm.getBaselineOffsets();
                if (!(baselineOffsets[j] > offsets[j])) continue;
                baselineOffsets[j] = offsets[j];
            }
        }
        maxHeight = maxAscent + maxDescent + maxLeading;
        this.nlm = new LineMetricsImpl(numChars, baseLineIndex, baselineOffsets, maxUnderlineThickness, maxUnderlineOffset, maxStrikethroughThickness, minStrikethroughOffset, maxLeading, maxHeight, maxAscent, maxDescent, maxCharWidth);
    }

    @Override
    public int getNumGlyphs() {
        if (this.cachedNumGlyphs == -1) {
            this.cachedNumGlyphs = 0;
            for (int i = 0; i < this.numFonts; ++i) {
                this.cachedNumGlyphs += this.fPhysicalFonts[i].getNumGlyphs();
            }
        }
        return this.cachedNumGlyphs;
    }

    @Override
    public float getItalicAngle() {
        return this.fPhysicalFonts[0].getItalicAngle();
    }

    public Rectangle2D getStringBounds(char[] chars, int start, int end, FontRenderContext frc) {
        if (this.nlm == null) {
            this.setDefaultLineMetrics("", frc);
        }
        LineMetricsImpl lm = this.nlm;
        float minY = -((LineMetrics)lm).getAscent();
        float minX = 0.0f;
        float height = ((LineMetrics)lm).getHeight();
        float width = 0.0f;
        for (int i = start; i < end; ++i) {
            width += (float)this.charWidth(chars[i]);
        }
        Rectangle2D.Float rect2D = new Rectangle2D.Float(minX, minY, width, height);
        return rect2D;
    }

    @Override
    public Rectangle2D getMaxCharBounds(FontRenderContext frc) {
        Rectangle2D rect2D = this.fPhysicalFonts[0].getMaxCharBounds(frc);
        float minY = (float)rect2D.getY();
        float maxWidth = (float)rect2D.getWidth();
        float maxHeight = (float)rect2D.getHeight();
        if (this.numFonts == 1) {
            return rect2D;
        }
        for (int i = 1; i < this.numFonts; ++i) {
            if (this.fPhysicalFonts[i] == null) continue;
            rect2D = this.fPhysicalFonts[i].getMaxCharBounds(frc);
            float y = (float)rect2D.getY();
            float mWidth = (float)rect2D.getWidth();
            float mHeight = (float)rect2D.getHeight();
            if (y < minY) {
                minY = y;
            }
            if (mWidth > maxWidth) {
                maxHeight = mWidth;
            }
            if (!(mHeight > maxHeight)) continue;
            maxHeight = mHeight;
        }
        rect2D = new Rectangle2D.Float(0.0f, minY, maxWidth, maxHeight);
        return rect2D;
    }

    @Override
    public String getFontName() {
        return this.face;
    }

    @Override
    public String getPSName() {
        return this.psName;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public int getMissingGlyphCode() {
        return this.fPhysicalFonts[0].getMissingGlyphCode();
    }

    @Override
    public Glyph getGlyph(char ch) {
        for (int i = 0; i < this.numFonts; ++i) {
            if (this.fontProperties[i].isCharExcluded(ch) || ch >= ' ' && !this.fPhysicalFonts[i].canDisplay(ch)) continue;
            return this.fPhysicalFonts[i].getGlyph(ch);
        }
        return this.getDefaultGlyph();
    }

    @Override
    public int charWidth(int ind) {
        return this.charWidth((char)ind);
    }

    @Override
    public int charWidth(char c) {
        Glyph gl = this.getGlyph(c);
        return (int)gl.getGlyphPointMetrics().getAdvanceX();
    }

    public String toString() {
        return new String(this.getClass().getName() + "[name=" + this.name + ",style=" + this.style + ",fps=" + this.fontProperties + "]");
    }

    @Override
    public Glyph getDefaultGlyph() {
        return this.fPhysicalFonts[0].getDefaultGlyph();
    }

    @Override
    public FontExtraMetrics getExtraMetrics() {
        return this.fPhysicalFonts[0].getExtraMetrics();
    }

    @Override
    public void dispose() {
    }
}

