/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Shape;
import java.awt.font.TextHitInfo;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.apache.harmony.awt.gl.font.TextRunBreaker;
import org.apache.harmony.awt.gl.font.TextRunSegment;
import org.apache.harmony.awt.internal.nls.Messages;

public class CaretManager {
    private TextRunBreaker breaker;

    public CaretManager(TextRunBreaker breaker) {
        this.breaker = breaker;
    }

    private void checkHit(TextHitInfo info) {
        int idx = info.getInsertionIndex();
        if (idx < 0 || idx > this.breaker.getCharCount()) {
            throw new IllegalArgumentException(Messages.getString("awt.42"));
        }
    }

    private int getVisualFromHitInfo(TextHitInfo hitInfo) {
        int idx = hitInfo.getCharIndex();
        if (idx >= 0 && idx < this.breaker.getCharCount()) {
            int visual = this.breaker.getVisualFromLogical(idx);
            if (hitInfo.isLeadingEdge() ^ (this.breaker.getLevel(idx) & 1) == 0) {
                ++visual;
            }
            return visual;
        }
        if (idx < 0) {
            return this.breaker.isLTR() ? 0 : this.breaker.getCharCount();
        }
        return this.breaker.isLTR() ? this.breaker.getCharCount() : 0;
    }

    private TextHitInfo getHitInfoFromVisual(int visual) {
        boolean first;
        boolean bl = first = visual == 0;
        if (!first && visual != this.breaker.getCharCount()) {
            int logical = this.breaker.getLogicalFromVisual(visual);
            return (this.breaker.getLevel(logical) & 1) == 0 ? TextHitInfo.leading(logical) : TextHitInfo.trailing(logical);
        }
        if (first) {
            return this.breaker.isLTR() ? TextHitInfo.trailing(-1) : TextHitInfo.leading(this.breaker.getCharCount());
        }
        return this.breaker.isLTR() ? TextHitInfo.leading(this.breaker.getCharCount()) : TextHitInfo.trailing(-1);
    }

    public float[] getCaretInfo(TextHitInfo hitInfo) {
        float angle;
        float advance;
        TextRunSegment seg;
        this.checkHit(hitInfo);
        float[] res = new float[2];
        int visual = this.getVisualFromHitInfo(hitInfo);
        if (visual < this.breaker.getCharCount()) {
            int logIdx = this.breaker.getLogicalFromVisual(visual);
            int segmentIdx = this.breaker.logical2segment[logIdx];
            seg = this.breaker.runSegments.get(segmentIdx);
            advance = seg.x + seg.getAdvanceDelta(seg.getStart(), logIdx);
            angle = seg.metrics.italicAngle;
        } else {
            int logIdx = this.breaker.getLogicalFromVisual(visual - 1);
            int segmentIdx = this.breaker.logical2segment[logIdx];
            seg = this.breaker.runSegments.get(segmentIdx);
            advance = seg.x + seg.getAdvanceDelta(seg.getStart(), logIdx + 1);
        }
        angle = seg.metrics.italicAngle;
        res[0] = advance;
        res[1] = angle;
        return res;
    }

    public TextHitInfo getNextRightHit(TextHitInfo hitInfo) {
        this.checkHit(hitInfo);
        int visual = this.getVisualFromHitInfo(hitInfo);
        if (visual == this.breaker.getCharCount()) {
            return null;
        }
        while (visual <= this.breaker.getCharCount()) {
            TextHitInfo newInfo;
            if ((newInfo = this.getHitInfoFromVisual(++visual)).getCharIndex() >= this.breaker.logical2segment.length) {
                return newInfo;
            }
            if (hitInfo.getCharIndex() >= 0 && this.breaker.logical2segment[newInfo.getCharIndex()] != this.breaker.logical2segment[hitInfo.getCharIndex()]) {
                return newInfo;
            }
            TextRunSegment seg = this.breaker.runSegments.get(this.breaker.logical2segment[newInfo.getCharIndex()]);
            if (seg.charHasZeroAdvance(newInfo.getCharIndex())) continue;
            return newInfo;
        }
        return null;
    }

    public TextHitInfo getNextLeftHit(TextHitInfo hitInfo) {
        this.checkHit(hitInfo);
        int visual = this.getVisualFromHitInfo(hitInfo);
        if (visual == 0) {
            return null;
        }
        while (visual >= 0) {
            TextHitInfo newInfo;
            if ((newInfo = this.getHitInfoFromVisual(--visual)).getCharIndex() < 0) {
                return newInfo;
            }
            if (hitInfo.getCharIndex() < this.breaker.logical2segment.length && this.breaker.logical2segment[newInfo.getCharIndex()] != this.breaker.logical2segment[hitInfo.getCharIndex()]) {
                return newInfo;
            }
            TextRunSegment seg = this.breaker.runSegments.get(this.breaker.logical2segment[newInfo.getCharIndex()]);
            if (seg.charHasZeroAdvance(newInfo.getCharIndex())) continue;
            return newInfo;
        }
        return null;
    }

    public TextHitInfo getVisualOtherHit(TextHitInfo hitInfo) {
        boolean resIsLeading;
        int resIdx;
        this.checkHit(hitInfo);
        int idx = hitInfo.getCharIndex();
        if (idx >= 0 && idx < this.breaker.getCharCount()) {
            int visual = this.breaker.getVisualFromLogical(idx);
            if ((this.breaker.getLevel(idx) & 1) == 0 ^ hitInfo.isLeadingEdge()) {
                if (++visual == this.breaker.getCharCount()) {
                    if (this.breaker.isLTR()) {
                        resIdx = this.breaker.getCharCount();
                        resIsLeading = true;
                    } else {
                        resIdx = -1;
                        resIsLeading = false;
                    }
                } else {
                    resIdx = this.breaker.getLogicalFromVisual(visual);
                    resIsLeading = (this.breaker.getLevel(resIdx) & 1) == 0;
                }
            } else if (--visual == -1) {
                if (this.breaker.isLTR()) {
                    resIdx = -1;
                    resIsLeading = false;
                } else {
                    resIdx = this.breaker.getCharCount();
                    resIsLeading = true;
                }
            } else {
                resIdx = this.breaker.getLogicalFromVisual(visual);
                resIsLeading = (this.breaker.getLevel(resIdx) & 1) != 0;
            }
        } else {
            resIsLeading = idx < 0 ? (this.breaker.isLTR() ? (this.breaker.getLevel(resIdx = this.breaker.getLogicalFromVisual(0)) & 1) == 0 : (this.breaker.getLevel(resIdx = this.breaker.getLogicalFromVisual(this.breaker.getCharCount() - 1)) & 1) != 0) : (this.breaker.isLTR() ? (this.breaker.getLevel(resIdx = this.breaker.getLogicalFromVisual(this.breaker.getCharCount() - 1)) & 1) != 0 : (this.breaker.getLevel(resIdx = this.breaker.getLogicalFromVisual(0)) & 1) == 0);
        }
        return resIsLeading ? TextHitInfo.leading(resIdx) : TextHitInfo.trailing(resIdx);
    }

    public Line2D getCaretShape(TextHitInfo hitInfo, TextLayout layout) {
        return this.getCaretShape(hitInfo, layout, true, false, null);
    }

    public Line2D getCaretShape(TextHitInfo hitInfo, TextLayout layout, boolean useItalic, boolean useBounds, Rectangle2D bounds) {
        float x1;
        float x2;
        float y2;
        float y1;
        this.checkHit(hitInfo);
        int charIdx = hitInfo.getCharIndex();
        if (charIdx >= 0 && charIdx < this.breaker.getCharCount()) {
            TextRunSegment segment = this.breaker.runSegments.get(this.breaker.logical2segment[charIdx]);
            y1 = segment.metrics.descent;
            y2 = -segment.metrics.ascent - segment.metrics.leading;
            x1 = x2 = segment.getCharPosition(charIdx) + (hitInfo.isLeadingEdge() ? 0.0f : segment.getCharAdvance(charIdx));
        } else {
            y1 = layout.getDescent();
            y2 = -layout.getAscent() - layout.getLeading();
            x2 = (this.breaker.getBaseLevel() & 1) == 0 ^ charIdx < 0 ? layout.getAdvance() : 0.0f;
            x1 = x2;
        }
        if (useBounds) {
            y1 = (float)bounds.getMaxY();
            y2 = (float)bounds.getMinY();
            if ((double)x2 > bounds.getMaxX()) {
                x1 = x2 = (float)bounds.getMaxX();
            }
            if ((double)x1 < bounds.getMinX()) {
                x1 = x2 = (float)bounds.getMinX();
            }
        }
        return new Line2D.Float(x1, y1, x2, y2);
    }

    public Shape[] getCaretShapes(int offset, Rectangle2D bounds, TextLayout.CaretPolicy policy, TextLayout layout) {
        Shape[] shapeArray;
        TextHitInfo hit1 = TextHitInfo.afterOffset(offset);
        TextHitInfo hit2 = this.getVisualOtherHit(hit1);
        Line2D caret1 = this.getCaretShape(hit1, layout);
        if (this.getVisualFromHitInfo(hit1) == this.getVisualFromHitInfo(hit2)) {
            return new Shape[]{caret1, null};
        }
        Line2D caret2 = this.getCaretShape(hit2, layout);
        TextHitInfo strongHit = policy.getStrongCaret(hit1, hit2, layout);
        if (strongHit.equals(hit1)) {
            Shape[] shapeArray2 = new Shape[2];
            shapeArray2[0] = caret1;
            shapeArray = shapeArray2;
            shapeArray2[1] = caret2;
        } else {
            Shape[] shapeArray3 = new Shape[2];
            shapeArray3[0] = caret2;
            shapeArray = shapeArray3;
            shapeArray3[1] = caret1;
        }
        return shapeArray;
    }

    GeneralPath connectCarets(Line2D caret1, Line2D caret2) {
        GeneralPath path = new GeneralPath(1);
        path.moveTo((float)caret1.getX1(), (float)caret1.getY1());
        path.lineTo((float)caret2.getX1(), (float)caret2.getY1());
        path.lineTo((float)caret2.getX2(), (float)caret2.getY2());
        path.lineTo((float)caret1.getX2(), (float)caret1.getY2());
        path.closePath();
        return path;
    }

    public Shape getVisualHighlightShape(TextHitInfo hit1, TextHitInfo hit2, Rectangle2D bounds, TextLayout layout) {
        this.checkHit(hit1);
        this.checkHit(hit2);
        Line2D caret1 = this.getCaretShape(hit1, layout, false, true, bounds);
        Line2D caret2 = this.getCaretShape(hit2, layout, false, true, bounds);
        return this.connectCarets(caret1, caret2);
    }

    public int[] getLogicalRangesForVisualSelection(TextHitInfo hit1, TextHitInfo hit2) {
        int prevLogical;
        this.checkHit(hit1);
        this.checkHit(hit2);
        int visual1 = this.getVisualFromHitInfo(hit1);
        int visual2 = this.getVisualFromHitInfo(hit2);
        if (visual1 > visual2) {
            int tmp = visual2;
            visual2 = visual1;
            visual1 = tmp;
        }
        int[] results = new int[512];
        int numRuns = 0;
        int runStart = prevLogical = this.breaker.getLogicalFromVisual(visual1);
        int logical = prevLogical;
        for (int i = visual1 + 1; i <= visual2; ++i) {
            logical = this.breaker.getLogicalFromVisual(i);
            int diff = logical - prevLogical;
            if (diff > 1 || diff < -1) {
                results[numRuns * 2] = Math.min(runStart, prevLogical);
                results[numRuns * 2 + 1] = Math.max(runStart, prevLogical);
                ++numRuns;
                runStart = logical;
            }
            prevLogical = logical;
        }
        results[numRuns * 2] = Math.min(runStart, logical);
        results[numRuns * 2 + 1] = Math.max(runStart, logical);
        int[] retval = new int[++numRuns * 2];
        System.arraycopy(results, 0, retval, 0, numRuns * 2);
        return retval;
    }

    public Shape getLogicalHighlightShape(int firstEndpoint, int secondEndpoint, Rectangle2D bounds, TextLayout layout) {
        GeneralPath res = new GeneralPath();
        for (int i = firstEndpoint; i <= secondEndpoint; ++i) {
            int endRun = this.breaker.getLevelRunLimit(i, secondEndpoint);
            TextHitInfo hit1 = TextHitInfo.leading(i);
            TextHitInfo hit2 = TextHitInfo.trailing(endRun - 1);
            Line2D caret1 = this.getCaretShape(hit1, layout, false, true, bounds);
            Line2D caret2 = this.getCaretShape(hit2, layout, false, true, bounds);
            res.append(this.connectCarets(caret1, caret2), false);
            i = endRun;
        }
        return res;
    }
}

