/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.font;

import java.awt.Font;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import org.apache.harmony.awt.gl.font.TextMetricsCalculator;

public class BasicMetrics {
    int baseLineIndex;
    float ascent;
    float descent;
    float leading;
    float advance;
    float italicAngle;
    float superScriptOffset;
    float underlineOffset;
    float underlineThickness;
    float strikethroughOffset;
    float strikethroughThickness;

    BasicMetrics(LineMetrics lm, Font font) {
        this.ascent = lm.getAscent();
        this.descent = lm.getDescent();
        this.leading = lm.getLeading();
        this.underlineOffset = lm.getUnderlineOffset();
        this.underlineThickness = lm.getUnderlineThickness();
        this.strikethroughOffset = lm.getStrikethroughOffset();
        this.strikethroughThickness = lm.getStrikethroughThickness();
        this.baseLineIndex = lm.getBaselineIndex();
        this.italicAngle = font.getItalicAngle();
        this.superScriptOffset = (float)font.getTransform().getTranslateY();
    }

    BasicMetrics(GraphicAttribute ga) {
        this.ascent = ga.getAscent();
        this.descent = ga.getDescent();
        this.leading = 2.0f;
        this.baseLineIndex = ga.getAlignment();
        this.italicAngle = 0.0f;
        this.superScriptOffset = 0.0f;
        this.underlineOffset = Math.max(this.descent / 2.0f, 1.0f);
        this.underlineThickness = Math.max(this.ascent / 13.0f, 1.0f);
        this.strikethroughOffset = -this.ascent / 2.0f;
        this.strikethroughThickness = this.underlineThickness;
    }

    BasicMetrics(TextMetricsCalculator tmc) {
        this.ascent = tmc.ascent;
        this.descent = tmc.descent;
        this.leading = tmc.leading;
        this.advance = tmc.advance;
        this.baseLineIndex = tmc.baselineIndex;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getDescent() {
        return this.descent;
    }

    public float getLeading() {
        return this.leading;
    }

    public float getAdvance() {
        return this.advance;
    }

    public int getBaseLineIndex() {
        return this.baseLineIndex;
    }
}

