/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.color;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.util.ArrayList;
import org.apache.harmony.awt.gl.AwtImageBackdoorAccessor;
import org.apache.harmony.awt.gl.color.NativeCMM;
import org.apache.harmony.awt.internal.nls.Messages;

class NativeImageFormat {
    private static final int PT_ANY = 0;
    private static final int PT_GRAY = 3;
    private static final int PT_RGB = 4;
    private static final int INT_RGB_LCMS_FMT;
    private static final int INT_ARGB_LCMS_FMT;
    private static final int INT_BGR_LCMS_FMT;
    private static final int THREE_BYTE_BGR_LCMS_FMT;
    private static final int FOUR_BYTE_ABGR_LCMS_FMT;
    private static final int BYTE_GRAY_LCMS_FMT;
    private static final int USHORT_GRAY_LCMS_FMT;
    private int cmmFormat = 0;
    private int rows = 0;
    private int cols = 0;
    private int scanlineStride = -1;
    private Object imageData;
    private int dataOffset;
    private int alphaOffset = -1;

    private static int colorspaceSh(int s) {
        return s << 16;
    }

    private static int swapfirstSh(int s) {
        return s << 14;
    }

    private static int flavorSh(int s) {
        return s << 13;
    }

    private static int planarSh(int s) {
        return s << 12;
    }

    private static int endianSh(int s) {
        return s << 11;
    }

    private static int doswapSh(int s) {
        return s << 10;
    }

    private static int extraSh(int s) {
        return s << 7;
    }

    private static int channelsSh(int s) {
        return s << 3;
    }

    private static int bytesSh(int s) {
        return s;
    }

    Object getChannelData() {
        return this.imageData;
    }

    int getNumCols() {
        return this.cols;
    }

    int getNumRows() {
        return this.rows;
    }

    public NativeImageFormat() {
    }

    public NativeImageFormat(Object imgData, int nChannels, int nRows, int nCols) {
        if (imgData instanceof short[]) {
            this.cmmFormat |= NativeImageFormat.bytesSh(2);
        } else if (imgData instanceof byte[]) {
            this.cmmFormat |= NativeImageFormat.bytesSh(1);
        } else {
            throw new IllegalArgumentException(Messages.getString("awt.47"));
        }
        this.cmmFormat |= NativeImageFormat.channelsSh(nChannels);
        this.rows = nRows;
        this.cols = nCols;
        this.imageData = imgData;
        this.dataOffset = 0;
    }

    public static NativeImageFormat createNativeImageFormat(BufferedImage bi) {
        NativeImageFormat fmt = new NativeImageFormat();
        switch (bi.getType()) {
            case 1: {
                fmt.cmmFormat = INT_RGB_LCMS_FMT;
                break;
            }
            case 2: 
            case 3: {
                fmt.cmmFormat = INT_ARGB_LCMS_FMT;
                fmt.alphaOffset = 3;
                break;
            }
            case 4: {
                fmt.cmmFormat = INT_BGR_LCMS_FMT;
                break;
            }
            case 5: {
                fmt.cmmFormat = THREE_BYTE_BGR_LCMS_FMT;
                break;
            }
            case 6: 
            case 7: {
                fmt.cmmFormat = FOUR_BYTE_ABGR_LCMS_FMT;
                fmt.alphaOffset = 0;
                break;
            }
            case 10: {
                fmt.cmmFormat = BYTE_GRAY_LCMS_FMT;
                break;
            }
            case 11: {
                fmt.cmmFormat = USHORT_GRAY_LCMS_FMT;
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                return null;
            }
        }
        if (fmt.cmmFormat == 0) {
            ColorModel cm = bi.getColorModel();
            SampleModel sm = bi.getSampleModel();
            if (sm instanceof ComponentSampleModel) {
                ComponentSampleModel csm = (ComponentSampleModel)sm;
                fmt.cmmFormat = NativeImageFormat.getFormatFromComponentModel(csm, cm.hasAlpha());
                fmt.scanlineStride = NativeImageFormat.calculateScanlineStrideCSM(csm, bi.getRaster());
            } else if (sm instanceof SinglePixelPackedSampleModel) {
                SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
                fmt.cmmFormat = NativeImageFormat.getFormatFromSPPSampleModel(sppsm, cm.hasAlpha());
                fmt.scanlineStride = NativeImageFormat.calculateScanlineStrideSPPSM(sppsm, bi.getRaster());
            }
            if (cm.hasAlpha()) {
                fmt.alphaOffset = NativeImageFormat.calculateAlphaOffset(sm, bi.getRaster());
            }
        }
        if (fmt.cmmFormat == 0) {
            return null;
        }
        if (!fmt.setImageData(bi.getRaster().getDataBuffer())) {
            return null;
        }
        fmt.rows = bi.getHeight();
        fmt.cols = bi.getWidth();
        fmt.dataOffset = bi.getRaster().getDataBuffer().getOffset();
        return fmt;
    }

    public static NativeImageFormat createNativeImageFormat(Raster r) {
        NativeImageFormat fmt = new NativeImageFormat();
        SampleModel sm = r.getSampleModel();
        if (sm instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sm;
            fmt.cmmFormat = NativeImageFormat.getFormatFromComponentModel(csm, false);
            fmt.scanlineStride = NativeImageFormat.calculateScanlineStrideCSM(csm, r);
        } else if (sm instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
            fmt.cmmFormat = NativeImageFormat.getFormatFromSPPSampleModel(sppsm, false);
            fmt.scanlineStride = NativeImageFormat.calculateScanlineStrideSPPSM(sppsm, r);
        }
        if (fmt.cmmFormat == 0) {
            return null;
        }
        fmt.cols = r.getWidth();
        fmt.rows = r.getHeight();
        fmt.dataOffset = r.getDataBuffer().getOffset();
        if (!fmt.setImageData(r.getDataBuffer())) {
            return null;
        }
        return fmt;
    }

    private static int getFormatFromComponentModel(ComponentSampleModel sm, boolean hasAlpha) {
        int i;
        int bankIndex = sm.getBankIndices()[0];
        for (int i2 = 1; i2 < sm.getNumBands(); ++i2) {
            if (sm.getBankIndices()[i2] == bankIndex) continue;
            return 0;
        }
        int channels = hasAlpha ? sm.getNumBands() - 1 : sm.getNumBands();
        int extra = hasAlpha ? 1 : 0;
        int bytes = 1;
        switch (sm.getDataType()) {
            case 0: {
                bytes = 1;
                break;
            }
            case 1: 
            case 2: {
                bytes = 2;
                break;
            }
            case 3: {
                bytes = 4;
                break;
            }
            case 5: {
                bytes = 0;
                break;
            }
            default: {
                return 0;
            }
        }
        int doSwap = 0;
        int swapFirst = 0;
        boolean knownFormat = false;
        for (i = 0; i < sm.getNumBands() && sm.getBandOffsets()[i] == i; ++i) {
        }
        if (i == sm.getNumBands()) {
            doSwap = 0;
            swapFirst = 0;
            knownFormat = true;
        }
        if (!knownFormat) {
            for (i = 0; i < sm.getNumBands() - 1 && sm.getBandOffsets()[i] == i + 1; ++i) {
            }
            if (sm.getBandOffsets()[i] == 0) {
                ++i;
            }
            if (i == sm.getNumBands()) {
                doSwap = 0;
                swapFirst = 1;
                knownFormat = true;
            }
        }
        if (!knownFormat) {
            for (i = 0; i < sm.getNumBands() - 1 && sm.getBandOffsets()[i] == sm.getNumBands() - 2 - i; ++i) {
            }
            if (sm.getBandOffsets()[i] == sm.getNumBands() - 1) {
                ++i;
            }
            if (i == sm.getNumBands()) {
                doSwap = 1;
                swapFirst = 1;
                knownFormat = true;
            }
        }
        if (!knownFormat) {
            for (i = 0; i < sm.getNumBands() && sm.getBandOffsets()[i] == sm.getNumBands() - 1 - i; ++i) {
            }
            if (i == sm.getNumBands()) {
                doSwap = 1;
                swapFirst = 0;
                knownFormat = true;
            }
        }
        if (!knownFormat) {
            return 0;
        }
        return NativeImageFormat.channelsSh(channels) | NativeImageFormat.bytesSh(bytes) | NativeImageFormat.extraSh(extra) | NativeImageFormat.doswapSh(doSwap) | NativeImageFormat.swapfirstSh(swapFirst);
    }

    private static int getFormatFromSPPSampleModel(SinglePixelPackedSampleModel sm, boolean hasAlpha) {
        int i;
        int mask = sm.getBitMasks()[0] >>> sm.getBitOffsets()[0];
        if (mask != 255 && mask != 65535 && mask != -1) {
            return 0;
        }
        for (int i2 = 1; i2 < sm.getNumBands(); ++i2) {
            if (sm.getBitMasks()[i2] >>> sm.getBitOffsets()[i2] == mask) continue;
            return 0;
        }
        int pixelSize = 0;
        if (sm.getDataType() == 1) {
            pixelSize = 2;
        } else if (sm.getDataType() == 3) {
            pixelSize = 4;
        } else {
            return 0;
        }
        int bytes = 0;
        switch (mask) {
            case 255: {
                bytes = 1;
                break;
            }
            case 65535: {
                bytes = 2;
                break;
            }
            case -1: {
                bytes = 4;
                break;
            }
            default: {
                return 0;
            }
        }
        int channels = hasAlpha ? sm.getNumBands() - 1 : sm.getNumBands();
        int extra = hasAlpha ? 1 : 0;
        extra += pixelSize / bytes - sm.getNumBands();
        ArrayList<Integer> offsetsLst = new ArrayList<Integer>();
        for (int k = 0; k < sm.getNumBands(); ++k) {
            offsetsLst.add(new Integer(sm.getBitOffsets()[k] / (bytes * 8)));
        }
        for (int i3 = 0; i3 < pixelSize / bytes; ++i3) {
            if (offsetsLst.indexOf(new Integer(i3)) >= 0) continue;
            offsetsLst.add(new Integer(i3));
        }
        int[] offsets = new int[pixelSize / bytes];
        for (int i4 = 0; i4 < offsetsLst.size(); ++i4) {
            offsets[i4] = (Integer)offsetsLst.get(i4);
        }
        int doSwap = 0;
        int swapFirst = 0;
        boolean knownFormat = false;
        for (i = 0; i < pixelSize && offsets[i] == i; ++i) {
        }
        if (i == pixelSize) {
            doSwap = 0;
            swapFirst = 0;
            knownFormat = true;
        }
        if (!knownFormat) {
            for (i = 0; i < pixelSize - 1 && offsets[i] == i + 1; ++i) {
            }
            if (offsets[i] == 0) {
                ++i;
            }
            if (i == pixelSize) {
                doSwap = 0;
                swapFirst = 1;
                knownFormat = true;
            }
        }
        if (!knownFormat) {
            for (i = 0; i < pixelSize - 1 && offsets[i] == pixelSize - 2 - i; ++i) {
            }
            if (offsets[i] == pixelSize - 1) {
                ++i;
            }
            if (i == pixelSize) {
                doSwap = 1;
                swapFirst = 1;
                knownFormat = true;
            }
        }
        if (!knownFormat) {
            for (i = 0; i < pixelSize && offsets[i] == pixelSize - 1 - i; ++i) {
            }
            if (i == pixelSize) {
                doSwap = 1;
                swapFirst = 0;
                knownFormat = true;
            }
        }
        if (!knownFormat) {
            return 0;
        }
        return NativeImageFormat.channelsSh(channels) | NativeImageFormat.bytesSh(bytes) | NativeImageFormat.extraSh(extra) | NativeImageFormat.doswapSh(doSwap) | NativeImageFormat.swapfirstSh(swapFirst);
    }

    private boolean setImageData(DataBuffer db) {
        AwtImageBackdoorAccessor dbAccess = AwtImageBackdoorAccessor.getInstance();
        try {
            this.imageData = dbAccess.getData(db);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    private static int calculateScanlineStrideCSM(ComponentSampleModel csm, Raster r) {
        if (csm.getScanlineStride() != csm.getPixelStride() * csm.getWidth()) {
            int dataTypeSize = DataBuffer.getDataTypeSize(r.getDataBuffer().getDataType()) / 8;
            return csm.getScanlineStride() * dataTypeSize;
        }
        return -1;
    }

    private static int calculateScanlineStrideSPPSM(SinglePixelPackedSampleModel sppsm, Raster r) {
        if (sppsm.getScanlineStride() != sppsm.getWidth()) {
            int dataTypeSize = DataBuffer.getDataTypeSize(r.getDataBuffer().getDataType()) / 8;
            return sppsm.getScanlineStride() * dataTypeSize;
        }
        return -1;
    }

    private static int calculateAlphaOffset(SampleModel sm, Raster r) {
        if (sm instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sm;
            int dataTypeSize = DataBuffer.getDataTypeSize(r.getDataBuffer().getDataType()) / 8;
            return csm.getBandOffsets()[csm.getBandOffsets().length - 1] * dataTypeSize;
        }
        if (sm instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sm;
            return sppsm.getBitOffsets()[sppsm.getBitOffsets().length - 1] / 8;
        }
        return -1;
    }

    static {
        INT_ARGB_LCMS_FMT = INT_RGB_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.extraSh(1) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1) | NativeImageFormat.doswapSh(1) | NativeImageFormat.swapfirstSh(1);
        INT_BGR_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.extraSh(1) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1);
        THREE_BYTE_BGR_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1) | NativeImageFormat.doswapSh(1);
        FOUR_BYTE_ABGR_LCMS_FMT = NativeImageFormat.colorspaceSh(4) | NativeImageFormat.extraSh(1) | NativeImageFormat.channelsSh(3) | NativeImageFormat.bytesSh(1) | NativeImageFormat.doswapSh(1);
        BYTE_GRAY_LCMS_FMT = NativeImageFormat.colorspaceSh(3) | NativeImageFormat.channelsSh(1) | NativeImageFormat.bytesSh(1);
        USHORT_GRAY_LCMS_FMT = NativeImageFormat.colorspaceSh(3) | NativeImageFormat.channelsSh(1) | NativeImageFormat.bytesSh(2);
        NativeCMM.loadCMM();
    }
}

