/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl.color;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class ColorScaler {
    private static final float MAX_SHORT = 65535.0f;
    private static final float MAX_SIGNED_SHORT = 32767.0f;
    private static final float MAX_XYZ = 1.9999695f;
    private float[] channelMinValues = null;
    private float[] channelMulipliers = null;
    private float[] invChannelMulipliers = null;
    int nColorChannels = 0;
    boolean isTTypeIntegral = false;

    public void loadScalingData(Raster r, ICC_Profile pf) {
        boolean isSrcTTypeIntegral;
        boolean bl = isSrcTTypeIntegral = r.getTransferType() != 4 && r.getTransferType() != 5;
        if (isSrcTTypeIntegral) {
            this.loadScalingData(r.getSampleModel());
        } else if (pf != null) {
            this.loadScalingData(pf);
        }
    }

    public void loadScalingData(SampleModel sm) {
        this.isTTypeIntegral = true;
        this.nColorChannels = sm.getNumBands();
        this.channelMinValues = new float[this.nColorChannels];
        this.channelMulipliers = new float[this.nColorChannels];
        this.invChannelMulipliers = new float[this.nColorChannels];
        boolean isSignedShort = sm.getTransferType() == 2;
        for (int i = 0; i < this.nColorChannels; ++i) {
            this.channelMinValues[i] = 0.0f;
            if (isSignedShort) {
                this.channelMulipliers[i] = 2.0000305f;
                this.invChannelMulipliers[i] = 0.49999237f;
                continue;
            }
            float maxVal = (1 << sm.getSampleSize(i)) - 1;
            this.channelMulipliers[i] = 65535.0f / maxVal;
            this.invChannelMulipliers[i] = maxVal / 65535.0f;
        }
    }

    public void loadScalingData(ICC_Profile pf) {
        int i;
        this.isTTypeIntegral = false;
        this.nColorChannels = pf.getNumComponents();
        float[] maxValues = new float[this.nColorChannels];
        float[] minValues = new float[this.nColorChannels];
        switch (pf.getColorSpaceType()) {
            case 0: {
                minValues[0] = 0.0f;
                minValues[1] = 0.0f;
                minValues[2] = 0.0f;
                maxValues[0] = 1.9999695f;
                maxValues[1] = 1.9999695f;
                maxValues[2] = 1.9999695f;
                break;
            }
            case 1: {
                minValues[0] = 0.0f;
                minValues[1] = -128.0f;
                minValues[2] = -128.0f;
                maxValues[0] = 100.0f;
                maxValues[1] = 127.0f;
                maxValues[2] = 127.0f;
                break;
            }
            default: {
                for (i = 0; i < this.nColorChannels; ++i) {
                    minValues[i] = 0.0f;
                    maxValues[i] = 1.0f;
                }
            }
        }
        this.channelMinValues = minValues;
        this.channelMulipliers = new float[this.nColorChannels];
        this.invChannelMulipliers = new float[this.nColorChannels];
        for (i = 0; i < this.nColorChannels; ++i) {
            this.channelMulipliers[i] = 65535.0f / (maxValues[i] - this.channelMinValues[i]);
            this.invChannelMulipliers[i] = (maxValues[i] - this.channelMinValues[i]) / 65535.0f;
        }
    }

    public void loadScalingData(ColorSpace cs) {
        this.nColorChannels = cs.getNumComponents();
        this.channelMinValues = new float[this.nColorChannels];
        this.channelMulipliers = new float[this.nColorChannels];
        this.invChannelMulipliers = new float[this.nColorChannels];
        for (int i = 0; i < this.nColorChannels; ++i) {
            this.channelMinValues[i] = cs.getMinValue(i);
            this.channelMulipliers[i] = 65535.0f / (cs.getMaxValue(i) - this.channelMinValues[i]);
            this.invChannelMulipliers[i] = (cs.getMaxValue(i) - this.channelMinValues[i]) / 65535.0f;
        }
    }

    public float[][] scaleNormalize(Raster r) {
        int width = r.getWidth();
        int height = r.getHeight();
        float[][] result = new float[width * height][this.nColorChannels];
        float[] normMultipliers = new float[this.nColorChannels];
        int pos = 0;
        if (this.isTTypeIntegral) {
            for (int i = 0; i < this.nColorChannels; ++i) {
                normMultipliers[i] = this.channelMulipliers[i] / 65535.0f;
            }
            for (int row = r.getMinX(); row < width; ++row) {
                for (int col = r.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        int sample = r.getSample(row, col, chan);
                        result[pos][chan] = (float)sample * normMultipliers[chan];
                    }
                    ++pos;
                }
            }
        } else {
            for (int row = r.getMinX(); row < width; ++row) {
                for (int col = r.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        result[pos][chan] = r.getSampleFloat(row, col, chan);
                    }
                    ++pos;
                }
            }
        }
        return result;
    }

    public void unscaleNormalized(WritableRaster r, float[][] data) {
        int width = r.getWidth();
        int height = r.getHeight();
        float[] normMultipliers = new float[this.nColorChannels];
        int pos = 0;
        if (this.isTTypeIntegral) {
            for (int i = 0; i < this.nColorChannels; ++i) {
                normMultipliers[i] = this.invChannelMulipliers[i] * 65535.0f;
            }
            for (int row = r.getMinX(); row < width; ++row) {
                for (int col = r.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        int sample = (int)(data[pos][chan] * normMultipliers[chan] + 0.5f);
                        r.setSample(row, col, chan, sample);
                    }
                    ++pos;
                }
            }
        } else {
            for (int row = r.getMinX(); row < width; ++row) {
                for (int col = r.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        r.setSample(row, col, chan, data[pos][chan]);
                    }
                    ++pos;
                }
            }
        }
    }

    public short[] scale(Raster r) {
        int width = r.getWidth();
        int height = r.getHeight();
        short[] result = new short[width * height * this.nColorChannels];
        int pos = 0;
        if (this.isTTypeIntegral) {
            for (int row = r.getMinX(); row < width; ++row) {
                for (int col = r.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        int sample = r.getSample(row, col, chan);
                        result[pos++] = (short)((float)sample * this.channelMulipliers[chan] + 0.5f);
                    }
                }
            }
        } else {
            for (int row = r.getMinX(); row < width; ++row) {
                for (int col = r.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        float sample = r.getSampleFloat(row, col, chan);
                        result[pos++] = (short)((sample - this.channelMinValues[chan]) * this.channelMulipliers[chan] + 0.5f);
                    }
                }
            }
        }
        return result;
    }

    public void unscale(short[] data, WritableRaster wr) {
        int width = wr.getWidth();
        int height = wr.getHeight();
        int pos = 0;
        if (this.isTTypeIntegral) {
            for (int row = wr.getMinX(); row < width; ++row) {
                for (int col = wr.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        int sample = (int)((float)(data[pos++] & 0xFFFF) * this.invChannelMulipliers[chan] + 0.5f);
                        wr.setSample(row, col, chan, sample);
                    }
                }
            }
        } else {
            for (int row = wr.getMinX(); row < width; ++row) {
                for (int col = wr.getMinY(); col < height; ++col) {
                    for (int chan = 0; chan < this.nColorChannels; ++chan) {
                        float sample = (float)(data[pos++] & 0xFFFF) * this.invChannelMulipliers[chan] + this.channelMinValues[chan];
                        wr.setSample(row, col, chan, sample);
                    }
                }
            }
        }
    }

    public void scale(float[] pixelData, short[] chanData, int chanDataOffset) {
        for (int chan = 0; chan < this.nColorChannels; ++chan) {
            chanData[chanDataOffset + chan] = (short)((pixelData[chan] - this.channelMinValues[chan]) * this.channelMulipliers[chan] + 0.5f);
        }
    }

    public void unscale(float[] pixelData, short[] chanData, int chanDataOffset) {
        for (int chan = 0; chan < this.nColorChannels; ++chan) {
            pixelData[chan] = (float)(chanData[chanDataOffset + chan] & 0xFFFF) * this.invChannelMulipliers[chan] + this.channelMinValues[chan];
        }
    }
}

