/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import org.apache.harmony.awt.gl.LUTTables;

public class SURFACE_STRUCTURE {
    private int ss_type;
    private int width;
    private int height;
    private int cm_type;
    private int cs_type;
    private int data_type;
    private int num_components;
    private int pixel_stride;
    private int scanline_stride;
    private int offset;
    private boolean has_alpha;
    private boolean isAlphaPre;
    private int transparency;
    private int scanline_stride_byte;
    private int red_mask;
    private int green_mask;
    private int blue_mask;
    private int alpha_mask;
    private int red_sht;
    private int max_red;
    private int green_sht;
    private int max_green;
    private int blue_sht;
    private int max_blue;
    private int alpha_sht;
    private int max_alpha;
    private int colormap_size;
    private int transparent_pixel;
    private boolean isGrayPallete;
    private int[] colormap;
    private int[] bits;
    private int[] bank_indexes;
    private int[] band_offsets;
    private boolean invalidated;
    private int bmp_byte_stride;
    private Object bmpData;
    private boolean hasRealAlpha;

    public SURFACE_STRUCTURE(int surfType, int width, int height, int cmType, int csType, int smType, int dataType, int numComponents, int pixelStride, int scanlineStride, int[] bits, int[] masks, int colorMapSize, int[] colorMap, int transpPixel, boolean isGrayPalette, int[] bankIndeces, int[] bandOffsets, int offset, boolean hasAlpha, boolean isAlphaPre, int transparency) {
        this.ss_type = surfType;
        this.width = width;
        this.height = height;
        this.cm_type = cmType;
        this.cs_type = csType;
        this.data_type = dataType;
        this.num_components = numComponents;
        this.pixel_stride = pixelStride;
        this.scanline_stride = scanlineStride;
        this.offset = offset;
        this.has_alpha = hasAlpha;
        this.isAlphaPre = isAlphaPre;
        this.transparency = transparency;
        if (dataType == 0) {
            this.scanline_stride_byte = scanlineStride;
        } else if (dataType == 1) {
            this.scanline_stride_byte = scanlineStride << 1;
        } else if (dataType == 3) {
            this.scanline_stride_byte = scanlineStride << 2;
        }
        switch (cmType) {
            case 1: {
                int i;
                this.bits = new int[this.num_components];
                for (i = 0; i < numComponents; ++i) {
                    this.bits[i] = bits[i];
                }
                this.red_mask = masks[i++];
                this.green_mask = masks[i++];
                this.blue_mask = masks[i++];
                if (hasAlpha) {
                    this.alpha_mask = masks[i];
                }
                this.red_sht = this.getShift(this.red_mask);
                this.max_red = (1 << bits[0]) - 1;
                this.green_sht = this.getShift(this.green_mask);
                this.max_green = (1 << bits[1]) - 1;
                this.blue_sht = this.getShift(this.blue_mask);
                this.max_blue = (1 << bits[2]) - 1;
                if (!hasAlpha) break;
                this.alpha_sht = this.getShift(this.alpha_mask);
                this.max_alpha = (1 << bits[3]) - 1;
                break;
            }
            case 2: {
                this.colormap_size = colorMapSize;
                this.transparent_pixel = transpPixel;
                this.isGrayPallete = isGrayPalette;
                this.colormap = new int[colorMapSize];
                for (int i = 0; i < colorMapSize; ++i) {
                    this.colormap[i] = colorMap[i];
                }
                break;
            }
            case 3: {
                int i;
                this.bank_indexes = new int[numComponents];
                for (i = 0; i < numComponents; ++i) {
                    this.bank_indexes[i] = bankIndeces[i];
                }
                this.band_offsets = new int[numComponents];
                for (i = 0; i < numComponents; ++i) {
                    this.band_offsets[i] = bandOffsets[i];
                }
                break;
            }
        }
        this.invalidated = true;
        this.bmp_byte_stride = width << 2;
        this.createBuffer();
        this.bmpData = new byte[this.bmp_byte_stride * height];
    }

    int getShift(int mask) {
        int shift = 0;
        if (mask != 0) {
            while ((mask & 1) == 0) {
                mask >>= 1;
                ++shift;
            }
        }
        return shift;
    }

    public void setImageSize(int width, int height) {
        this.scanline_stride = this.scanline_stride / width * width;
        this.scanline_stride_byte = this.scanline_stride_byte / width * width;
        this.width = width;
        this.height = height;
    }

    public void dispose() {
        this.bits = null;
        this.colormap = null;
        this.bank_indexes = null;
        this.band_offsets = null;
        this.bmpData = null;
    }

    public Object updateCache(Object data, boolean alphaPre) {
        this.updateCache(data, alphaPre, 0, 0, this.width, this.height);
        return this.bmpData;
    }

    void updateCache(Object srcData, boolean alphaPre, int x, int y, int width, int height) {
        int h = height;
        int w = width;
        switch (this.ss_type) {
            case 1: {
                int src_stride = this.scanline_stride;
                int dst_stride = width;
                int sidx = y * src_stride + x;
                int didx = y * dst_stride + x;
                int[] src = (int[])srcData;
                int[] dst = (int[])this.bmpData;
                int _y = 0;
                while (_y < h) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = 0; _x < w; ++_x) {
                        dst[d++] = 0xFF000000 | src[s++];
                    }
                    ++_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                break;
            }
            case 2: {
                if (alphaPre) {
                    int src_stride = this.scanline_stride_byte;
                    int dst_stride = width << 2;
                    int sidx = y * src_stride + (x + w << 2) - 1;
                    int didx = y * dst_stride + (x + w << 2) - 1;
                    byte[] src = (byte[])srcData;
                    byte[] dst = (byte[])this.bmpData;
                    int _y = h;
                    while (_y > 0) {
                        int s = sidx;
                        int d = didx;
                        for (int _x = w; _x > 0; --_x) {
                            byte sa = src[s--];
                            dst[d--] = sa;
                            if (sa != 255) {
                                dst[d--] = LUTTables.MUL(sa, src[s--]);
                                dst[d--] = LUTTables.MUL(sa, src[s--]);
                                dst[d--] = LUTTables.MUL(sa, src[s--]);
                                this.hasRealAlpha = true;
                                continue;
                            }
                            dst[d--] = src[s--];
                            dst[d--] = src[s--];
                            dst[d--] = src[s--];
                        }
                        --_y;
                        sidx += src_stride;
                        didx += dst_stride;
                    }
                    this.isAlphaPre = true;
                    break;
                }
                int src_stride = this.scanline_stride;
                int dst_stride = width;
                int sidx = y * src_stride + x;
                int didx = y * dst_stride + x;
                int[] src = (int[])srcData;
                int[] dst = (int[])this.bmpData;
                int _y = 0;
                while (_y < h) {
                    int d = didx;
                    int s = sidx;
                    for (int _x = 0; _x < w; ++_x) {
                        dst[d++] = src[s++];
                    }
                    ++_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                this.isAlphaPre = false;
                break;
            }
            case 3: {
                int src_stride = this.scanline_stride_byte;
                int dst_stride = width << 2;
                int sidx = y * src_stride + (x + w << 2) - 1;
                int didx = y * dst_stride + (x + w << 2) - 1;
                byte[] src = (byte[])srcData;
                byte[] dst = (byte[])this.bmpData;
                if (alphaPre) {
                    int _y = h;
                    while (_y > 0) {
                        int s = sidx;
                        int d = didx;
                        for (int _x = w; _x > 0; --_x) {
                            byte sa = src[s--];
                            dst[d--] = sa;
                            dst[d--] = src[s--];
                            dst[d--] = src[s--];
                            dst[d--] = src[s--];
                            if (sa == 255) continue;
                            this.hasRealAlpha = true;
                        }
                        --_y;
                        sidx += src_stride;
                        didx += dst_stride;
                    }
                    this.isAlphaPre = true;
                    break;
                }
                int _y = h;
                while (_y > 0) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = w; _x > 0; --_x) {
                        byte sa = src[s--];
                        dst[d--] = sa;
                        dst[d--] = LUTTables.DIV(sa, src[s--]);
                        dst[d--] = LUTTables.DIV(sa, src[s--]);
                        dst[d--] = LUTTables.DIV(sa, src[s--]);
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                this.isAlphaPre = false;
                break;
            }
            case 4: {
                int src_stride = this.scanline_stride_byte;
                int dst_stride = width << 2;
                int sidx = y * src_stride + (x + w << 2) - 1;
                int didx = y * dst_stride + (x + w << 2) - 1;
                byte[] src = (byte[])srcData;
                byte[] dst = (byte[])this.bmpData;
                int _y = h;
                while (_y > 0) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = w; _x > 0; --_x) {
                        dst[d] = -1;
                        int n = --s;
                        dst[d - 3] = src[n];
                        int n2 = --s;
                        dst[d - 2] = src[n2];
                        int n3 = --s;
                        --s;
                        dst[d - 1] = src[n3];
                        d -= 4;
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                break;
            }
            case 5: {
                int src_stride = this.scanline_stride_byte;
                int dst_stride = width << 2;
                int sidx = y * src_stride + (x + w) * 3 - 1;
                int didx = y * dst_stride + (x + w << 2) - 1;
                byte[] src = (byte[])srcData;
                byte[] dst = (byte[])this.bmpData;
                int _y = h;
                while (_y > 0) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = w; _x > 0; --_x) {
                        dst[d--] = -1;
                        dst[d--] = src[s--];
                        dst[d--] = src[s--];
                        dst[d--] = src[s--];
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                break;
            }
            case 6: {
                int src_stride = this.scanline_stride_byte;
                int dst_stride = width << 2;
                int sidx = y * src_stride + (x + w << 2) - 1;
                int didx = y * dst_stride + (x + w << 2) - 1;
                byte[] src = (byte[])srcData;
                byte[] dst = (byte[])this.bmpData;
                if (alphaPre) {
                    int _y = h;
                    while (_y > 0) {
                        int s = sidx;
                        int d = didx;
                        for (int _x = w; _x > 0; --_x) {
                            byte r = src[s--];
                            byte g = src[s--];
                            byte b = src[s--];
                            byte a = src[s--];
                            dst[d--] = a;
                            if (a != 255) {
                                dst[d--] = LUTTables.MUL(a, r);
                                dst[d--] = LUTTables.MUL(a, g);
                                dst[d--] = LUTTables.MUL(a, b);
                                this.hasRealAlpha = true;
                                continue;
                            }
                            dst[d--] = r;
                            dst[d--] = g;
                            dst[d--] = b;
                        }
                        --_y;
                        sidx += src_stride;
                        didx += dst_stride;
                    }
                    this.isAlphaPre = true;
                    break;
                }
                int _y = h;
                while (_y > 0) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = w; _x > 0; --_x) {
                        byte r = src[s--];
                        byte g = src[s--];
                        byte b = src[s--];
                        byte a = src[s--];
                        dst[d--] = a;
                        dst[d--] = r;
                        dst[d--] = g;
                        dst[d--] = b;
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                this.isAlphaPre = false;
                break;
            }
            case 7: {
                int src_stride = this.scanline_stride_byte;
                int dst_stride = width << 2;
                int sidx = y * src_stride + (x + w << 2) - 1;
                int didx = y * dst_stride + (x + w << 2) - 1;
                byte[] src = (byte[])srcData;
                byte[] dst = (byte[])this.bmpData;
                if (alphaPre) {
                    int _y = h;
                    while (_y > 0) {
                        int s = sidx;
                        int d = didx;
                        for (int _x = w; _x > 0; --_x) {
                            byte a;
                            byte r = src[s--];
                            byte g = src[s--];
                            byte b = src[s--];
                            if ((a = src[s--]) != 255) {
                                this.hasRealAlpha = true;
                            }
                            dst[d--] = a;
                            dst[d--] = r;
                            dst[d--] = g;
                            dst[d--] = b;
                        }
                        --_y;
                        sidx += src_stride;
                        didx += dst_stride;
                    }
                    this.isAlphaPre = true;
                    break;
                }
                int _y = h;
                while (_y > 0) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = w; _x > 0; --_x) {
                        byte r = src[s--];
                        byte g = src[s--];
                        byte b = src[s--];
                        byte a = src[s--];
                        dst[d--] = a;
                        if (a != 255) {
                            dst[d--] = LUTTables.DIV(a, r);
                            dst[d--] = LUTTables.DIV(a, g);
                            dst[d--] = LUTTables.DIV(a, b);
                            continue;
                        }
                        dst[d--] = r;
                        dst[d--] = g;
                        dst[d--] = b;
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                this.isAlphaPre = false;
                break;
            }
            case 8: 
            case 9: {
                int mr = this.max_red;
                int mg = this.max_green;
                int mb = this.max_red;
                int rm = this.red_mask;
                int gm = this.green_mask;
                int bm = this.blue_mask;
                int rs = this.red_sht;
                int gs = this.green_sht;
                int bs = this.blue_sht;
                int src_stride = this.scanline_stride;
                int dst_stride = width << 2;
                int sidx = y * src_stride + x + w - 1;
                int didx = y * dst_stride + (x + w << 2) - 1;
                short[] src = (short[])srcData;
                byte[] dst = (byte[])this.bmpData;
                int _y = h;
                while (_y > 0) {
                    int d = didx;
                    int s = sidx;
                    for (int _x = w; _x > 0; --_x) {
                        short pixel = src[s--];
                        dst[d--] = -1;
                        dst[d--] = LUTTables.DIV(mb, (pixel & rm) >> rs);
                        dst[d--] = LUTTables.DIV(mg, (pixel & gm) >> gs);
                        dst[d--] = LUTTables.DIV(mr, (pixel & bm) >> bs);
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                break;
            }
            case 11: {
                int src_stride = this.scanline_stride;
                int dst_stride = width << 2;
                int sidx = y * src_stride + (x << 1);
                int didx = y * dst_stride + (x << 2);
                short[] src = (short[])srcData;
                byte[] dst = (byte[])this.bmpData;
                int _y = h;
                while (_y > 0) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = w; _x > 0; --_x) {
                        byte pixel = (byte)(src[s++] / 257);
                        dst[d++] = pixel;
                        dst[d++] = pixel;
                        dst[d++] = pixel;
                        dst[d++] = -1;
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                break;
            }
            case 12: {
                int pixelBits = this.pixel_stride;
                int[] cm = this.colormap;
                int src_stride = this.scanline_stride;
                int dst_stride = width;
                int sidx = y * src_stride;
                int didx = y * dst_stride + x;
                byte[] src = (byte[])srcData;
                int[] dst = (int[])this.bmpData;
                int _y = h;
                while (_y > 0) {
                    int d = didx;
                    for (int _x = 0; _x < w; ++_x) {
                        int bitnum = _x * pixelBits;
                        int s = bitnum / 8;
                        byte elem = src[s];
                        int shift = 8 - (bitnum & 7) - pixelBits;
                        int bitMask = (1 << pixelBits) - 1;
                        int pixel = elem >> shift & bitMask;
                        dst[d++] = 0xFF000000 | cm[pixel];
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                break;
            }
            case 13: {
                int transparency = this.transparency;
                int[] cm = this.colormap;
                int tp = this.transparent_pixel;
                int src_stride = this.scanline_stride;
                int dst_stride = width;
                int sidx = y * src_stride + x + w - 1;
                int didx = y * dst_stride + x + w - 1;
                byte[] src = (byte[])srcData;
                int[] dst = (int[])this.bmpData;
                if (transparency == 1) {
                    int _y = h;
                    while (_y > 0) {
                        int s = sidx;
                        int d = didx;
                        for (int _x = w; _x > 0; --_x) {
                            dst[d--] = 0xFF000000 | cm[src[s--]];
                        }
                        --_y;
                        sidx += src_stride;
                        didx += dst_stride;
                    }
                } else if (transparency == 2) {
                    int _y = h;
                    while (_y > 0) {
                        int s = sidx;
                        int d = didx;
                        for (int _x = w; _x > 0; --_x) {
                            byte pixel;
                            if ((pixel = src[s--]) != tp) {
                                dst[d--] = 0xFF000000 | cm[pixel];
                                continue;
                            }
                            this.hasRealAlpha = true;
                            dst[d--] = 0;
                        }
                        --_y;
                        sidx += src_stride;
                        didx += dst_stride;
                    }
                } else {
                    int _y = h;
                    while (_y > 0) {
                        int s = sidx;
                        int d = didx;
                        for (int _x = w; _x > 0; --_x) {
                            int pixel = cm[src[s--]];
                            int a = pixel >> 24 & 0xFF;
                            if (alphaPre) {
                                if (a == 255) {
                                    dst[d--] = pixel;
                                } else {
                                    int r = pixel >> 16 & 0xFF;
                                    int g = pixel >> 8 & 0xFF;
                                    int b = pixel & 0xFF;
                                    r = LUTTables.MUL(a, r);
                                    g = LUTTables.MUL(a, g);
                                    b = LUTTables.MUL(a, b);
                                    dst[d--] = a << 24 | r << 16 | g << 8 | b;
                                }
                                this.isAlphaPre = true;
                                continue;
                            }
                            dst[d--] = a == 0 ? 0 : pixel;
                            this.isAlphaPre = false;
                        }
                        --_y;
                        sidx += src_stride;
                        didx += dst_stride;
                    }
                }
                break;
            }
            case 10: {
                int src_stride = this.scanline_stride;
                int dst_stride = width << 2;
                int sidx = y * src_stride + x;
                int didx = y * dst_stride + (x << 2);
                byte[] src = (byte[])srcData;
                byte[] dst = (byte[])this.bmpData;
                int _y = h;
                while (_y > 0) {
                    int s = sidx;
                    int d = didx;
                    for (int _x = w; _x > 0; --_x) {
                        byte pixel = src[s++];
                        dst[d++] = pixel;
                        dst[d++] = pixel;
                        dst[d++] = pixel;
                        dst[d++] = -1;
                    }
                    --_y;
                    sidx += src_stride;
                    didx += dst_stride;
                }
                break;
            }
        }
    }

    void createBuffer() {
        switch (this.ss_type) {
            case 1: {
                this.bmpData = new int[1];
                break;
            }
            case 2: {
                if (this.isAlphaPre) {
                    this.bmpData = new byte[1];
                    break;
                }
                this.bmpData = new int[1];
                break;
            }
            case 3: {
                this.bmpData = new byte[1];
                break;
            }
            case 4: {
                this.bmpData = new byte[1];
                break;
            }
            case 5: {
                this.bmpData = new byte[1];
                break;
            }
            case 6: {
                this.bmpData = new byte[1];
                break;
            }
            case 7: {
                this.bmpData = new byte[1];
                break;
            }
            case 8: 
            case 9: {
                this.bmpData = new byte[1];
                break;
            }
            case 11: {
                this.bmpData = new byte[1];
                break;
            }
            case 12: {
                this.bmpData = new int[1];
                break;
            }
            case 13: {
                this.bmpData = new int[1];
                break;
            }
            case 10: {
                this.bmpData = new byte[1];
            }
        }
    }
}

