/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import java.awt.Rectangle;
import org.apache.harmony.awt.gl.MultiRectArea;

public class MultiRectAreaOp {
    public static final int RECT_CAPACITY = 16;
    private static final int MAX_SIMPLE = 8;

    public static int[] createBuf(int capacity) {
        if (capacity == 0) {
            capacity = 16;
        }
        int[] buf = new int[capacity];
        buf[0] = 1;
        return buf;
    }

    public static int[] checkBufSize(int[] buf, int capacity) {
        if (buf[0] + capacity >= buf.length) {
            int length = buf[0] + (capacity > 16 ? capacity : 16);
            int[] tmp = new int[length];
            System.arraycopy(buf, 0, tmp, 0, buf[0]);
            buf = tmp;
        }
        buf[0] = buf[0] + capacity;
        return buf;
    }

    static class Subtraction {
        Subtraction() {
        }

        static void subtractRegions(int[] reg1, int[] reg2, MultiRectArea.RectCash dst, int height1, int height2) {
            Region d1 = new Region(reg1);
            Region d2 = new Region(reg2);
            int[] level = new int[height1 + height2];
            int[] level1 = new int[height1];
            int[] level2 = new int[height2];
            d1.createLevel(level1);
            d2.createLevel(level2);
            Region.sortOrdered(level1, level2, level);
            int bottom = level[1] - 1;
            for (int i = 2; i < level[0]; ++i) {
                int top = bottom + 1;
                bottom = level[i] - 1;
                d1.findActive(top, bottom);
                if (d1.active[0] == 1) {
                    d2.deleteActive(bottom);
                    continue;
                }
                d2.findActive(top, bottom);
                int i1 = 1;
                int i2 = 1;
                int rx1 = 0;
                int rx2 = 0;
                boolean next = true;
                while (true) {
                    if (next) {
                        next = false;
                        if (i1 >= d1.active[0]) break;
                        d1.active[i1 + 1] = bottom + 1;
                        rx1 = d1.active[i1];
                        rx2 = d1.active[i1 + 2];
                        i1 += 4;
                    }
                    if (i2 >= d2.active[0]) {
                        dst.addRectCashed(rx1, top, rx2, bottom);
                        for (int j = i1; j < d1.active[0]; j += 4) {
                            dst.addRectCashed(d1.active[j], top, d1.active[j + 2], bottom);
                            d1.active[j + 1] = bottom + 1;
                        }
                        break;
                    }
                    int x1 = d2.active[i2];
                    int x2 = d2.active[i2 + 2];
                    if (rx1 < x1) {
                        if (rx2 >= x1) {
                            if (rx2 <= x2) {
                                dst.addRectCashed(rx1, top, x1 - 1, bottom);
                                next = true;
                                continue;
                            }
                            dst.addRectCashed(rx1, top, x1 - 1, bottom);
                            rx1 = x2 + 1;
                            i2 += 4;
                            continue;
                        }
                        dst.addRectCashed(rx1, top, rx2, bottom);
                        next = true;
                        continue;
                    }
                    if (rx1 <= x2) {
                        if (rx2 <= x2) {
                            next = true;
                            continue;
                        }
                        rx1 = x2 + 1;
                        i2 += 4;
                        continue;
                    }
                    i2 += 4;
                }
                d1.deleteActive();
                d2.deleteActive(bottom);
            }
        }

        static void subtractRect(int x11, int y11, int x12, int y12, int[] rect, int index, MultiRectArea dst) {
            for (int i = index; i < rect[0]; i += 4) {
                int bottom;
                int top;
                int x21 = rect[i + 0];
                int y21 = rect[i + 1];
                int x22 = rect[i + 2];
                int y22 = rect[i + 3];
                if (x11 > x22 || x12 < x21 || y11 > y22 || y12 < y21) continue;
                if (y11 < y21) {
                    Subtraction.subtractRect(x11, y11, x12, y21 - 1, rect, i + 4, dst);
                    top = y21;
                } else {
                    top = y11;
                }
                if (y12 > y22) {
                    Subtraction.subtractRect(x11, y22 + 1, x12, y12, rect, i + 4, dst);
                    bottom = y22;
                } else {
                    bottom = y12;
                }
                if (x11 < x21) {
                    Subtraction.subtractRect(x11, top, x21 - 1, bottom, rect, i + 4, dst);
                }
                if (x12 > x22) {
                    Subtraction.subtractRect(x22 + 1, top, x12, bottom, rect, i + 4, dst);
                }
                return;
            }
            dst.addRect(x11, y11, x12, y12);
        }

        static void simpleSubtract(MultiRectArea src1, MultiRectArea src2, MultiRectArea dst) {
            for (int i = 1; i < src1.rect[0]; i += 4) {
                Subtraction.subtractRect(src1.rect[i + 0], src1.rect[i + 1], src1.rect[i + 2], src1.rect[i + 3], src2.rect, 1, dst);
            }
            dst.resort();
        }

        public static MultiRectArea getResult(MultiRectArea src1, MultiRectArea src2) {
            if (src1 == null || src1.isEmpty()) {
                return new MultiRectArea();
            }
            if (src2 == null || src2.isEmpty()) {
                return new MultiRectArea(src1);
            }
            MultiRectArea.RectCash dst = new MultiRectArea.RectCash();
            if (!src1.sorted || !src2.sorted || src1.getRectCount() <= 8 || src2.getRectCount() <= 8) {
                Subtraction.simpleSubtract(src1, src2, dst);
            } else {
                Rectangle bounds1 = src1.getBounds();
                Rectangle bounds2 = src2.getBounds();
                Rectangle bounds3 = bounds1.intersection(bounds2);
                if (bounds3.width > 0 && bounds3.height > 0) {
                    Subtraction.subtractRegions(src1.rect, src2.rect, dst, bounds1.height + 2, bounds2.height + 2);
                } else {
                    dst.setRect(src1.rect, true);
                }
            }
            return dst;
        }
    }

    static class Union {
        int rx1;
        int rx2;
        int top;
        int bottom;
        MultiRectArea.RectCash dst;

        Union() {
        }

        boolean next(Region d, int index) {
            int x1 = d.active[index];
            int x2 = d.active[index + 2];
            boolean res = false;
            if (x2 < this.rx1 - 1) {
                res = true;
                this.dst.addRectCashed(x1, this.top, x2, this.bottom);
            } else if (x1 > this.rx2 + 1) {
                res = false;
                this.dst.addRectCashed(this.rx1, this.top, this.rx2, this.bottom);
                this.rx1 = x1;
                this.rx2 = x2;
            } else {
                res = x2 <= this.rx2;
                this.rx1 = Math.min(x1, this.rx1);
                this.rx2 = Math.max(x2, this.rx2);
            }
            if (d.active[index + 1] < this.top) {
                this.dst.addRectCashed(x1, d.active[index + 1], x2, this.top - 1);
            }
            if (d.active[index + 3] > this.bottom) {
                d.active[index + 1] = this.bottom + 1;
            }
            return res;
        }

        void check(Region d, int index, boolean t) {
            int x1 = d.active[index];
            int x2 = d.active[index + 2];
            if (d.active[index + 1] < this.top) {
                this.dst.addRectCashed(x1, d.active[index + 1], x2, this.top - 1);
            }
            if (t) {
                this.dst.addRectCashed(x1, this.top, x2, this.bottom);
            }
            if (d.active[index + 3] > this.bottom) {
                d.active[index + 1] = this.bottom + 1;
            }
        }

        void unionRegions(int[] reg1, int[] reg2, int height1, int height2) {
            Region d1 = new Region(reg1);
            Region d2 = new Region(reg2);
            int[] level = new int[height1 + height2];
            int[] level1 = new int[height1];
            int[] level2 = new int[height2];
            d1.createLevel(level1);
            d2.createLevel(level2);
            Region.sortOrdered(level1, level2, level);
            this.bottom = level[1] - 1;
            for (int i = 2; i < level[0]; ++i) {
                boolean res2;
                boolean res1;
                this.top = this.bottom + 1;
                this.bottom = level[i] - 1;
                d1.findActive(this.top, this.bottom);
                d2.findActive(this.top, this.bottom);
                int i1 = 1;
                int i2 = 1;
                if (d1.active[0] > 1) {
                    this.check(d1, 1, false);
                    this.rx1 = d1.active[1];
                    this.rx2 = d1.active[3];
                    i1 += 4;
                    res1 = false;
                    res2 = true;
                } else {
                    if (d2.active[0] <= 1) continue;
                    this.check(d2, 1, false);
                    this.rx1 = d2.active[1];
                    this.rx2 = d2.active[3];
                    i2 += 4;
                    res1 = true;
                    res2 = false;
                }
                block1: while (true) {
                    if (res1) {
                        if (i1 >= d1.active[0]) {
                            this.dst.addRectCashed(this.rx1, this.top, this.rx2, this.bottom);
                            while (i2 < d2.active[0]) {
                                this.check(d2, i2, true);
                                i2 += 4;
                            }
                            break;
                        }
                        res1 = this.next(d1, i1);
                        i1 += 4;
                        continue;
                    }
                    while (res2) {
                        if (i2 >= d2.active[0]) {
                            this.dst.addRectCashed(this.rx1, this.top, this.rx2, this.bottom);
                            while (i1 < d1.active[0]) {
                                this.check(d1, i1, true);
                                i1 += 4;
                            }
                            break block1;
                        }
                        res2 = this.next(d2, i2);
                        i2 += 4;
                    }
                    res1 = true;
                    res2 = true;
                }
                d1.deleteActive(this.bottom);
                d2.deleteActive(this.bottom);
            }
        }

        static void simpleUnion(MultiRectArea src1, MultiRectArea src2, MultiRectArea dst) {
            if (src1.getRectCount() < src2.getRectCount()) {
                Union.simpleUnion(src2, src1, dst);
            } else {
                Subtraction.simpleSubtract(src1, src2, dst);
                int pos = dst.rect[0];
                int size = src2.rect[0] - 1;
                dst.rect = MultiRectAreaOp.checkBufSize(dst.rect, size);
                System.arraycopy(src2.rect, 1, dst.rect, pos, size);
                dst.resort();
            }
        }

        MultiRectArea getResult(MultiRectArea src1, MultiRectArea src2) {
            if (src1 == null || src1.isEmpty()) {
                return new MultiRectArea(src2);
            }
            if (src2 == null || src2.isEmpty()) {
                return new MultiRectArea(src1);
            }
            this.dst = new MultiRectArea.RectCash();
            if (!src1.sorted || !src2.sorted || src1.getRectCount() <= 8 || src2.getRectCount() <= 8) {
                Union.simpleUnion(src1, src2, this.dst);
            } else {
                Rectangle bounds1 = src1.getBounds();
                Rectangle bounds2 = src2.getBounds();
                Rectangle bounds3 = bounds1.intersection(bounds2);
                if (bounds3.width < 0 || bounds3.height < 0) {
                    if (bounds1.y + bounds1.height < bounds2.y) {
                        this.dst.setRect(this.addVerRegion(src1.rect, src2.rect), false);
                    } else if (bounds2.y + bounds2.height < bounds1.y) {
                        this.dst.setRect(this.addVerRegion(src2.rect, src1.rect), false);
                    } else if (bounds1.x < bounds2.x) {
                        this.dst.setRect(this.addHorRegion(src1.rect, src2.rect), false);
                    } else {
                        this.dst.setRect(this.addHorRegion(src2.rect, src1.rect), false);
                    }
                } else {
                    this.unionRegions(src1.rect, src2.rect, bounds1.height + 2, bounds2.height + 2);
                }
            }
            return this.dst;
        }

        int[] addVerRegion(int[] top, int[] bottom) {
            int length = top[0] + bottom[0] - 1;
            int[] dst = new int[length];
            dst[0] = length;
            System.arraycopy(top, 1, dst, 1, top[0] - 1);
            System.arraycopy(bottom, 1, dst, top[0], bottom[0] - 1);
            return dst;
        }

        int[] addHorRegion(int[] left, int[] right) {
            int count1 = left[0];
            int count2 = right[0];
            int[] dst = new int[count1 + count2 + 1];
            int count = 1;
            int index1 = 1;
            int index2 = 1;
            int top1 = left[2];
            int top2 = right[2];
            while (true) {
                int pos2;
                int pos1;
                if (index1 >= count1) {
                    System.arraycopy(right, index2, dst, count, count2 - index2);
                    count += count2 - index2;
                    break;
                }
                if (index2 >= count2) {
                    System.arraycopy(left, index1, dst, count, count1 - index1);
                    count += count1 - index1;
                    break;
                }
                if (top1 < top2) {
                    pos1 = index1;
                    while ((index1 += 4) < count1 && (top1 = left[index1 + 1]) < top2) {
                    }
                    System.arraycopy(left, pos1, dst, count, index1 - pos1);
                    count += index1 - pos1;
                    continue;
                }
                if (top1 > top2) {
                    pos2 = index2;
                    while ((index2 += 4) < count2 && (top2 = right[index2 + 1]) < top1) {
                    }
                    System.arraycopy(right, pos2, dst, count, index2 - pos2);
                    count += index2 - pos2;
                    continue;
                }
                int top = top1;
                pos1 = index1;
                pos2 = index2;
                while ((index1 += 4) < count1 && (top1 = left[index1 + 1]) == top) {
                }
                while ((index2 += 4) < count2 && (top2 = right[index2 + 1]) == top) {
                }
                System.arraycopy(left, pos1, dst, count, index1 - pos1);
                System.arraycopy(right, pos2, dst, count += index1 - pos1, index2 - pos2);
                count += index2 - pos2;
            }
            dst[0] = count;
            return dst;
        }
    }

    static class Intersection {
        Intersection() {
        }

        static void intersectRegions(int[] reg1, int[] reg2, MultiRectArea.RectCash dst, int height1, int height2) {
            Region d1 = new Region(reg1);
            Region d2 = new Region(reg2);
            int[] level = new int[height1 + height2];
            int[] level1 = new int[height1];
            int[] level2 = new int[height2];
            d1.createLevel(level1);
            d2.createLevel(level2);
            Region.sortOrdered(level1, level2, level);
            int bottom = level[1] - 1;
            for (int i = 2; i < level[0]; ++i) {
                int top = bottom + 1;
                bottom = level[i] - 1;
                d1.findActive(top, bottom);
                d2.findActive(top, bottom);
                int i1 = 1;
                int i2 = 1;
                while (i1 < d1.active[0] && i2 < d2.active[0]) {
                    int x11 = d1.active[i1];
                    int x12 = d1.active[i1 + 2];
                    int x21 = d2.active[i2];
                    int x22 = d2.active[i2 + 2];
                    if (x11 <= x21) {
                        if (x12 >= x21) {
                            if (x12 <= x22) {
                                dst.addRectCashed(x21, top, x12, bottom);
                                i1 += 4;
                                continue;
                            }
                            dst.addRectCashed(x21, top, x22, bottom);
                            i2 += 4;
                            continue;
                        }
                        i1 += 4;
                        continue;
                    }
                    if (x22 >= x11) {
                        if (x22 <= x12) {
                            dst.addRectCashed(x11, top, x22, bottom);
                            i2 += 4;
                            continue;
                        }
                        dst.addRectCashed(x11, top, x12, bottom);
                        i1 += 4;
                        continue;
                    }
                    i2 += 4;
                }
                d1.deleteActive(bottom);
                d2.deleteActive(bottom);
            }
        }

        static int[] simpleIntersect(MultiRectArea src1, MultiRectArea src2) {
            int[] rect1 = src1.rect;
            int[] rect2 = src2.rect;
            int[] rect = MultiRectAreaOp.createBuf(0);
            int k = 1;
            int i = 1;
            while (i < rect1[0]) {
                int x11 = rect1[i++];
                int y11 = rect1[i++];
                int x12 = rect1[i++];
                int y12 = rect1[i++];
                int j = 1;
                while (j < rect2[0]) {
                    int x21 = rect2[j++];
                    int y21 = rect2[j++];
                    int x22 = rect2[j++];
                    int y22 = rect2[j++];
                    if (x11 > x22 || x12 < x21 || y11 > y22 || y12 < y21) continue;
                    rect = MultiRectAreaOp.checkBufSize(rect, 4);
                    rect[k++] = x11 > x21 ? x11 : x21;
                    rect[k++] = y11 > y21 ? y11 : y21;
                    rect[k++] = x12 > x22 ? x22 : x12;
                    rect[k++] = y12 > y22 ? y22 : y12;
                }
            }
            rect[0] = k;
            return rect;
        }

        public static MultiRectArea getResult(MultiRectArea src1, MultiRectArea src2) {
            if (src1 == null || src2 == null || src1.isEmpty() || src2.isEmpty()) {
                return new MultiRectArea();
            }
            MultiRectArea.RectCash dst = new MultiRectArea.RectCash();
            if (!src1.sorted || !src2.sorted || src1.getRectCount() <= 8 || src2.getRectCount() <= 8) {
                dst.setRect(Intersection.simpleIntersect(src1, src2), false);
            } else {
                Rectangle bounds1 = src1.getBounds();
                Rectangle bounds2 = src2.getBounds();
                Rectangle bounds3 = bounds1.intersection(bounds2);
                if (bounds3.width > 0 && bounds3.height > 0) {
                    Intersection.intersectRegions(src1.rect, src2.rect, dst, bounds1.height + 2, bounds2.height + 2);
                }
            }
            return dst;
        }
    }

    static class Region {
        int[] region;
        int[] active;
        int[] bottom;
        int index;

        public Region(int[] region) {
            this.region = region;
            this.active = new int[16];
            this.bottom = new int[16];
            this.active[0] = 1;
            this.bottom[0] = 1;
            this.index = 1;
        }

        void addActive(int index) {
            int length = this.active[0];
            this.active = MultiRectAreaOp.checkBufSize(this.active, 4);
            for (int i = 1; i < length; i += 4) {
                if (this.region[index] >= this.active[i]) continue;
                System.arraycopy(this.active, i, this.active, i + 4, length - i);
                length = i;
                break;
            }
            System.arraycopy(this.region, index, this.active, length, 4);
        }

        void findActive(int top, int bottom) {
            while (this.index < this.region[0]) {
                if (this.region[this.index + 1] > bottom) {
                    return;
                }
                if (this.region[this.index + 3] >= top) {
                    this.addActive(this.index);
                }
                this.index += 4;
            }
        }

        void deleteActive(int bottom) {
            int length = this.active[0];
            int i = 1;
            while (i < length) {
                if (this.active[i + 3] == bottom) {
                    if (i >= (length -= 4)) continue;
                    System.arraycopy(this.active, i + 4, this.active, i, length - i);
                    continue;
                }
                i += 4;
            }
            this.active[0] = length;
        }

        void deleteActive() {
            int length = this.active[0];
            for (int i = length - 4; i > 0; i -= 4) {
                if (this.active[i + 1] <= this.active[i + 3] || i >= (length -= 4)) continue;
                System.arraycopy(this.active, i + 4, this.active, i, length - i);
            }
            this.active[0] = length;
        }

        void createLevel(int[] level) {
            int levelCount = 1;
            int topIndex = 1;
            block0: for (int i = 1; i < this.region[0]; i += 4) {
                int j;
                int bottom;
                block5: {
                    int top = this.region[i + 1];
                    bottom = this.region[i + 3] + 1;
                    for (j = topIndex; j < levelCount; ++j) {
                        if (level[j] != top) {
                            if (level[j] <= top) continue;
                            System.arraycopy(level, j, level, j + 1, levelCount - j);
                            break;
                        }
                        break block5;
                    }
                    level[j] = top;
                    ++levelCount;
                    topIndex = j;
                }
                while (j < levelCount) {
                    if (level[j] == bottom) continue block0;
                    if (level[j] > bottom) {
                        System.arraycopy(level, j, level, j + 1, levelCount - j);
                        break;
                    }
                    ++j;
                }
                level[j] = bottom;
                ++levelCount;
            }
            level[0] = levelCount;
        }

        static void sortOrdered(int[] src1, int[] src2, int[] dst) {
            int length1 = src1[0];
            int length2 = src2[0];
            int count = 1;
            int i1 = 1;
            int i2 = 1;
            int v1 = src1[1];
            int v2 = src2[1];
            while (true) {
                block9: {
                    if (i1 < length1) {
                        v1 = src1[i1];
                        if (v1 < v2) {
                            dst[count++] = v1;
                            ++i1;
                            continue;
                        }
                    } else {
                        while (i2 < length2) {
                            dst[count++] = src2[i2++];
                        }
                        dst[0] = count;
                        return;
                    }
                    while (i2 < length2) {
                        v2 = src2[i2];
                        if (v2 < v1) {
                            dst[count++] = v2;
                            ++i2;
                            continue;
                        }
                        break block9;
                    }
                    while (i1 < length1) {
                        dst[count++] = src1[i1++];
                    }
                    dst[0] = count;
                    return;
                }
                if (v1 != v2) continue;
                dst[count++] = v1;
                ++i2;
                if (++i1 < length1) {
                    v1 = src1[i1];
                }
                if (i2 >= length2 - 1) continue;
                v2 = src2[i2];
            }
        }
    }
}

