/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.apache.harmony.awt.gl.MultiRectAreaOp;
import org.apache.harmony.awt.internal.nls.Messages;

public class MultiRectArea
implements Shape {
    private static final boolean CHECK = false;
    boolean sorted = true;
    public int[] rect;
    Rectangle bounds;
    Rectangle[] rectangles;

    public MultiRectArea() {
        this.rect = MultiRectAreaOp.createBuf(0);
    }

    public MultiRectArea(boolean sorted) {
        this();
        this.sorted = sorted;
    }

    public MultiRectArea(MultiRectArea mra) {
        if (mra == null) {
            this.rect = MultiRectAreaOp.createBuf(0);
        } else {
            this.rect = new int[mra.rect.length];
            System.arraycopy(mra.rect, 0, this.rect, 0, mra.rect.length);
            MultiRectArea.check(this, "MultiRectArea(MRA)");
        }
    }

    public MultiRectArea(Rectangle r) {
        this.rect = MultiRectAreaOp.createBuf(0);
        if (r != null && !r.isEmpty()) {
            this.rect[0] = 5;
            this.rect[1] = r.x;
            this.rect[2] = r.y;
            this.rect[3] = r.x + r.width - 1;
            this.rect[4] = r.y + r.height - 1;
        }
        MultiRectArea.check(this, "MultiRectArea(Rectangle)");
    }

    public MultiRectArea(int x0, int y0, int x1, int y1) {
        this.rect = MultiRectAreaOp.createBuf(0);
        if (x1 >= x0 && y1 >= y0) {
            this.rect[0] = 5;
            this.rect[1] = x0;
            this.rect[2] = y0;
            this.rect[3] = x1;
            this.rect[4] = y1;
        }
        MultiRectArea.check(this, "MultiRectArea(Rectangle)");
    }

    public MultiRectArea(Rectangle[] buf) {
        this();
        for (Rectangle element : buf) {
            this.add(element);
        }
    }

    public MultiRectArea(ArrayList<Rectangle> buf) {
        this();
        for (int i = 0; i < buf.size(); ++i) {
            this.add(buf.get(i));
        }
    }

    void resort() {
        int[] buf = new int[4];
        for (int i = 1; i < this.rect[0]; i += 4) {
            int k = i;
            int x1 = this.rect[k];
            int y1 = this.rect[k + 1];
            for (int j = i + 4; j < this.rect[0]; j += 4) {
                int x2 = this.rect[j];
                int y2 = this.rect[j + 1];
                if (y1 <= y2 && (y1 != y2 || x1 <= x2)) continue;
                x1 = x2;
                y1 = y2;
                k = j;
            }
            if (k == i) continue;
            System.arraycopy(this.rect, i, buf, 0, 4);
            System.arraycopy(this.rect, k, this.rect, i, 4);
            System.arraycopy(buf, 0, this.rect, k, 4);
        }
        this.invalidate();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MultiRectArea) {
            MultiRectArea mra = (MultiRectArea)obj;
            for (int i = 0; i < this.rect[0]; ++i) {
                if (this.rect[i] == mra.rect[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static MultiRectArea check(MultiRectArea mra, String msg) {
        return mra;
    }

    public static int checkValidation(Rectangle[] r, boolean sorted) {
        int i;
        for (i = 0; i < r.length; ++i) {
            if (r[i].width > 0 && r[i].height > 0) continue;
            return i;
        }
        if (sorted) {
            for (i = 1; i < r.length; ++i) {
                if (r[i - 1].y > r[i].y) {
                    return i;
                }
                if (r[i - 1].y != r[i].y || r[i - 1].x <= r[i].x) continue;
                return i;
            }
        }
        for (i = 0; i < r.length; ++i) {
            for (int j = i + 1; j < r.length; ++j) {
                if (!r[i].intersects(r[j])) continue;
                return i;
            }
        }
        return -1;
    }

    protected void setRect(int[] buf, boolean copy) {
        if (copy) {
            this.rect = new int[buf.length];
            System.arraycopy(buf, 0, this.rect, 0, buf.length);
        } else {
            this.rect = buf;
        }
        this.invalidate();
    }

    public void add(MultiRectArea mra) {
        this.setRect(MultiRectArea.union((MultiRectArea)this, (MultiRectArea)mra).rect, false);
        this.invalidate();
    }

    public void intersect(MultiRectArea mra) {
        this.setRect(MultiRectArea.intersect((MultiRectArea)this, (MultiRectArea)mra).rect, false);
        this.invalidate();
    }

    public void substract(MultiRectArea mra) {
        this.setRect(MultiRectArea.subtract((MultiRectArea)this, (MultiRectArea)mra).rect, false);
        this.invalidate();
    }

    public void add(Rectangle rect) {
        this.setRect(MultiRectArea.union((MultiRectArea)this, (MultiRectArea)new MultiRectArea((Rectangle)rect)).rect, false);
        this.invalidate();
    }

    public void intersect(Rectangle rect) {
        this.setRect(MultiRectArea.intersect((MultiRectArea)this, (MultiRectArea)new MultiRectArea((Rectangle)rect)).rect, false);
        this.invalidate();
    }

    public void substract(Rectangle rect) {
        this.setRect(MultiRectArea.subtract((MultiRectArea)this, (MultiRectArea)new MultiRectArea((Rectangle)rect)).rect, false);
    }

    public static MultiRectArea intersect(MultiRectArea src1, MultiRectArea src2) {
        MultiRectArea res = MultiRectArea.check(MultiRectAreaOp.Intersection.getResult(src1, src2), "intersect(MRA,MRA)");
        return res;
    }

    public static MultiRectArea union(MultiRectArea src1, MultiRectArea src2) {
        MultiRectArea res = MultiRectArea.check(new MultiRectAreaOp.Union().getResult(src1, src2), "union(MRA,MRA)");
        return res;
    }

    public static MultiRectArea subtract(MultiRectArea src1, MultiRectArea src2) {
        MultiRectArea res = MultiRectArea.check(MultiRectAreaOp.Subtraction.getResult(src1, src2), "subtract(MRA,MRA)");
        return res;
    }

    public static void print(MultiRectArea mra, String msg) {
        if (mra == null) {
            System.out.println(msg + "=null");
        } else {
            Rectangle[] rects = mra.getRectangles();
            System.out.println(msg + "(" + rects.length + ")");
            for (Rectangle element : rects) {
                System.out.println(element.x + "," + element.y + "," + (element.x + element.width - 1) + "," + (element.y + element.height - 1));
            }
        }
    }

    public void translate(int x, int y) {
        int i = 1;
        while (i < this.rect[0]) {
            int n = i++;
            this.rect[n] = this.rect[n] + x;
            int n2 = i++;
            this.rect[n2] = this.rect[n2] + y;
            int n3 = i++;
            this.rect[n3] = this.rect[n3] + x;
            int n4 = i++;
            this.rect[n4] = this.rect[n4] + y;
        }
        if (this.bounds != null && !this.bounds.isEmpty()) {
            this.bounds.translate(x, y);
        }
        if (this.rectangles != null) {
            for (Rectangle element : this.rectangles) {
                element.translate(x, y);
            }
        }
    }

    public void addRect(int x1, int y1, int x2, int y2) {
        int i = this.rect[0];
        this.rect = MultiRectAreaOp.checkBufSize(this.rect, 4);
        this.rect[i++] = x1;
        this.rect[i++] = y1;
        this.rect[i++] = x2;
        this.rect[i++] = y2;
    }

    public boolean isEmpty() {
        return this.rect[0] == 1;
    }

    void invalidate() {
        this.bounds = null;
        this.rectangles = null;
    }

    @Override
    public Rectangle getBounds() {
        if (this.bounds != null) {
            return this.bounds;
        }
        if (this.isEmpty()) {
            this.bounds = new Rectangle();
            return this.bounds;
        }
        int x1 = this.rect[1];
        int y1 = this.rect[2];
        int x2 = this.rect[3];
        int y2 = this.rect[4];
        for (int i = 5; i < this.rect[0]; i += 4) {
            int rx1 = this.rect[i + 0];
            int ry1 = this.rect[i + 1];
            int rx2 = this.rect[i + 2];
            int ry2 = this.rect[i + 3];
            if (rx1 < x1) {
                x1 = rx1;
            }
            if (rx2 > x2) {
                x2 = rx2;
            }
            if (ry1 < y1) {
                y1 = ry1;
            }
            if (ry2 <= y2) continue;
            y2 = ry2;
        }
        this.bounds = new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        return this.bounds;
    }

    public int getRectCount() {
        return (this.rect[0] - 1) / 4;
    }

    public Rectangle[] getRectangles() {
        if (this.rectangles != null) {
            return this.rectangles;
        }
        this.rectangles = new Rectangle[(this.rect[0] - 1) / 4];
        int j = 0;
        for (int i = 1; i < this.rect[0]; i += 4) {
            this.rectangles[j++] = new Rectangle(this.rect[i], this.rect[i + 1], this.rect[i + 2] - this.rect[i] + 1, this.rect[i + 3] - this.rect[i + 1] + 1);
        }
        return this.rectangles;
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    @Override
    public boolean contains(double x, double y) {
        for (int i = 1; i < this.rect[0]; i += 4) {
            if (!((double)this.rect[i] <= x) || !(x <= (double)this.rect[i + 2]) || !((double)this.rect[i + 1] <= y) || !(y <= (double)this.rect[i + 3])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean contains(Rectangle2D r) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        Rectangle r = new Rectangle();
        r.setRect(x, y, w, h);
        return this.intersects(r);
    }

    @Override
    public boolean intersects(Rectangle2D r) {
        if (r == null || r.isEmpty()) {
            return false;
        }
        for (int i = 1; i < this.rect[0]; i += 4) {
            if (!r.intersects(this.rect[i], this.rect[i + 1], this.rect[i + 2] - this.rect[i] + 1, this.rect[i + 3] - this.rect[i + 1] + 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t, double flatness) {
        return new Iterator(this, t);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform t) {
        return new Iterator(this, t);
    }

    public String toString() {
        int cnt = this.getRectCount();
        StringBuilder sb = new StringBuilder((cnt << 5) + 128);
        sb.append(this.getClass().getName()).append(" [");
        for (int i = 1; i < this.rect[0]; i += 4) {
            sb.append(i > 1 ? ", [" : "[").append(this.rect[i]).append(", ").append(this.rect[i + 1]).append(", ").append(this.rect[i + 2] - this.rect[i] + 1).append(", ").append(this.rect[i + 3] - this.rect[i + 1] + 1).append("]");
        }
        return sb.append("]").toString();
    }

    class Iterator
    implements PathIterator {
        int type;
        int index;
        int pos;
        int[] rect;
        AffineTransform t;

        Iterator(MultiRectArea mra, AffineTransform t) {
            this.rect = new int[mra.rect[0] - 1];
            System.arraycopy(mra.rect, 1, this.rect, 0, this.rect.length);
            this.t = t;
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.pos >= this.rect.length;
        }

        @Override
        public void next() {
            if (this.index == 4) {
                this.pos += 4;
            }
            this.index = (this.index + 1) % 5;
        }

        @Override
        public int currentSegment(double[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            int type = 0;
            switch (this.index) {
                case 0: {
                    type = 0;
                    coords[0] = this.rect[this.pos + 0];
                    coords[1] = this.rect[this.pos + 1];
                    break;
                }
                case 1: {
                    type = 1;
                    coords[0] = this.rect[this.pos + 2];
                    coords[1] = this.rect[this.pos + 1];
                    break;
                }
                case 2: {
                    type = 1;
                    coords[0] = this.rect[this.pos + 2];
                    coords[1] = this.rect[this.pos + 3];
                    break;
                }
                case 3: {
                    type = 1;
                    coords[0] = this.rect[this.pos + 0];
                    coords[1] = this.rect[this.pos + 3];
                    break;
                }
                case 4: {
                    type = 4;
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }

        @Override
        public int currentSegment(float[] coords) {
            if (this.isDone()) {
                throw new NoSuchElementException(Messages.getString("awt.4B"));
            }
            int type = 0;
            switch (this.index) {
                case 0: {
                    type = 0;
                    coords[0] = this.rect[this.pos + 0];
                    coords[1] = this.rect[this.pos + 1];
                    break;
                }
                case 1: {
                    type = 1;
                    coords[0] = this.rect[this.pos + 2];
                    coords[1] = this.rect[this.pos + 1];
                    break;
                }
                case 2: {
                    type = 1;
                    coords[0] = this.rect[this.pos + 2];
                    coords[1] = this.rect[this.pos + 3];
                    break;
                }
                case 3: {
                    type = 1;
                    coords[0] = this.rect[this.pos + 0];
                    coords[1] = this.rect[this.pos + 3];
                    break;
                }
                case 4: {
                    type = 4;
                }
            }
            if (this.t != null) {
                this.t.transform(coords, 0, coords, 0, 1);
            }
            return type;
        }
    }

    public static class RectCash
    extends MultiRectArea {
        int[] cash = new int[16];

        public RectCash() {
            this.cash[0] = 1;
        }

        public void addRectCashed(int x1, int y1, int x2, int y2) {
            this.addRect(x1, y1, x2, y2);
            this.invalidate();
        }

        public void addRectCashed(int[] rect, int rectOff, int rectLength) {
            int i = rectOff;
            while (i < rectOff + rectLength) {
                this.addRect(rect[i++], rect[i++], rect[i++], rect[i++]);
            }
        }
    }

    public static class LineCash
    extends MultiRectArea {
        int lineY;
        int bottomCount;
        int[] bottom;

        public LineCash(int size) {
            this.bottom = new int[size];
            this.bottomCount = 0;
        }

        public void setLine(int y) {
            this.lineY = y;
        }

        public void skipLine() {
            ++this.lineY;
            this.bottomCount = 0;
        }

        public void addLine(int[] points, int pointCount) {
            int bottomIndex = 0;
            int pointIndex = 0;
            int rectIndex = 0;
            int pointX1 = 0;
            int pointX2 = 0;
            int bottomX1 = 0;
            int bottomX2 = 0;
            boolean appendRect = false;
            boolean deleteRect = false;
            int lastCount = this.bottomCount;
            while (bottomIndex < lastCount || pointIndex < pointCount) {
                appendRect = false;
                deleteRect = false;
                if (bottomIndex < lastCount) {
                    rectIndex = this.bottom[bottomIndex];
                    bottomX1 = this.rect[rectIndex];
                    bottomX2 = this.rect[rectIndex + 2];
                } else {
                    appendRect = true;
                }
                if (pointIndex < pointCount) {
                    pointX1 = points[pointIndex];
                    pointX2 = points[pointIndex + 1];
                } else {
                    deleteRect = true;
                }
                if (!deleteRect && !appendRect) {
                    if (pointX1 == bottomX1 && pointX2 == bottomX2) {
                        this.rect[rectIndex + 3] = this.rect[rectIndex + 3] + 1;
                        pointIndex += 2;
                        ++bottomIndex;
                        continue;
                    }
                    deleteRect = pointX2 >= bottomX1;
                    boolean bl = appendRect = pointX1 <= bottomX2;
                }
                if (deleteRect) {
                    if (bottomIndex < this.bottomCount - 1) {
                        System.arraycopy(this.bottom, bottomIndex + 1, this.bottom, bottomIndex, this.bottomCount - bottomIndex - 1);
                        rectIndex -= 4;
                    }
                    --this.bottomCount;
                    --lastCount;
                }
                if (!appendRect) continue;
                int i = this.rect[0];
                this.bottom[this.bottomCount++] = i;
                this.rect = MultiRectAreaOp.checkBufSize(this.rect, 4);
                this.rect[i++] = pointX1;
                this.rect[i++] = this.lineY;
                this.rect[i++] = pointX2;
                this.rect[i++] = this.lineY;
                pointIndex += 2;
            }
            ++this.lineY;
            this.invalidate();
        }
    }
}

