/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.AwtImageBackdoorAccessor;
import org.apache.harmony.awt.gl.Surface;
import org.apache.harmony.awt.gl.color.LUTColorConverter;
import org.apache.harmony.awt.gl.image.DataBufferListener;
import org.apache.harmony.awt.internal.nls.Messages;

public class ImageSurface
extends Surface
implements DataBufferListener {
    int surfaceType;
    int csType;
    ColorModel cm;
    WritableRaster raster;
    Object data;
    boolean needToRefresh = true;
    boolean dataTaken = false;
    AwtImageBackdoorAccessor ba = AwtImageBackdoorAccessor.getInstance();

    public ImageSurface(ColorModel cm, WritableRaster raster) {
        this(cm, raster, Surface.getType(cm, raster));
    }

    public ImageSurface(ColorModel cm, WritableRaster raster, int type) {
        if (!cm.isCompatibleRaster(raster)) {
            throw new IllegalArgumentException(Messages.getString("awt.4D"));
        }
        this.cm = cm;
        this.raster = raster;
        this.surfaceType = type;
        DataBuffer db = raster.getDataBuffer();
        this.data = this.ba.getData(db);
        this.ba.addDataBufferListener(db, this);
        ColorSpace cs = cm.getColorSpace();
        this.transparency = cm.getTransparency();
        this.width = raster.getWidth();
        this.height = raster.getHeight();
        this.addDirtyRegion(new Rectangle(0, 0, this.width, this.height));
        this.csType = cs == LUTColorConverter.sRGB_CS ? 1 : (cs == LUTColorConverter.LINEAR_RGB_CS ? 2 : (cs == LUTColorConverter.LINEAR_GRAY_CS ? 3 : 0));
    }

    @Override
    public ColorModel getColorModel() {
        return this.cm;
    }

    @Override
    public WritableRaster getRaster() {
        return this.raster;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public boolean isNativeDrawable() {
        return false;
    }

    @Override
    public int getSurfaceType() {
        return this.surfaceType;
    }

    @Override
    public synchronized void dispose() {
        this.ba.removeDataBufferListener(this.raster.getDataBuffer());
    }

    public void setRaster(WritableRaster r) {
        this.raster = r;
        DataBuffer db = r.getDataBuffer();
        this.data = this.ba.getData(db);
        this.ba.addDataBufferListener(db, this);
        this.width = r.getWidth();
        this.height = r.getHeight();
    }

    @Override
    public long lock() {
        return 0L;
    }

    @Override
    public void unlock() {
    }

    @Override
    public Surface getImageSurface() {
        return this;
    }

    @Override
    public void dataChanged() {
        this.needToRefresh = true;
        this.clearValidCaches();
    }

    @Override
    public void dataTaken() {
        this.dataTaken = true;
        this.needToRefresh = true;
        this.clearValidCaches();
    }

    @Override
    public void dataReleased() {
        this.dataTaken = false;
        this.needToRefresh = true;
        this.clearValidCaches();
    }

    @Override
    public void invalidate() {
        this.needToRefresh = true;
        this.clearValidCaches();
    }

    @Override
    public void validate() {
        if (!this.needToRefresh) {
            return;
        }
        if (!this.dataTaken) {
            this.needToRefresh = false;
            AwtImageBackdoorAccessor ba = AwtImageBackdoorAccessor.getInstance();
            ba.validate(this.raster.getDataBuffer());
        }
        this.releaseDurtyRegions();
    }

    @Override
    public boolean invalidated() {
        return this.needToRefresh | this.dataTaken;
    }
}

