/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.awt.gl;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.harmony.awt.Utils;
import org.apache.harmony.awt.gl.ImageSurface;
import org.apache.harmony.awt.gl.MultiRectArea;
import org.apache.harmony.awt.gl.NullTextRenderer;
import org.apache.harmony.awt.gl.Surface;
import org.apache.harmony.awt.gl.TextRenderer;
import org.apache.harmony.awt.gl.XORComposite;
import org.apache.harmony.awt.gl.image.OffscreenImage;
import org.apache.harmony.awt.gl.render.Blitter;
import org.apache.harmony.awt.gl.render.JavaArcRasterizer;
import org.apache.harmony.awt.gl.render.JavaLineRasterizer;
import org.apache.harmony.awt.gl.render.JavaShapeRasterizer;
import org.apache.harmony.awt.gl.render.NullBlitter;

public abstract class CommonGraphics2D
extends Graphics2D {
    private static final Map<RenderingHints.Key, Object> DEFAULT_RENDERING_HINTS;
    protected Surface dstSurf = null;
    protected Blitter blitter = NullBlitter.getInstance();
    protected RenderingHints hints = new RenderingHints(DEFAULT_RENDERING_HINTS);
    protected MultiRectArea clip = null;
    protected Paint paint = Color.WHITE;
    protected Color fgColor = Color.WHITE;
    protected Color bgColor = Color.BLACK;
    protected Composite composite = AlphaComposite.SrcOver;
    protected Stroke stroke = new BasicStroke();
    protected FontRenderContext frc = null;
    protected JavaShapeRasterizer jsr = new JavaShapeRasterizer();
    protected Font font = new Font("Dialog", 0, 12);
    protected TextRenderer jtr = new NullTextRenderer();
    protected AffineTransform transform = new AffineTransform();
    protected double[] matrix = new double[6];
    public Point origPoint = new Point(0, 0);
    protected static final boolean debugOutput;

    protected CommonGraphics2D() {
    }

    protected CommonGraphics2D(int tx, int ty) {
        this(tx, ty, null);
    }

    protected CommonGraphics2D(int tx, int ty, MultiRectArea clip) {
        this.setTransform(AffineTransform.getTranslateInstance(tx, ty));
        this.origPoint = new Point(tx, ty);
        this.setClip(clip);
    }

    @Override
    public void addRenderingHints(Map<?, ?> hints) {
        this.hints.putAll(hints);
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
        Color c = this.getColor();
        Paint p = this.getPaint();
        this.setColor(this.getBackground());
        this.fillRect(x, y, width, height);
        this.setColor(c);
        this.setPaint(p);
        if (debugOutput) {
            System.err.println("CommonGraphics2D.clearRect(" + x + ", " + y + ", " + width + ", " + height + ")");
        }
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    @Override
    public void clip(Shape s) {
        if (s == null) {
            this.clip = null;
            return;
        }
        MultiRectArea mra = null;
        if (s instanceof MultiRectArea) {
            mra = new MultiRectArea((MultiRectArea)s);
            mra.translate((int)this.transform.getTranslateX(), (int)this.transform.getTranslateY());
        } else {
            int type = this.transform.getType();
            if (s instanceof Rectangle && (type == 0 || type == 1)) {
                mra = new MultiRectArea((Rectangle)s);
                if (type == 1) {
                    mra.translate((int)this.transform.getTranslateX(), (int)this.transform.getTranslateY());
                }
            } else {
                s = this.transform.createTransformedShape(s);
                mra = this.jsr.rasterize(s, 0.5);
            }
        }
        if (this.clip == null) {
            this.setTransformedClip(mra);
        } else {
            this.clip.intersect(mra);
            this.setTransformedClip(this.clip);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public void draw(Shape s) {
        if (this.stroke instanceof BasicStroke && ((BasicStroke)this.stroke).getLineWidth() <= 1.0f) {
            BasicStroke bstroke = (BasicStroke)this.stroke;
            JavaLineRasterizer.LineDasher ld = bstroke.getDashArray() == null ? null : new JavaLineRasterizer.LineDasher(bstroke.getDashArray(), bstroke.getDashPhase());
            PathIterator pi = s.getPathIterator(this.transform, 0.5);
            float[] points = new float[6];
            int x1 = Integer.MIN_VALUE;
            int y1 = Integer.MIN_VALUE;
            int cx1 = Integer.MIN_VALUE;
            int cy1 = Integer.MIN_VALUE;
            while (!pi.isDone()) {
                switch (pi.currentSegment(points)) {
                    case 0: {
                        x1 = (int)Math.floor(points[0]);
                        y1 = (int)Math.floor(points[1]);
                        cx1 = x1;
                        cy1 = y1;
                        break;
                    }
                    case 1: {
                        int x2 = (int)Math.floor(points[0]);
                        int y2 = (int)Math.floor(points[1]);
                        this.fillMultiRectArea(JavaLineRasterizer.rasterize(x1, y1, x2, y2, null, ld, false));
                        x1 = x2;
                        y1 = y2;
                        break;
                    }
                    case 4: {
                        int x2 = cx1;
                        int y2 = cy1;
                        this.fillMultiRectArea(JavaLineRasterizer.rasterize(x1, y1, x2, y2, null, ld, false));
                        x1 = x2;
                        y1 = y2;
                    }
                }
                pi.next();
            }
        } else {
            s = this.stroke.createStrokedShape(s);
            s = this.transform.createTransformedShape(s);
            this.fillMultiRectArea(this.jsr.rasterize(s, 0.5));
        }
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int sa, int ea) {
        if (this.stroke instanceof BasicStroke && ((BasicStroke)this.stroke).getLineWidth() <= 1.0f && ((BasicStroke)this.stroke).getDashArray() == null && (this.transform.isIdentity() || this.transform.getType() == 1)) {
            Point p = new Point(x, y);
            this.transform.transform(p, p);
            MultiRectArea mra = JavaArcRasterizer.rasterize(x, y, width, height, sa, ea, this.clip);
            this.fillMultiRectArea(mra);
            return;
        }
        this.draw(new Arc2D.Float(x, y, width, height, sa, ea, 0));
    }

    @Override
    public boolean drawImage(Image image, int x, int y, Color bgcolor, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        boolean done = false;
        boolean somebits = false;
        Surface srcSurf = null;
        if (image instanceof OffscreenImage) {
            OffscreenImage oi = (OffscreenImage)image;
            if ((oi.getState() & 0x40) != 0) {
                return false;
            }
            done = oi.prepareImage(imageObserver);
            somebits = (oi.getState() & 8) != 0;
            srcSurf = oi.getImageSurface();
        } else {
            done = true;
            srcSurf = Surface.getImageSurface(image);
        }
        if (done || somebits) {
            int w = srcSurf.getWidth();
            int h = srcSurf.getHeight();
            this.blitter.blit(0, 0, srcSurf, x, y, this.dstSurf, w, h, (AffineTransform)this.transform.clone(), this.composite, bgcolor, this.clip);
        }
        return done;
    }

    @Override
    public boolean drawImage(Image image, int x, int y, ImageObserver imageObserver) {
        return this.drawImage(image, x, y, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgcolor, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        if (width == 0 || height == 0) {
            return true;
        }
        boolean done = false;
        boolean somebits = false;
        Surface srcSurf = null;
        if (image instanceof OffscreenImage) {
            OffscreenImage oi = (OffscreenImage)image;
            if ((oi.getState() & 0x40) != 0) {
                return false;
            }
            done = oi.prepareImage(imageObserver);
            somebits = (oi.getState() & 8) != 0;
            srcSurf = oi.getImageSurface();
        } else {
            done = true;
            srcSurf = Surface.getImageSurface(image);
        }
        if (done || somebits) {
            int w = srcSurf.getWidth();
            int h = srcSurf.getHeight();
            if (w == width && h == height) {
                this.blitter.blit(0, 0, srcSurf, x, y, this.dstSurf, w, h, (AffineTransform)this.transform.clone(), this.composite, bgcolor, this.clip);
            } else {
                AffineTransform xform = new AffineTransform();
                xform.setToScale((float)width / (float)w, (float)height / (float)h);
                this.blitter.blit(0, 0, srcSurf, x, y, this.dstSurf, w, h, (AffineTransform)this.transform.clone(), xform, this.composite, bgcolor, this.clip);
            }
        }
        return done;
    }

    @Override
    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver imageObserver) {
        return this.drawImage(image, x, y, width, height, null, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        if (dx1 == dx2 || dy1 == dy2 || sx1 == sx2 || sy1 == sy2) {
            return true;
        }
        boolean done = false;
        boolean somebits = false;
        Surface srcSurf = null;
        if (image instanceof OffscreenImage) {
            OffscreenImage oi = (OffscreenImage)image;
            if ((oi.getState() & 0x40) != 0) {
                return false;
            }
            done = oi.prepareImage(imageObserver);
            somebits = (oi.getState() & 8) != 0;
            srcSurf = oi.getImageSurface();
        } else {
            done = true;
            srcSurf = Surface.getImageSurface(image);
        }
        if (done || somebits) {
            int dstX = dx1;
            int dstY = dy1;
            int srcX = sx1;
            int srcY = sy1;
            int dstW = dx2 - dx1;
            int dstH = dy2 - dy1;
            int srcW = sx2 - sx1;
            int srcH = sy2 - sy1;
            if (srcW == dstW && srcH == dstH) {
                this.blitter.blit(srcX, srcY, srcSurf, dstX, dstY, this.dstSurf, srcW, srcH, (AffineTransform)this.transform.clone(), this.composite, bgcolor, this.clip);
            } else {
                AffineTransform xform = new AffineTransform();
                xform.setToScale((float)dstW / (float)srcW, (float)dstH / (float)srcH);
                this.blitter.blit(srcX, srcY, srcSurf, dstX, dstY, this.dstSurf, srcW, srcH, (AffineTransform)this.transform.clone(), xform, this.composite, bgcolor, this.clip);
            }
        }
        return done;
    }

    @Override
    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver imageObserver) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufImage, BufferedImageOp op, int x, int y) {
        if (bufImage == null) {
            return;
        }
        if (op == null) {
            this.drawImage((Image)bufImage, x, y, null);
        } else if (op instanceof AffineTransformOp) {
            AffineTransformOp atop = (AffineTransformOp)op;
            AffineTransform xform = atop.getTransform();
            Surface srcSurf = Surface.getImageSurface(bufImage);
            int w = srcSurf.getWidth();
            int h = srcSurf.getHeight();
            this.blitter.blit(0, 0, srcSurf, x, y, this.dstSurf, w, h, (AffineTransform)this.transform.clone(), xform, this.composite, null, this.clip);
        } else {
            bufImage = op.filter(bufImage, null);
            Surface srcSurf = Surface.getImageSurface(bufImage);
            int w = srcSurf.getWidth();
            int h = srcSurf.getHeight();
            this.blitter.blit(0, 0, srcSurf, x, y, this.dstSurf, w, h, (AffineTransform)this.transform.clone(), this.composite, null, this.clip);
        }
    }

    @Override
    public boolean drawImage(Image image, AffineTransform trans, ImageObserver imageObserver) {
        if (image == null) {
            return true;
        }
        if (trans == null || trans.isIdentity()) {
            return this.drawImage(image, 0, 0, imageObserver);
        }
        boolean done = false;
        boolean somebits = false;
        Surface srcSurf = null;
        if (image instanceof OffscreenImage) {
            OffscreenImage oi = (OffscreenImage)image;
            if ((oi.getState() & 0x40) != 0) {
                return false;
            }
            done = oi.prepareImage(imageObserver);
            somebits = (oi.getState() & 8) != 0;
            srcSurf = oi.getImageSurface();
        } else {
            done = true;
            srcSurf = Surface.getImageSurface(image);
        }
        if (done || somebits) {
            int w = srcSurf.getWidth();
            int h = srcSurf.getHeight();
            AffineTransform xform = (AffineTransform)this.transform.clone();
            xform.concatenate(trans);
            this.blitter.blit(0, 0, srcSurf, 0, 0, this.dstSurf, w, h, xform, this.composite, null, this.clip);
        }
        return done;
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        if (debugOutput) {
            System.err.println("CommonGraphics2D.drawLine(" + x1 + ", " + y1 + ", " + x2 + ", " + y2 + ")");
        }
        if (this.stroke instanceof BasicStroke && ((BasicStroke)this.stroke).getLineWidth() <= 1.0f) {
            BasicStroke bstroke = (BasicStroke)this.stroke;
            Point p1 = new Point(x1, y1);
            Point p2 = new Point(x2, y2);
            this.transform.transform(p1, p1);
            this.transform.transform(p2, p2);
            JavaLineRasterizer.LineDasher ld = bstroke.getDashArray() == null ? null : new JavaLineRasterizer.LineDasher(bstroke.getDashArray(), bstroke.getDashPhase());
            MultiRectArea mra = JavaLineRasterizer.rasterize(p1.x, p1.y, p2.x, p2.y, null, ld, false);
            this.fillMultiRectArea(mra);
            return;
        }
        this.draw(new Line2D.Float(x1, y1, x2, y2));
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        if (this.stroke instanceof BasicStroke && ((BasicStroke)this.stroke).getLineWidth() <= 1.0f && ((BasicStroke)this.stroke).getDashArray() == null && (this.transform.isIdentity() || this.transform.getType() == 1)) {
            Point p = new Point(x, y);
            this.transform.transform(p, p);
            MultiRectArea mra = JavaArcRasterizer.rasterize(p.x, p.y, width, height, 0.0, 360.0, this.clip);
            this.fillMultiRectArea(mra);
            return;
        }
        this.draw(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void drawPolygon(int[] xpoints, int[] ypoints, int npoints) {
        this.draw(new Polygon(xpoints, ypoints, npoints));
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.draw(polygon);
    }

    @Override
    public void drawPolyline(int[] xpoints, int[] ypoints, int npoints) {
        for (int i = 0; i < npoints - 1; ++i) {
            this.drawLine(xpoints[i], ypoints[i], xpoints[i + 1], ypoints[i + 1]);
        }
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        if (img == null) {
            return;
        }
        double scaleX = xform.getScaleX();
        double scaleY = xform.getScaleY();
        if (scaleX == 1.0 && scaleY == 1.0) {
            this.drawRenderedImage(img.createDefaultRendering(), xform);
        } else {
            int width = (int)Math.round((double)img.getWidth() * scaleX);
            int height = (int)Math.round((double)img.getHeight() * scaleY);
            xform = (AffineTransform)xform.clone();
            xform.scale(1.0, 1.0);
            this.drawRenderedImage(img.createScaledRendering(width, height, null), xform);
        }
    }

    @Override
    public void drawRenderedImage(RenderedImage rimg, AffineTransform xform) {
        if (rimg == null) {
            return;
        }
        Image img = null;
        img = rimg instanceof Image ? (Image)((Object)rimg) : new BufferedImage(rimg.getColorModel(), rimg.copyData(null), false, null);
        this.drawImage(img, xform, null);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (debugOutput) {
            System.err.println("CommonGraphics2D.drawRoundRect(" + x + ", " + y + ", " + width + ", " + height + "," + arcWidth + ", " + arcHeight + ")");
        }
        this.draw(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        GlyphVector gv = this.font.createGlyphVector(this.frc, iterator);
        this.drawGlyphVector(gv, x, y);
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.drawString(iterator, (float)x, (float)y);
    }

    @Override
    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    @Override
    public void fill(Shape s) {
        s = this.transform.createTransformedShape(s);
        MultiRectArea mra = this.jsr.rasterize(s, 0.5);
        this.fillMultiRectArea(mra);
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int sa, int ea) {
        this.fill(new Arc2D.Float(x, y, width, height, sa, ea, 2));
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Float(x, y, width, height));
    }

    @Override
    public void fillPolygon(int[] xpoints, int[] ypoints, int npoints) {
        this.fill(new Polygon(xpoints, ypoints, npoints));
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.fill(polygon);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        if (debugOutput) {
            System.err.println("CommonGraphics2D.fillRect(" + x + ", " + y + ", " + width + ", " + height + ")");
        }
        this.fill(new Rectangle(x, y, width, height));
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (debugOutput) {
            System.err.println("CommonGraphics2D.fillRoundRect(" + x + ", " + y + ", " + width + ", " + height + "," + arcWidth + ", " + arcHeight + ")");
        }
        this.fill(new RoundRectangle2D.Float(x, y, width, height, arcWidth, arcHeight));
    }

    @Override
    public Color getBackground() {
        return this.bgColor;
    }

    @Override
    public Shape getClip() {
        if (this.clip == null) {
            return null;
        }
        MultiRectArea res = new MultiRectArea(this.clip);
        res.translate(-Math.round((float)this.transform.getTranslateX()), -Math.round((float)this.transform.getTranslateY()));
        return res;
    }

    @Override
    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        Rectangle res = (Rectangle)this.clip.getBounds().clone();
        res.translate(-Math.round((float)this.transform.getTranslateX()), -Math.round((float)this.transform.getTranslateY()));
        return res;
    }

    @Override
    public Color getColor() {
        return this.fgColor;
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        if (this.frc == null) {
            AffineTransform at;
            GraphicsConfiguration gc = this.getDeviceConfiguration();
            if (gc != null) {
                at = gc.getDefaultTransform();
                at.concatenate(gc.getNormalizingTransform());
            } else {
                at = null;
            }
            boolean isAa = this.hints.get(RenderingHints.KEY_TEXT_ANTIALIASING) == RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
            boolean isFm = this.hints.get(RenderingHints.KEY_FRACTIONALMETRICS) == RenderingHints.VALUE_FRACTIONALMETRICS_ON;
            this.frc = new FontRenderContext(at, isAa, isFm);
        }
        return this.frc;
    }

    @Override
    public Paint getPaint() {
        return this.paint;
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public void rotate(double theta) {
        this.transform.rotate(theta);
        this.transform.getMatrix(this.matrix);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
        this.transform.getMatrix(this.matrix);
    }

    @Override
    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
        this.transform.getMatrix(this.matrix);
    }

    @Override
    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
        this.transform.getMatrix(this.matrix);
    }

    @Override
    public void transform(AffineTransform at) {
        this.transform.concatenate(at);
        this.transform.getMatrix(this.matrix);
    }

    @Override
    public void translate(double tx, double ty) {
        if (debugOutput) {
            System.err.println("CommonGraphics2D.translate(" + tx + ", " + ty + ")");
        }
        this.transform.translate(tx, ty);
        this.transform.getMatrix(this.matrix);
    }

    @Override
    public void translate(int tx, int ty) {
        if (debugOutput) {
            System.err.println("CommonGraphics2D.translate(" + tx + ", " + ty + ")");
        }
        this.transform.translate(tx, ty);
        this.transform.getMatrix(this.matrix);
    }

    @Override
    public void setBackground(Color color) {
        this.bgColor = color;
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle(x, y, width, height));
    }

    @Override
    public void setClip(Shape s) {
        if (s == null) {
            this.setTransformedClip(null);
            if (debugOutput) {
                System.err.println("CommonGraphics2D.setClip(null)");
            }
            return;
        }
        if (debugOutput) {
            System.err.println("CommonGraphics2D.setClip(" + s.getBounds() + ")");
        }
        if (s instanceof MultiRectArea) {
            MultiRectArea nclip = new MultiRectArea((MultiRectArea)s);
            nclip.translate(Math.round((float)this.transform.getTranslateX()), Math.round((float)this.transform.getTranslateY()));
            this.setTransformedClip(nclip);
        } else {
            int type = this.transform.getType();
            if (s instanceof Rectangle && (type == 0 || type == 1)) {
                MultiRectArea nclip = new MultiRectArea((Rectangle)s);
                if (type == 1) {
                    nclip.translate((int)this.transform.getTranslateX(), (int)this.transform.getTranslateY());
                }
                this.setTransformedClip(nclip);
            } else {
                s = this.transform.createTransformedShape(s);
                this.setTransformedClip(this.jsr.rasterize(s, 0.5));
            }
        }
    }

    @Override
    public void setColor(Color color) {
        if (color != null) {
            this.fgColor = color;
            this.paint = color;
        }
    }

    @Override
    public void setComposite(Composite composite) {
        this.composite = composite;
    }

    @Override
    public void setFont(Font font) {
        this.font = font;
    }

    @Override
    public void setPaint(Paint paint) {
        if (paint == null) {
            return;
        }
        this.paint = paint;
        if (paint instanceof Color) {
            this.fgColor = (Color)paint;
        }
    }

    @Override
    public void setPaintMode() {
        this.composite = AlphaComposite.SrcOver;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object value) {
        this.hints.put(key, value);
    }

    @Override
    public void setRenderingHints(Map<?, ?> hints) {
        this.hints.clear();
        this.hints.putAll(DEFAULT_RENDERING_HINTS);
        this.hints.putAll(hints);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    @Override
    public void setTransform(AffineTransform transform) {
        this.transform = transform;
        transform.getMatrix(this.matrix);
    }

    @Override
    public void setXORMode(Color color) {
        this.composite = new XORComposite(color);
    }

    protected void setTransformedClip(MultiRectArea clip) {
        this.clip = clip;
    }

    protected void fillMultiRectArea(MultiRectArea mra) {
        if (this.clip != null) {
            mra.intersect(this.clip);
        }
        if (mra.rect[0] < 5) {
            return;
        }
        if (debugOutput) {
            System.err.println("CommonGraphics2D.fillMultiRectArea(" + mra + ")");
        }
        if (this.paint instanceof Color) {
            this.fillMultiRectAreaColor(mra);
        } else {
            this.fillMultiRectAreaPaint(mra);
        }
    }

    protected void fillMultiRectAreaColor(MultiRectArea mra) {
        this.fillMultiRectAreaPaint(mra);
    }

    protected void fillMultiRectAreaPaint(MultiRectArea mra) {
        WritableRaster wr;
        Rectangle rec = mra.getBounds();
        int x = rec.x;
        int y = rec.y;
        int w = rec.width;
        int h = rec.height;
        if (w <= 0 || h <= 0) {
            return;
        }
        PaintContext pc = this.paint.createContext(null, rec, rec, this.transform, this.hints);
        Raster r = pc.getRaster(x, y, w, h);
        if (r instanceof WritableRaster) {
            wr = (WritableRaster)r;
        } else {
            wr = r.createCompatibleWritableRaster();
            wr.setRect(r);
        }
        ImageSurface srcSurf = new ImageSurface(pc.getColorModel(), wr);
        this.blitter.blit(0, 0, srcSurf, x, y, this.dstSurf, w, h, this.composite, null, mra);
        ((Surface)srcSurf).dispose();
    }

    protected void copyInternalFields(CommonGraphics2D copy) {
        if (this.clip == null) {
            copy.setTransformedClip(null);
        } else {
            copy.setTransformedClip(new MultiRectArea(this.clip));
        }
        copy.setBackground(this.bgColor);
        copy.setColor(this.fgColor);
        copy.setPaint(this.paint);
        copy.setComposite(this.composite);
        copy.setStroke(this.stroke);
        copy.setFont(this.font);
        copy.setTransform(new AffineTransform(this.transform));
        copy.origPoint = new Point(this.origPoint);
    }

    public void flush() {
    }

    static {
        HashMap<RenderingHints.Key, Object> m = new HashMap<RenderingHints.Key, Object>();
        m.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        m.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        m.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        DEFAULT_RENDERING_HINTS = Collections.unmodifiableMap(m);
        debugOutput = "1".equals(Utils.getSystemProperty("g2d.debug"));
    }
}

