/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.apache.harmony.x.imageio.internal.nls.Messages;
import org.apache.harmony.x.imageio.stream.RandomAccessMemoryCache;

public class MemoryCacheImageOutputStream
extends ImageOutputStreamImpl {
    OutputStream os;
    RandomAccessMemoryCache ramc = new RandomAccessMemoryCache();

    public MemoryCacheImageOutputStream(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.0A"));
        }
        this.os = stream;
    }

    @Override
    public void write(int b) throws IOException {
        this.flushBits();
        this.ramc.putData(b, this.streamPos);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.flushBits();
        this.ramc.putData(b, off, len, this.streamPos);
        this.streamPos += (long)len;
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        int res = this.ramc.getData(this.streamPos);
        if (res >= 0) {
            ++this.streamPos;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bitOffset = 0;
        int res = this.ramc.getData(b, off, len, this.streamPos);
        if (res > 0) {
            this.streamPos += (long)res;
        }
        return res;
    }

    @Override
    public long length() {
        return this.ramc.length();
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public boolean isCachedMemory() {
        return true;
    }

    @Override
    public boolean isCachedFile() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.flushBefore(this.length());
        super.close();
        this.ramc.close();
    }

    @Override
    public void flushBefore(long pos) throws IOException {
        long flushedPosition = this.getFlushedPosition();
        super.flushBefore(pos);
        long newFlushedPosition = this.getFlushedPosition();
        int nBytes = (int)(newFlushedPosition - flushedPosition);
        this.ramc.getData(this.os, nBytes, flushedPosition);
        this.ramc.freeBefore(newFlushedPosition);
        this.os.flush();
    }
}

