/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStreamImpl;
import javax.imageio.stream.ImageOutputStream;

public abstract class ImageOutputStreamImpl
extends ImageInputStreamImpl
implements ImageOutputStream {
    private final byte[] buff = new byte[8];

    @Override
    public abstract void write(int var1) throws IOException;

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public abstract void write(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.write(v ? 1 : 0);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.write(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.buff[0] = (byte)(v >> 8);
            this.buff[1] = (byte)v;
        } else {
            this.buff[1] = (byte)(v >> 8);
            this.buff[0] = (byte)v;
        }
        this.write(this.buff, 0, 2);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.buff[0] = (byte)(v >> 24);
            this.buff[1] = (byte)(v >> 16);
            this.buff[2] = (byte)(v >> 8);
            this.buff[3] = (byte)v;
        } else {
            this.buff[3] = (byte)(v >> 24);
            this.buff[2] = (byte)(v >> 16);
            this.buff[1] = (byte)(v >> 8);
            this.buff[0] = (byte)v;
        }
        this.write(this.buff, 0, 4);
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            this.buff[0] = (byte)(v >> 56);
            this.buff[1] = (byte)(v >> 48);
            this.buff[2] = (byte)(v >> 40);
            this.buff[3] = (byte)(v >> 32);
            this.buff[4] = (byte)(v >> 24);
            this.buff[5] = (byte)(v >> 16);
            this.buff[6] = (byte)(v >> 8);
            this.buff[7] = (byte)v;
        } else {
            this.buff[7] = (byte)(v >> 56);
            this.buff[6] = (byte)(v >> 48);
            this.buff[5] = (byte)(v >> 40);
            this.buff[4] = (byte)(v >> 32);
            this.buff[3] = (byte)(v >> 24);
            this.buff[2] = (byte)(v >> 16);
            this.buff[1] = (byte)(v >> 8);
            this.buff[0] = (byte)v;
        }
        this.write(this.buff, 0, 8);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes());
    }

    @Override
    public void writeChars(String s) throws IOException {
        char[] chs = s.toCharArray();
        this.writeChars(chs, 0, chs.length);
    }

    @Override
    public void writeUTF(String s) throws IOException {
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        new DataOutputStream(baos).writeUTF(s);
        this.write(baos.toByteArray(), 0, baos.size());
        this.setByteOrder(byteOrder);
    }

    @Override
    public void writeShorts(short[] s, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > s.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.writeShort(s[off + i]);
        }
    }

    @Override
    public void writeChars(char[] c, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > c.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.writeShort(c[off + i]);
        }
    }

    @Override
    public void writeInts(int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; ++n) {
            this.writeInt(i[off + n]);
        }
    }

    @Override
    public void writeLongs(long[] l, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > l.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.writeLong(l[off + i]);
        }
    }

    @Override
    public void writeFloats(float[] f, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > f.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.writeFloat(f[off + i]);
        }
    }

    @Override
    public void writeDoubles(double[] d, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > d.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.writeDouble(d[off + i]);
        }
    }

    @Override
    public void writeBit(int bit) throws IOException {
        this.writeBits(bit, 1);
    }

    @Override
    public void writeBits(long bits, int numBits) throws IOException {
        int mask;
        int currentByte;
        this.checkClosed();
        if (this.bitOffset > 0) {
            int oldBitOffset = this.bitOffset;
            currentByte = this.read();
            if (currentByte == -1) {
                currentByte = 0;
            } else {
                this.seek(this.getStreamPosition() - 1L);
            }
            int num = 8 - oldBitOffset;
            if (numBits >= num) {
                int mask2 = -1 >>> 32 - num;
                currentByte &= ~mask2;
                currentByte = (int)((long)currentByte | bits >> (numBits -= num) & (long)mask2);
                this.write(currentByte);
            } else {
                int offset = oldBitOffset + numBits;
                int mask3 = -1 >>> numBits;
                currentByte &= ~(mask3 << 8 - offset);
                currentByte = (int)((long)currentByte | (bits & (long)mask3) << 8 - offset);
                this.write(currentByte);
                this.seek(this.getStreamPosition() - 1L);
                this.bitOffset = offset;
                numBits = 0;
            }
        }
        while (numBits > 7) {
            mask = 255;
            currentByte = (int)(bits >> numBits - 8 & (long)mask);
            this.write(currentByte);
            numBits -= 8;
        }
        if (numBits > 0) {
            mask = 255;
            currentByte = (int)(bits << 8 - numBits & (long)mask);
            this.write(currentByte);
            this.seek(this.getStreamPosition() - 1L);
            this.bitOffset = numBits;
        }
    }

    protected final void flushBits() throws IOException {
        this.checkClosed();
        if (this.bitOffset == 0) {
            return;
        }
        int offset = this.bitOffset;
        int currentByte = this.read();
        if (currentByte == -1) {
            currentByte = 0;
            this.bitOffset = 0;
        } else {
            this.seek(this.getStreamPosition() - 1L);
            currentByte &= -1 << 8 - offset;
        }
        this.write(currentByte);
    }
}

