/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageOutputStreamImpl;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class FileImageOutputStream
extends ImageOutputStreamImpl {
    RandomAccessFile file;

    public FileImageOutputStream(File f) throws FileNotFoundException, IOException {
        this(f != null ? new RandomAccessFile(f, "rw") : null);
    }

    public FileImageOutputStream(RandomAccessFile raf) {
        if (raf == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.0C"));
        }
        this.file = raf;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.file.write(b);
        ++this.streamPos;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        this.flushBits();
        this.file.write(b, off, len);
        this.streamPos += (long)len;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        int rt = this.file.read();
        if (rt != -1) {
            ++this.streamPos;
        }
        return rt;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        int rt = this.file.read(b, off, len);
        if (rt != -1) {
            this.streamPos += (long)rt;
        }
        return rt;
    }

    @Override
    public long length() {
        try {
            this.checkClosed();
            return this.file.length();
        }
        catch (IOException e) {
            return super.length();
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.file.seek(pos);
        this.streamPos = this.file.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.file.close();
    }
}

