/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.imageio.stream.ImageInputStreamImpl;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class FileImageInputStream
extends ImageInputStreamImpl {
    RandomAccessFile raf;

    public FileImageInputStream(File f) throws FileNotFoundException, IOException {
        if (f == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.08"));
        }
        this.raf = new RandomAccessFile(f, "r");
    }

    public FileImageInputStream(RandomAccessFile raf) {
        if (raf == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.09"));
        }
        this.raf = raf;
    }

    @Override
    public int read() throws IOException {
        this.bitOffset = 0;
        int res = this.raf.read();
        if (res != -1) {
            ++this.streamPos;
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.bitOffset = 0;
        int numRead = this.raf.read(b, off, len);
        if (numRead >= 0) {
            this.streamPos += (long)numRead;
        }
        return numRead;
    }

    @Override
    public long length() {
        try {
            return this.raf.length();
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < this.getFlushedPosition()) {
            throw new IndexOutOfBoundsException();
        }
        this.raf.seek(pos);
        this.streamPos = this.raf.getFilePointer();
        this.bitOffset = 0;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.raf.close();
    }
}

