/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.awt.image.RenderedImage;
import java.io.IOException;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public abstract class ImageWriterSpi
extends ImageReaderWriterSpi {
    public static final Class[] STANDARD_OUTPUT_TYPE = new Class[]{ImageInputStream.class};
    protected Class[] outputTypes;
    protected String[] readerSpiNames;

    protected ImageWriterSpi() {
    }

    public ImageWriterSpi(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String pluginClassName, Class[] outputTypes, String[] readerSpiNames, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super(vendorName, version, names, suffixes, MIMETypes, pluginClassName, supportsStandardStreamMetadataFormat, nativeStreamMetadataFormatName, nativeStreamMetadataFormatClassName, extraStreamMetadataFormatNames, extraStreamMetadataFormatClassNames, supportsStandardImageMetadataFormat, nativeImageMetadataFormatName, nativeImageMetadataFormatClassName, extraImageMetadataFormatNames, extraImageMetadataFormatClassNames);
        if (outputTypes == null || outputTypes.length == 0) {
            throw new NullPointerException(Messages.getString("imageio.59"));
        }
        this.outputTypes = outputTypes;
        this.readerSpiNames = readerSpiNames;
    }

    public boolean isFormatLossless() {
        return true;
    }

    public Class[] getOutputTypes() {
        return this.outputTypes;
    }

    public abstract boolean canEncodeImage(ImageTypeSpecifier var1);

    public boolean canEncodeImage(RenderedImage im) {
        return this.canEncodeImage(ImageTypeSpecifier.createFromRenderedImage(im));
    }

    public ImageWriter createWriterInstance() throws IOException {
        return this.createWriterInstance(null);
    }

    public abstract ImageWriter createWriterInstance(Object var1) throws IOException;

    public boolean isOwnWriter(ImageWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.96"));
        }
        return writer.getClass().getName().equals(this.pluginClassName);
    }

    public String[] getImageReaderSpiNames() {
        return this.readerSpiNames;
    }
}

