/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.RegisterableService;
import org.apache.harmony.x.imageio.internal.nls.Messages;
import org.apache.harmony.x.imageio.metadata.IIOMetadataUtils;

public abstract class ImageReaderWriterSpi
extends IIOServiceProvider
implements RegisterableService {
    protected String[] names;
    protected String[] suffixes;
    protected String[] MIMETypes;
    protected String pluginClassName;
    protected boolean supportsStandardStreamMetadataFormat;
    protected String nativeStreamMetadataFormatName;
    protected String nativeStreamMetadataFormatClassName;
    protected String[] extraStreamMetadataFormatNames;
    protected String[] extraStreamMetadataFormatClassNames;
    protected boolean supportsStandardImageMetadataFormat;
    protected String nativeImageMetadataFormatName;
    protected String nativeImageMetadataFormatClassName;
    protected String[] extraImageMetadataFormatNames;
    protected String[] extraImageMetadataFormatClassNames;

    public ImageReaderWriterSpi(String vendorName, String version, String[] names, String[] suffixes, String[] MIMETypes, String pluginClassName, boolean supportsStandardStreamMetadataFormat, String nativeStreamMetadataFormatName, String nativeStreamMetadataFormatClassName, String[] extraStreamMetadataFormatNames, String[] extraStreamMetadataFormatClassNames, boolean supportsStandardImageMetadataFormat, String nativeImageMetadataFormatName, String nativeImageMetadataFormatClassName, String[] extraImageMetadataFormatNames, String[] extraImageMetadataFormatClassNames) {
        super(vendorName, version);
        if (names == null || names.length == 0) {
            throw new NullPointerException(Messages.getString("imageio.57"));
        }
        if (pluginClassName == null) {
            throw new NullPointerException(Messages.getString("imageio.58"));
        }
        this.names = (String[])names.clone();
        this.suffixes = suffixes == null ? null : (String[])suffixes.clone();
        this.MIMETypes = MIMETypes == null ? null : (String[])MIMETypes.clone();
        this.pluginClassName = pluginClassName;
        this.supportsStandardStreamMetadataFormat = supportsStandardStreamMetadataFormat;
        this.nativeStreamMetadataFormatName = nativeStreamMetadataFormatName;
        this.nativeStreamMetadataFormatClassName = nativeStreamMetadataFormatClassName;
        this.extraStreamMetadataFormatNames = extraStreamMetadataFormatNames == null ? null : (String[])extraStreamMetadataFormatNames.clone();
        this.extraStreamMetadataFormatClassNames = extraStreamMetadataFormatClassNames == null ? null : (String[])extraStreamMetadataFormatClassNames.clone();
        this.supportsStandardImageMetadataFormat = supportsStandardImageMetadataFormat;
        this.nativeImageMetadataFormatName = nativeImageMetadataFormatName;
        this.nativeImageMetadataFormatClassName = nativeImageMetadataFormatClassName;
        this.extraImageMetadataFormatNames = extraImageMetadataFormatNames == null ? null : (String[])extraImageMetadataFormatNames.clone();
        this.extraImageMetadataFormatClassNames = extraImageMetadataFormatClassNames == null ? null : (String[])extraImageMetadataFormatClassNames.clone();
    }

    public ImageReaderWriterSpi() {
    }

    public String[] getFormatNames() {
        return (String[])this.names.clone();
    }

    public String[] getFileSuffixes() {
        return this.suffixes == null ? null : (String[])this.suffixes.clone();
    }

    public String[] getExtraImageMetadataFormatNames() {
        return this.extraImageMetadataFormatNames == null ? null : (String[])this.extraImageMetadataFormatNames.clone();
    }

    public String[] getExtraStreamMetadataFormatNames() {
        return this.extraStreamMetadataFormatNames == null ? null : (String[])this.extraStreamMetadataFormatNames.clone();
    }

    public IIOMetadataFormat getImageMetadataFormat(String formatName) {
        return IIOMetadataUtils.instantiateMetadataFormat(formatName, this.supportsStandardImageMetadataFormat, this.nativeImageMetadataFormatName, this.nativeImageMetadataFormatClassName, this.extraImageMetadataFormatNames, this.extraImageMetadataFormatClassNames);
    }

    public IIOMetadataFormat getStreamMetadataFormat(String formatName) {
        return IIOMetadataUtils.instantiateMetadataFormat(formatName, this.supportsStandardStreamMetadataFormat, this.nativeStreamMetadataFormatName, this.nativeStreamMetadataFormatClassName, this.extraStreamMetadataFormatNames, this.extraStreamMetadataFormatClassNames);
    }

    public String[] getMIMETypes() {
        return this.MIMETypes == null ? null : (String[])this.MIMETypes.clone();
    }

    public String getNativeImageMetadataFormatName() {
        return this.nativeImageMetadataFormatName;
    }

    public String getNativeStreamMetadataFormatName() {
        return this.nativeStreamMetadataFormatName;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public boolean isStandardImageMetadataFormatSupported() {
        return this.supportsStandardImageMetadataFormat;
    }

    public boolean isStandardStreamMetadataFormatSupported() {
        return this.supportsStandardStreamMetadataFormat;
    }
}

