/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import org.apache.harmony.x.imageio.plugins.gif.GIFImageReaderSpi;
import org.apache.harmony.x.imageio.plugins.jpeg.JPEGImageReaderSpi;
import org.apache.harmony.x.imageio.plugins.jpeg.JPEGImageWriterSpi;
import org.apache.harmony.x.imageio.plugins.png.PNGImageReaderSpi;
import org.apache.harmony.x.imageio.plugins.png.PNGImageWriterSpi;
import org.apache.harmony.x.imageio.spi.FileIISSpi;
import org.apache.harmony.x.imageio.spi.FileIOSSpi;
import org.apache.harmony.x.imageio.spi.InputStreamIISSpi;
import org.apache.harmony.x.imageio.spi.OutputStreamIOSSpi;
import org.apache.harmony.x.imageio.spi.RAFIISSpi;
import org.apache.harmony.x.imageio.spi.RAFIOSSpi;

public final class IIORegistry
extends ServiceRegistry {
    private static Map<ThreadGroup, IIORegistry> instances = Collections.synchronizedMap(new IdentityHashMap());
    private static final Class[] CATEGORIES = new Class[]{ImageWriterSpi.class, ImageReaderSpi.class, ImageInputStreamSpi.class, ImageOutputStreamSpi.class};

    private IIORegistry() {
        super(Arrays.asList(CATEGORIES).iterator());
        this.registerBuiltinSpis();
        this.registerApplicationClasspathSpis();
    }

    private void registerBuiltinSpis() {
        this.registerServiceProvider(new JPEGImageWriterSpi());
        this.registerServiceProvider(new JPEGImageReaderSpi());
        this.registerServiceProvider(new PNGImageReaderSpi());
        this.registerServiceProvider(new PNGImageWriterSpi());
        this.registerServiceProvider(new GIFImageReaderSpi());
        this.registerServiceProvider(new FileIOSSpi());
        this.registerServiceProvider(new FileIISSpi());
        this.registerServiceProvider(new RAFIOSSpi());
        this.registerServiceProvider(new RAFIISSpi());
        this.registerServiceProvider(new OutputStreamIOSSpi());
        this.registerServiceProvider(new InputStreamIISSpi());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static IIORegistry getDefaultInstance() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        Map<ThreadGroup, IIORegistry> map = instances;
        // MONITORENTER : map
        IIORegistry instance = instances.get(tg);
        if (instance == null) {
            Class<IIORegistry> clazz = IIORegistry.class;
            // MONITORENTER : javax.imageio.spi.IIORegistry.class
            instance = new IIORegistry();
            // MONITOREXIT : clazz
            instances.put(tg, instance);
        }
        // MONITOREXIT : map
        return instance;
    }

    public void registerApplicationClasspathSpis() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Iterator<Class<?>> categories = IIORegistry.this.getCategories();
                while (categories.hasNext()) {
                    Iterator<?> providers = ServiceRegistry.lookupProviders(categories.next());
                    IIORegistry.this.registerServiceProviders(providers);
                }
                return this;
            }
        });
    }
}

