/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.jpeg;

import java.util.Locale;
import javax.imageio.ImageWriteParam;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;
import javax.imageio.plugins.jpeg.JPEGQTable;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class JPEGImageWriteParam
extends ImageWriteParam {
    private static final float[] COMP_QUALITY_VALUES = new float[]{0.05f, 0.75f, 0.95f};
    private static final String[] COMP_QUALITY_DESCRIPTIONS = new String[]{"Minimum useful", "Visually lossless", "Maximum useful"};
    private JPEGQTable[] qTables;
    private JPEGHuffmanTable[] dcHuffmanTables;
    private JPEGHuffmanTable[] acHuffmanTables;
    private boolean optimizeHuffmanTables;

    public JPEGImageWriteParam(Locale locale) {
        super(locale);
        this.canWriteProgressive = true;
        this.progressiveMode = 0;
        this.canWriteCompressed = true;
        this.compressionTypes = new String[]{"JPEG"};
        this.compressionType = this.compressionTypes[0];
        this.compressionQuality = 0.75f;
    }

    public boolean areTablesSet() {
        return this.qTables != null;
    }

    public void setEncodeTables(JPEGQTable[] qTables, JPEGHuffmanTable[] DCHuffmanTables, JPEGHuffmanTable[] ACHuffmanTables) {
        if (qTables == null || DCHuffmanTables == null || ACHuffmanTables == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.43"));
        }
        if (DCHuffmanTables.length != ACHuffmanTables.length) {
            throw new IllegalArgumentException(Messages.getString("imageio.43"));
        }
        if (qTables.length > 4 || DCHuffmanTables.length > 4) {
            throw new IllegalArgumentException(Messages.getString("imageio.43"));
        }
        this.qTables = (JPEGQTable[])qTables.clone();
        this.dcHuffmanTables = (JPEGHuffmanTable[])DCHuffmanTables.clone();
        this.acHuffmanTables = (JPEGHuffmanTable[])ACHuffmanTables.clone();
    }

    public void unsetEncodeTables() {
        this.qTables = null;
        this.dcHuffmanTables = null;
        this.acHuffmanTables = null;
    }

    public JPEGHuffmanTable[] getDCHuffmanTables() {
        return this.dcHuffmanTables == null ? null : (JPEGHuffmanTable[])this.dcHuffmanTables.clone();
    }

    public JPEGHuffmanTable[] getACHuffmanTables() {
        return this.acHuffmanTables == null ? null : (JPEGHuffmanTable[])this.acHuffmanTables.clone();
    }

    public JPEGQTable[] getQTables() {
        return this.qTables == null ? null : (JPEGQTable[])this.qTables.clone();
    }

    @Override
    public String[] getCompressionQualityDescriptions() {
        super.getCompressionQualityDescriptions();
        return (String[])COMP_QUALITY_DESCRIPTIONS.clone();
    }

    @Override
    public float[] getCompressionQualityValues() {
        super.getCompressionQualityValues();
        return (float[])COMP_QUALITY_VALUES.clone();
    }

    public void setOptimizeHuffmanTables(boolean optimize) {
        this.optimizeHuffmanTables = optimize;
    }

    public boolean getOptimizeHuffmanTables() {
        return this.optimizeHuffmanTables;
    }

    @Override
    public boolean isCompressionLossless() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException(Messages.getString("imageio.36"));
        }
        return false;
    }

    @Override
    public void unsetCompression() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException(Messages.getString("imageio.36"));
        }
        this.compressionQuality = 0.75f;
    }
}

