/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.metadata;

import java.util.ArrayList;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadataController;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataNode;
import org.apache.harmony.x.imageio.internal.nls.Messages;
import org.apache.harmony.x.imageio.metadata.IIOMetadataUtils;
import org.w3c.dom.Node;

public abstract class IIOMetadata {
    protected boolean standardFormatSupported;
    protected String nativeMetadataFormatName;
    protected String nativeMetadataFormatClassName;
    protected String[] extraMetadataFormatNames;
    protected String[] extraMetadataFormatClassNames;
    protected IIOMetadataController defaultController;
    protected IIOMetadataController controller;

    protected IIOMetadata() {
    }

    protected IIOMetadata(boolean standardMetadataFormatSupported, String nativeMetadataFormatName, String nativeMetadataFormatClassName, String[] extraMetadataFormatNames, String[] extraMetadataFormatClassNames) {
        this.standardFormatSupported = standardMetadataFormatSupported;
        this.nativeMetadataFormatName = nativeMetadataFormatName;
        this.nativeMetadataFormatClassName = nativeMetadataFormatClassName;
        if (extraMetadataFormatNames == null) {
            if (extraMetadataFormatClassNames != null) {
                throw new IllegalArgumentException(Messages.getString("imageio.77"));
            }
        } else {
            if (extraMetadataFormatClassNames == null) {
                throw new IllegalArgumentException(Messages.getString("imageio.78"));
            }
            if (extraMetadataFormatNames.length == 0) {
                throw new IllegalArgumentException(Messages.getString("imageio.79"));
            }
            if (extraMetadataFormatClassNames.length != extraMetadataFormatNames.length) {
                throw new IllegalArgumentException(Messages.getString("imageio.7A"));
            }
            this.extraMetadataFormatNames = (String[])extraMetadataFormatNames.clone();
            this.extraMetadataFormatClassNames = (String[])extraMetadataFormatClassNames.clone();
        }
    }

    public abstract Node getAsTree(String var1);

    public abstract boolean isReadOnly();

    public abstract void mergeTree(String var1, Node var2) throws IIOInvalidTreeException;

    public abstract void reset();

    public IIOMetadataController getController() {
        return this.controller;
    }

    public boolean hasController() {
        return this.getController() != null;
    }

    public boolean activateController() {
        if (!this.hasController()) {
            throw new IllegalStateException(Messages.getString("imageio.7B"));
        }
        return this.getController().activate(this);
    }

    public IIOMetadataController getDefaultController() {
        return this.defaultController;
    }

    public String[] getExtraMetadataFormatNames() {
        return this.extraMetadataFormatNames == null ? null : (String[])this.extraMetadataFormatNames.clone();
    }

    public IIOMetadataFormat getMetadataFormat(String formatName) {
        return IIOMetadataUtils.instantiateMetadataFormat(formatName, this.standardFormatSupported, this.nativeMetadataFormatName, this.nativeMetadataFormatClassName, this.extraMetadataFormatNames, this.extraMetadataFormatClassNames);
    }

    public String getNativeMetadataFormatName() {
        return this.nativeMetadataFormatName;
    }

    public boolean isStandardMetadataFormatSupported() {
        return this.standardFormatSupported;
    }

    public String[] getMetadataFormatNames() {
        ArrayList<String> res = new ArrayList<String>();
        String nativeMetadataFormatName = this.getNativeMetadataFormatName();
        boolean standardFormatSupported = this.isStandardMetadataFormatSupported();
        String[] extraMetadataFormatNames = this.getExtraMetadataFormatNames();
        if (standardFormatSupported) {
            res.add("javax_imageio_1.0");
        }
        if (nativeMetadataFormatName != null) {
            res.add(nativeMetadataFormatName);
        }
        if (extraMetadataFormatNames != null) {
            for (String extraMetadataFormatName : extraMetadataFormatNames) {
                res.add(extraMetadataFormatName);
            }
        }
        return res.size() > 0 ? res.toArray(new String[0]) : null;
    }

    protected IIOMetadataNode getStandardChromaNode() {
        return null;
    }

    protected IIOMetadataNode getStandardCompressionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDataNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDimensionNode() {
        return null;
    }

    protected IIOMetadataNode getStandardDocumentNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTextNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTileNode() {
        return null;
    }

    protected IIOMetadataNode getStandardTransparencyNode() {
        return null;
    }

    protected final IIOMetadataNode getStandardTree() {
        IIOMetadataNode root = new IIOMetadataNode("javax_imageio_1.0");
        IIOMetadataNode node = this.getStandardChromaNode();
        if (node != null) {
            root.appendChild(node);
        }
        if ((node = this.getStandardCompressionNode()) != null) {
            root.appendChild(node);
        }
        if ((node = this.getStandardDataNode()) != null) {
            root.appendChild(node);
        }
        if ((node = this.getStandardDimensionNode()) != null) {
            root.appendChild(node);
        }
        if ((node = this.getStandardDocumentNode()) != null) {
            root.appendChild(node);
        }
        if ((node = this.getStandardTextNode()) != null) {
            root.appendChild(node);
        }
        if ((node = this.getStandardTileNode()) != null) {
            root.appendChild(node);
        }
        if ((node = this.getStandardTransparencyNode()) != null) {
            root.appendChild(node);
        }
        return root;
    }

    public void setController(IIOMetadataController controller) {
        this.controller = controller;
    }

    public void setFromTree(String formatName, Node root) throws IIOInvalidTreeException {
        this.reset();
        this.mergeTree(formatName, root);
    }
}

