/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.util.Locale;
import javax.imageio.IIOParam;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class ImageWriteParam
extends IIOParam {
    public static final int MODE_DISABLED = 0;
    public static final int MODE_DEFAULT = 1;
    public static final int MODE_EXPLICIT = 2;
    public static final int MODE_COPY_FROM_METADATA = 3;
    protected boolean canWriteTiles = false;
    protected int tilingMode = 3;
    protected Dimension[] preferredTileSizes = null;
    protected boolean tilingSet = false;
    protected int tileWidth = 0;
    protected int tileHeight = 0;
    protected boolean canOffsetTiles = false;
    protected int tileGridXOffset = 0;
    protected int tileGridYOffset = 0;
    protected boolean canWriteProgressive = false;
    protected int progressiveMode = 3;
    protected boolean canWriteCompressed = false;
    protected int compressionMode = 3;
    protected String[] compressionTypes = null;
    protected String compressionType = null;
    protected float compressionQuality = 1.0f;
    protected Locale locale = null;

    protected ImageWriteParam() {
    }

    public ImageWriteParam(Locale locale) {
        this.locale = locale;
    }

    public int getProgressiveMode() {
        if (this.canWriteProgressive()) {
            return this.progressiveMode;
        }
        throw new UnsupportedOperationException(Messages.getString("imageio.33"));
    }

    public boolean canWriteProgressive() {
        return this.canWriteProgressive;
    }

    public void setProgressiveMode(int mode) {
        if (this.canWriteProgressive()) {
            if (mode < 0 || mode > 3 || mode == 2) {
                throw new IllegalArgumentException(Messages.getString("imageio.34"));
            }
            this.progressiveMode = mode;
        }
        throw new UnsupportedOperationException(Messages.getString("imageio.33"));
    }

    public boolean canOffsetTiles() {
        return this.canOffsetTiles;
    }

    public boolean canWriteCompressed() {
        return this.canWriteCompressed;
    }

    public boolean canWriteTiles() {
        return this.canWriteTiles;
    }

    private final void checkWriteCompressed() {
        if (!this.canWriteCompressed()) {
            throw new UnsupportedOperationException(Messages.getString("imageio.35"));
        }
    }

    private final void checkCompressionMode() {
        if (this.getCompressionMode() != 2) {
            throw new IllegalStateException(Messages.getString("imageio.36"));
        }
    }

    private final void checkCompressionType() {
        if (this.getCompressionTypes() != null && this.getCompressionType() == null) {
            throw new IllegalStateException(Messages.getString("imageio.37"));
        }
    }

    public int getCompressionMode() {
        this.checkWriteCompressed();
        return this.compressionMode;
    }

    public String[] getCompressionTypes() {
        this.checkWriteCompressed();
        if (this.compressionTypes != null) {
            return (String[])this.compressionTypes.clone();
        }
        return null;
    }

    public String getCompressionType() {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        return this.compressionType;
    }

    public float getBitRate(float quality) {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        this.checkCompressionType();
        if (quality < 0.0f || quality > 1.0f) {
            throw new IllegalArgumentException(Messages.getString("imageio.38"));
        }
        return -1.0f;
    }

    public float getCompressionQuality() {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        this.checkCompressionType();
        return this.compressionQuality;
    }

    public String[] getCompressionQualityDescriptions() {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        this.checkCompressionType();
        return null;
    }

    public float[] getCompressionQualityValues() {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        this.checkCompressionType();
        return null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLocalizedCompressionTypeName() {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        String compressionType = this.getCompressionType();
        if (compressionType == null) {
            throw new IllegalStateException(Messages.getString("imageio.37"));
        }
        return compressionType;
    }

    private final void checkTiling() {
        if (!this.canWriteTiles()) {
            throw new UnsupportedOperationException(Messages.getString("imageio.39"));
        }
    }

    private final void checkTilingMode() {
        if (this.getTilingMode() != 2) {
            throw new IllegalStateException(Messages.getString("imageio.3A"));
        }
    }

    private final void checkTilingParams() {
        if (!this.tilingSet) {
            throw new IllegalStateException(Messages.getString("imageio.3B"));
        }
    }

    public int getTilingMode() {
        this.checkTiling();
        return this.tilingMode;
    }

    public Dimension[] getPreferredTileSizes() {
        this.checkTiling();
        if (this.preferredTileSizes == null) {
            return null;
        }
        Dimension[] retval = new Dimension[this.preferredTileSizes.length];
        for (int i = 0; i < this.preferredTileSizes.length; ++i) {
            retval[i] = new Dimension(retval[i]);
        }
        return retval;
    }

    public int getTileGridXOffset() {
        this.checkTiling();
        this.checkTilingMode();
        this.checkTilingParams();
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        this.checkTiling();
        this.checkTilingMode();
        this.checkTilingParams();
        return this.tileGridYOffset;
    }

    public int getTileHeight() {
        this.checkTiling();
        this.checkTilingMode();
        this.checkTilingParams();
        return this.tileHeight;
    }

    public int getTileWidth() {
        this.checkTiling();
        this.checkTilingMode();
        this.checkTilingParams();
        return this.tileWidth;
    }

    public boolean isCompressionLossless() {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        this.checkCompressionType();
        return true;
    }

    public void unsetCompression() {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        this.compressionType = null;
        this.compressionQuality = 1.0f;
    }

    public void setCompressionMode(int mode) {
        this.checkWriteCompressed();
        switch (mode) {
            case 2: {
                this.compressionMode = mode;
                this.unsetCompression();
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                this.compressionMode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("imageio.3C"));
            }
        }
    }

    public void setCompressionQuality(float quality) {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        this.checkCompressionType();
        if (quality < 0.0f || quality > 1.0f) {
            throw new IllegalArgumentException(Messages.getString("imageio.38"));
        }
        this.compressionQuality = quality;
    }

    public void setCompressionType(String compressionType) {
        this.checkWriteCompressed();
        this.checkCompressionMode();
        if (compressionType != null) {
            String[] compressionTypes = this.getCompressionTypes();
            if (compressionTypes == null) {
                throw new UnsupportedOperationException(Messages.getString("imageio.3D"));
            }
            for (int i = 0; i < compressionTypes.length; ++i) {
                if (!compressionTypes[i].equals(compressionType)) continue;
                this.compressionType = compressionType;
                return;
            }
            throw new IllegalArgumentException(Messages.getString("imageio.3E"));
        }
        this.compressionType = null;
    }

    public void setTiling(int tileWidth, int tileHeight, int tileGridXOffset, int tileGridYOffset) {
        this.checkTiling();
        this.checkTilingMode();
        if (!(this.canOffsetTiles() || tileGridXOffset == 0 && tileGridYOffset == 0)) {
            throw new UnsupportedOperationException(Messages.getString("imageio.3F"));
        }
        if (tileWidth <= 0 || tileHeight <= 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.40"));
        }
        Dimension[] preferredTileSizes = this.getPreferredTileSizes();
        if (preferredTileSizes != null) {
            for (int i = 0; i < preferredTileSizes.length; i += 2) {
                Dimension minSize = preferredTileSizes[i];
                Dimension maxSize = preferredTileSizes[i + 1];
                if (tileWidth >= minSize.width && tileWidth <= maxSize.width && tileHeight >= minSize.height && tileHeight <= maxSize.height) continue;
                throw new IllegalArgumentException(Messages.getString("imageio.41"));
            }
        }
        this.tilingSet = true;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.tileGridXOffset = tileGridXOffset;
        this.tileGridYOffset = tileGridYOffset;
    }

    public void unsetTiling() {
        this.checkTiling();
        this.checkTilingMode();
        this.tilingSet = false;
        this.tileWidth = 0;
        this.tileHeight = 0;
        this.tileGridXOffset = 0;
        this.tileGridYOffset = 0;
    }

    public void setTilingMode(int mode) {
        this.checkTiling();
        switch (mode) {
            case 2: {
                this.tilingMode = mode;
                this.unsetTiling();
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                this.tilingMode = mode;
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("imageio.3C"));
            }
        }
    }
}

