/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
        if (colorModel == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.24"));
        }
        if (sampleModel == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.25"));
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            throw new IllegalArgumentException(Messages.getString("imageio.26"));
        }
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public ImageTypeSpecifier(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.27"));
        }
        this.colorModel = renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int redMask, int greenMask, int blueMask, int alphaMask, int transferType, boolean isAlphaPremultiplied) {
        DirectColorModel model = new DirectColorModel(colorSpace, 32, redMask, greenMask, blueMask, alphaMask, isAlphaPremultiplied, transferType);
        return new ImageTypeSpecifier(model, ((ColorModel)model).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
        if (colorSpace == null) {
            throw new IllegalArgumentException();
        }
        if (bandOffsets == null) {
            throw new IllegalArgumentException();
        }
        if (dataType != 0 && dataType != 5 && dataType != 4 && dataType != 3 && dataType != 2 && dataType != 1) {
            throw new IllegalArgumentException();
        }
        int numComponents = colorSpace.getNumComponents();
        if (hasAlpha) {
            ++numComponents;
        }
        if (bandOffsets.length != numComponents) {
            throw new IllegalArgumentException();
        }
        int transparency = hasAlpha ? 3 : 1;
        int[] bits = new int[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            bits[i] = DataBuffer.getDataTypeSize(dataType);
        }
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, bits, hasAlpha, isAlphaPremultiplied, transparency, dataType);
        int minBandOffset = bandOffsets[0];
        int maxBandOffset = bandOffsets[0];
        for (int i = 0; i < bandOffsets.length; ++i) {
            if (minBandOffset > bandOffsets[i]) {
                minBandOffset = bandOffsets[i];
            }
            if (maxBandOffset >= bandOffsets[i]) continue;
            maxBandOffset = bandOffsets[i];
        }
        int pixelStride = maxBandOffset - minBandOffset + 1;
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(dataType, 1, 1, pixelStride, pixelStride, bandOffsets);
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] bankIndices, int[] bandOffsets, int dataType, boolean hasAlpha, boolean isAlphaPremultiplied) {
        if (colorSpace == null) {
            throw new IllegalArgumentException();
        }
        if (bankIndices == null) {
            throw new IllegalArgumentException();
        }
        if (bandOffsets == null) {
            throw new IllegalArgumentException();
        }
        if (bankIndices.length != bandOffsets.length) {
            throw new IllegalArgumentException();
        }
        int numComponents = colorSpace.getNumComponents();
        if (hasAlpha) {
            ++numComponents;
        }
        if (bandOffsets.length != numComponents) {
            throw new IllegalArgumentException();
        }
        if (dataType != 0 && dataType != 5 && dataType != 4 && dataType != 3 && dataType != 2 && dataType != 1) {
            throw new IllegalArgumentException();
        }
        int[] bits = new int[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            bits[i] = DataBuffer.getDataTypeSize(dataType);
        }
        int transparency = hasAlpha ? 3 : 1;
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, bits, hasAlpha, isAlphaPremultiplied, transparency, dataType);
        BandedSampleModel sampleModel = new BandedSampleModel(dataType, 1, 1, 1, bankIndices, bandOffsets);
        return new ImageTypeSpecifier(colorModel, sampleModel);
    }

    public static ImageTypeSpecifier createGrayscale(int bits, int dataType, boolean isSigned) {
        return ImageTypeSpecifier.createGrayscale(bits, dataType, isSigned, false, false);
    }

    public static ImageTypeSpecifier createGrayscale(int bits, int dataType, boolean isSigned, boolean isAlphaPremultiplied) {
        return ImageTypeSpecifier.createGrayscale(bits, dataType, isSigned, true, isAlphaPremultiplied);
    }

    private static ImageTypeSpecifier createGrayscale(int bits, int dataType, boolean isSigned, boolean hasAlpha, boolean isAlphaPremultiplied) {
        if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
            throw new IllegalArgumentException();
        }
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int numComponent = hasAlpha ? 2 : 1;
        int[] numBits = new int[numComponent];
        numBits[0] = bits;
        if (numComponent == 2) {
            numBits[1] = bits;
        }
        int transparency = hasAlpha ? 3 : 1;
        ComponentColorModel model = new ComponentColorModel(colorSpace, numBits, hasAlpha, isAlphaPremultiplied, transparency, dataType);
        return new ImageTypeSpecifier(model, ((ColorModel)model).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createIndexed(byte[] redLUT, byte[] greenLUT, byte[] blueLUT, byte[] alphaLUT, int bits, int dataType) {
        if (redLUT == null || greenLUT == null || blueLUT == null) {
            throw new IllegalArgumentException();
        }
        if (bits != 1 && bits != 2 && bits != 4 && bits != 8 && bits != 16) {
            throw new IllegalArgumentException();
        }
        int length = 1 << bits;
        if (redLUT.length != length || greenLUT.length != length || blueLUT.length != length || alphaLUT != null && alphaLUT.length != length) {
            throw new IllegalArgumentException();
        }
        if (dataType != 0 && dataType != 2 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException();
        }
        if (bits > 8 && dataType == 0 || bits > 16 && dataType == 3) {
            throw new IllegalArgumentException();
        }
        IndexColorModel model = null;
        int size = redLUT.length;
        model = alphaLUT == null ? new IndexColorModel(bits, size, redLUT, greenLUT, blueLUT) : new IndexColorModel(bits, size, redLUT, greenLUT, blueLUT, alphaLUT);
        return new ImageTypeSpecifier(model, ((ColorModel)model).createCompatibleSampleModel(1, 1));
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int bufferedImageType) {
        switch (bufferedImageType) {
            case 1: {
                return ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, 0, 3, false);
            }
            case 2: {
                return ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, -16777216, 3, false);
            }
            case 3: {
                return ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, -16777216, 3, true);
            }
            case 4: {
                return ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 0xFF0000, 65280, 255, 0, 3, false);
            }
            case 5: {
                return ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), new int[]{2, 1, 0}, 0, false, false);
            }
            case 6: {
                return ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), new int[]{3, 2, 1, 0}, 0, true, false);
            }
            case 7: {
                return ImageTypeSpecifier.createInterleaved(ColorSpace.getInstance(1000), new int[]{3, 2, 1, 0}, 0, true, true);
            }
            case 8: {
                return ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 63488, 2016, 31, 0, 1, false);
            }
            case 9: {
                return ImageTypeSpecifier.createPacked(ColorSpace.getInstance(1000), 31744, 992, 31, 0, 1, false);
            }
            case 10: {
                return ImageTypeSpecifier.createGrayscale(8, 0, false);
            }
            case 11: {
                return ImageTypeSpecifier.createGrayscale(16, 1, false);
            }
            case 12: {
                byte[] redLUT = new byte[]{0, -1};
                byte[] greenLUT = new byte[]{0, -1};
                byte[] blueLUT = new byte[]{0, -1};
                return ImageTypeSpecifier.createIndexed(redLUT, greenLUT, blueLUT, null, 1, 0);
            }
            case 13: {
                BufferedImage bufferedImage = new BufferedImage(1, 1, 13);
                IndexColorModel colorModel = (IndexColorModel)bufferedImage.getColorModel();
                byte[] redLUT = new byte[256];
                byte[] greenLUT = new byte[256];
                byte[] blueLUT = new byte[256];
                byte[] alphaLUT = new byte[256];
                colorModel.getReds(redLUT);
                colorModel.getGreens(greenLUT);
                colorModel.getBlues(blueLUT);
                colorModel.getAlphas(alphaLUT);
                return ImageTypeSpecifier.createIndexed(redLUT, greenLUT, blueLUT, alphaLUT, 8, 0);
            }
        }
        throw new IllegalArgumentException();
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage image) {
        if (null == image) {
            throw new IllegalArgumentException(Messages.getString("imageio.27"));
        }
        return new ImageTypeSpecifier(image);
    }

    public int getBufferedImageType() {
        BufferedImage bufferedImage = this.createBufferedImage(1, 1);
        return bufferedImage.getType();
    }

    public int getNumComponents() {
        return this.colorModel.getNumComponents();
    }

    public int getNumBands() {
        return this.sampleModel.getNumBands();
    }

    public int getBitsPerBand(int band) {
        if (band < 0 || band >= this.getNumBands()) {
            throw new IllegalArgumentException();
        }
        return this.sampleModel.getSampleSize(band);
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public SampleModel getSampleModel(int width, int height) {
        if ((long)width * (long)height > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(Messages.getString("imageio.28"));
        }
        return this.sampleModel.createCompatibleSampleModel(width, height);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public BufferedImage createBufferedImage(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException();
        }
        if ((long)width * (long)height > Integer.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        SampleModel sm = this.sampleModel.createCompatibleSampleModel(width, height);
        WritableRaster writableRaster = Raster.createWritableRaster(sm, new Point(0, 0));
        return new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
    }

    public boolean equals(Object o) {
        boolean rt = false;
        if (o instanceof ImageTypeSpecifier) {
            ImageTypeSpecifier ts = (ImageTypeSpecifier)o;
            rt = this.colorModel.equals(ts.colorModel) && this.sampleModel.equals(ts.sampleModel);
        }
        return rt;
    }

    public int hashCode() {
        return this.colorModel.hashCode() + this.sampleModel.hashCode();
    }
}

