/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.imageio.IIOParam;
import javax.imageio.ImageTypeSpecifier;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class ImageReadParam
extends IIOParam {
    protected boolean canSetSourceRenderSize;
    protected BufferedImage destination;
    protected int[] destinationBands;
    protected int minProgressivePass;
    protected int numProgressivePasses;
    protected Dimension sourceRenderSize;

    public boolean canSetSourceRenderSize() {
        return this.canSetSourceRenderSize;
    }

    public BufferedImage getDestination() {
        return this.destination;
    }

    public int[] getDestinationBands() {
        return this.destinationBands;
    }

    public int getSourceMaxProgressivePass() {
        if (this.getSourceNumProgressivePasses() == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return this.getSourceMinProgressivePass() + this.getSourceNumProgressivePasses() - 1;
    }

    public int getSourceMinProgressivePass() {
        return this.minProgressivePass;
    }

    public int getSourceNumProgressivePasses() {
        return this.numProgressivePasses;
    }

    public Dimension getSourceRenderSize() {
        return this.sourceRenderSize;
    }

    public void setDestination(BufferedImage destination) {
        this.destination = destination;
    }

    public void setDestinationBands(int[] destinationBands) {
        this.destinationBands = destinationBands;
    }

    @Override
    public void setDestinationType(ImageTypeSpecifier destinationType) {
        this.destinationType = destinationType;
    }

    public void setSourceProgressivePasses(int minPass, int numPasses) {
        this.minProgressivePass = minPass;
        this.numProgressivePasses = numPasses;
    }

    public void setSourceRenderSize(Dimension size) throws UnsupportedOperationException {
        if (!this.canSetSourceRenderSize) {
            throw new UnsupportedOperationException(Messages.getString("imageio.29"));
        }
        this.sourceRenderSize = size;
    }
}

