/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageReader;
import javax.imageio.ImageTranscoder;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.apache.harmony.luni.util.NotImplementedException;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public final class ImageIO {
    private static final IIORegistry registry = IIORegistry.getDefaultInstance();
    private static final Cache cacheInfo = new Cache();

    private ImageIO() {
    }

    public static void scanForPlugins() {
        registry.registerApplicationClasspathSpis();
    }

    public static void setUseCache(boolean useCache) {
        cacheInfo.setUseCache(useCache);
    }

    public static boolean getUseCache() {
        return cacheInfo.getUseCache();
    }

    public static void setCacheDirectory(File cacheDirectory) {
        cacheInfo.setCacheDirectory(cacheDirectory);
    }

    public static File getCacheDirectory() {
        return cacheInfo.getCacheDirectory();
    }

    public static ImageInputStream createImageInputStream(Object input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.4C"));
        }
        Iterator<ImageInputStreamSpi> it = registry.getServiceProviders(ImageInputStreamSpi.class, true);
        while (it.hasNext()) {
            ImageInputStreamSpi spi = it.next();
            if (!spi.getInputClass().isInstance(input)) continue;
            return ImageIO.getUseCache() ? spi.createInputStreamInstance(input, true, ImageIO.getCacheDirectory()) : spi.createInputStreamInstance(input);
        }
        return null;
    }

    public static ImageOutputStream createImageOutputStream(Object output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.4D"));
        }
        Iterator<ImageOutputStreamSpi> it = registry.getServiceProviders(ImageOutputStreamSpi.class, true);
        while (it.hasNext()) {
            ImageOutputStreamSpi spi = it.next();
            if (!spi.getOutputClass().isInstance(output)) continue;
            return ImageIO.getUseCache() ? spi.createOutputStreamInstance(output, true, ImageIO.getCacheDirectory()) : spi.createOutputStreamInstance(output);
        }
        return null;
    }

    public static String[] getReaderFormatNames() {
        ArrayList<String> FormatNames = new ArrayList<String>();
        Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, true);
        while (it.hasNext()) {
            ImageReaderSpi spi = it.next();
            FormatNames.addAll(Arrays.asList(spi.getFormatNames()));
        }
        return FormatNames.toArray(new String[FormatNames.size()]);
    }

    public static String[] getReaderMIMETypes() {
        ArrayList<String> MIMETypes = new ArrayList<String>();
        Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, true);
        while (it.hasNext()) {
            ImageReaderSpi spi = it.next();
            MIMETypes.addAll(Arrays.asList(spi.getMIMETypes()));
        }
        return MIMETypes.toArray(new String[MIMETypes.size()]);
    }

    public static Iterator<ImageReader> getImageReaders(Object input) {
        if (input == null) {
            throw new NullPointerException(Messages.getString("imageio.4E"));
        }
        Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, new CanReadFilter(input), true);
        return new SpiIteratorToReadersIteratorWrapper(it);
    }

    public static Iterator<ImageReader> getImageReadersByFormatName(String formatName) {
        if (formatName == null) {
            throw new NullPointerException(Messages.getString("imageio.4F"));
        }
        Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, new FormatFilter(formatName), true);
        return new SpiIteratorToReadersIteratorWrapper(it);
    }

    public static Iterator<ImageReader> getImageReadersBySuffix(String fileSuffix) {
        if (fileSuffix == null) {
            throw new NullPointerException(Messages.getString("imageio.50"));
        }
        Iterator<ImageReaderSpi> it = registry.getServiceProviders(ImageReaderSpi.class, new SuffixFilter(fileSuffix), true);
        return new SpiIteratorToReadersIteratorWrapper(it);
    }

    public static Iterator<ImageReader> getImageReadersByMIMEType(String MIMEType) {
        return new SpiIteratorToReadersIteratorWrapper(registry.getServiceProviders(ImageReaderSpi.class, new MIMETypeFilter(MIMEType), true));
    }

    public static String[] getWriterFormatNames() {
        ArrayList<String> FormatNames = new ArrayList<String>();
        Iterator<ImageWriterSpi> it = registry.getServiceProviders(ImageWriterSpi.class, true);
        while (it.hasNext()) {
            ImageWriterSpi spi = it.next();
            FormatNames.addAll(Arrays.asList(spi.getFormatNames()));
        }
        return FormatNames.toArray(new String[FormatNames.size()]);
    }

    public static String[] getWriterMIMETypes() {
        ArrayList<String> MIMETypes = new ArrayList<String>();
        Iterator<ImageWriterSpi> it = registry.getServiceProviders(ImageWriterSpi.class, true);
        while (it.hasNext()) {
            ImageWriterSpi spi = it.next();
            MIMETypes.addAll(Arrays.asList(spi.getMIMETypes()));
        }
        return MIMETypes.toArray(new String[MIMETypes.size()]);
    }

    public static Iterator<ImageWriter> getImageWritersByFormatName(String formatName) {
        if (formatName == null) {
            throw new NullPointerException(Messages.getString("imageio.4F"));
        }
        Iterator<ImageWriterSpi> it = registry.getServiceProviders(ImageWriterSpi.class, new FormatFilter(formatName), true);
        return new SpiIteratorToWritersIteratorWrapper(it);
    }

    public static Iterator<ImageWriter> getImageWritersBySuffix(String fileSuffix) {
        if (fileSuffix == null) {
            throw new NullPointerException(Messages.getString("imageio.50"));
        }
        Iterator<ImageWriterSpi> it = registry.getServiceProviders(ImageWriterSpi.class, new SuffixFilter(fileSuffix), true);
        return new SpiIteratorToWritersIteratorWrapper(it);
    }

    public static Iterator<ImageWriter> getImageWritersByMIMEType(String MIMEType) {
        return new SpiIteratorToWritersIteratorWrapper(registry.getServiceProviders(ImageWriterSpi.class, new MIMETypeFilter(MIMEType), true));
    }

    public static ImageWriter getImageWriter(ImageReader reader) {
        if (reader == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.97"));
        }
        ImageReaderSpi readerSpi = reader.getOriginatingProvider();
        if (readerSpi.getImageWriterSpiNames() == null) {
            return null;
        }
        String writerSpiName = readerSpi.getImageWriterSpiNames()[0];
        Iterator<ImageWriterSpi> writerSpis = registry.getServiceProviders(ImageWriterSpi.class, true);
        try {
            while (writerSpis.hasNext()) {
                ImageWriterSpi writerSpi = writerSpis.next();
                if (!writerSpi.getClass().getName().equals(writerSpiName)) continue;
                return writerSpi.createWriterInstance();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static ImageReader getImageReader(ImageWriter writer) {
        if (writer == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.96"));
        }
        ImageWriterSpi writerSpi = writer.getOriginatingProvider();
        if (writerSpi.getImageReaderSpiNames() == null) {
            return null;
        }
        String readerSpiName = writerSpi.getImageReaderSpiNames()[0];
        Iterator<ImageReaderSpi> readerSpis = registry.getServiceProviders(ImageReaderSpi.class, true);
        try {
            while (readerSpis.hasNext()) {
                ImageReaderSpi readerSpi = readerSpis.next();
                if (!readerSpi.getClass().getName().equals(readerSpiName)) continue;
                return readerSpi.createReaderInstance();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static Iterator<ImageWriter> getImageWriters(ImageTypeSpecifier type, String formatName) {
        if (type == null) {
            throw new NullPointerException(Messages.getString("imageio.51"));
        }
        if (formatName == null) {
            throw new NullPointerException(Messages.getString("imageio.4F"));
        }
        Iterator<ImageWriterSpi> it = registry.getServiceProviders(ImageWriterSpi.class, new FormatAndEncodeFilter(type, formatName), true);
        return new SpiIteratorToWritersIteratorWrapper(it);
    }

    public static Iterator<ImageTranscoder> getImageTranscoders(ImageReader reader, ImageWriter writer) throws NotImplementedException {
        throw new NotImplementedException();
    }

    public static BufferedImage read(File input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.52"));
        }
        try {
            return Imaging.getBufferedImage(input);
        }
        catch (ImageReadException e) {
            throw new IOException(e);
        }
    }

    public static BufferedImage read(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.52"));
        }
        try {
            return Imaging.getBufferedImage(input);
        }
        catch (ImageReadException e) {
            throw new IOException(e);
        }
    }

    public static BufferedImage read(URL input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.52"));
        }
        InputStream stream = input.openStream();
        BufferedImage res = ImageIO.read(stream);
        stream.close();
        return res;
    }

    public static BufferedImage read(ImageInputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.0A"));
        }
        Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
        if (!imageReaders.hasNext()) {
            return null;
        }
        ImageReader reader = imageReaders.next();
        reader.setInput(stream, false, true);
        BufferedImage res = reader.read(0);
        reader.dispose();
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res;
    }

    public static boolean write(RenderedImage im, String formatName, ImageOutputStream output) throws IOException {
        if (im == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.53"));
        }
        if (formatName == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.4F"));
        }
        if (output == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.54"));
        }
        Iterator<ImageWriter> it = ImageIO.getImageWriters(ImageTypeSpecifier.createFromRenderedImage(im), formatName);
        if (it.hasNext()) {
            ImageWriter writer = it.next();
            writer.setOutput(output);
            writer.write(im);
            output.flush();
            writer.dispose();
            return true;
        }
        return false;
    }

    public static boolean write(RenderedImage im, String formatName, File output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.54"));
        }
        if (output.exists()) {
            output.delete();
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(output);
        boolean rt = ImageIO.write(im, formatName, ios);
        ios.close();
        return rt;
    }

    public static boolean write(RenderedImage im, String formatName, OutputStream output) throws IOException {
        if (output == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.54"));
        }
        ImageOutputStream ios = ImageIO.createImageOutputStream(output);
        boolean rt = ImageIO.write(im, formatName, ios);
        ios.close();
        return rt;
    }

    static class SpiIteratorToReadersIteratorWrapper
    implements Iterator<ImageReader> {
        private Iterator<ImageReaderSpi> backend;

        public SpiIteratorToReadersIteratorWrapper(Iterator<ImageReaderSpi> backend) {
            this.backend = backend;
        }

        @Override
        public ImageReader next() {
            try {
                return this.backend.next().createReaderInstance();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.backend.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Messages.getString("imageio.56"));
        }
    }

    static class SpiIteratorToWritersIteratorWrapper
    implements Iterator<ImageWriter> {
        private Iterator<ImageWriterSpi> backend;

        public SpiIteratorToWritersIteratorWrapper(Iterator<ImageWriterSpi> backend) {
            this.backend = backend;
        }

        @Override
        public ImageWriter next() {
            try {
                return this.backend.next().createWriterInstance();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.backend.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException(Messages.getString("imageio.56"));
        }
    }

    static class CanReadFilter
    implements ServiceRegistry.Filter {
        private Object input;

        public CanReadFilter(Object input) {
            this.input = input;
        }

        @Override
        public boolean filter(Object provider) {
            ImageReaderSpi spi = (ImageReaderSpi)provider;
            try {
                return spi.canDecodeInput(this.input);
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    static class MIMETypeFilter
    implements ServiceRegistry.Filter {
        private final String mimeType;

        public MIMETypeFilter(String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException(Messages.getString("imageio.55"));
            }
            this.mimeType = mimeType;
        }

        @Override
        public boolean filter(Object provider) {
            String[] types = ((ImageReaderWriterSpi)provider).getMIMETypes();
            return types != null && Arrays.asList(types).contains(this.mimeType);
        }
    }

    static class SuffixFilter
    implements ServiceRegistry.Filter {
        private String suf;

        public SuffixFilter(String suf) {
            this.suf = suf;
        }

        @Override
        public boolean filter(Object provider) {
            ImageReaderWriterSpi spi = (ImageReaderWriterSpi)provider;
            return Arrays.asList(spi.getFileSuffixes()).contains(this.suf);
        }
    }

    static class FormatAndEncodeFilter
    extends FormatFilter {
        private ImageTypeSpecifier type;

        public FormatAndEncodeFilter(ImageTypeSpecifier type, String name) {
            super(name);
            this.type = type;
        }

        @Override
        public boolean filter(Object provider) {
            ImageWriterSpi spi = (ImageWriterSpi)provider;
            return super.filter(provider) && spi.canEncodeImage(this.type);
        }
    }

    static class FormatFilter
    implements ServiceRegistry.Filter {
        private String name;

        public FormatFilter(String name) {
            this.name = name;
        }

        @Override
        public boolean filter(Object provider) {
            ImageReaderWriterSpi spi = (ImageReaderWriterSpi)provider;
            return Arrays.asList(spi.getFormatNames()).contains(this.name);
        }
    }

    private static class Cache {
        private boolean useCache = false;
        private File cacheDirectory = null;

        public File getCacheDirectory() {
            return this.cacheDirectory;
        }

        public void setCacheDirectory(File cacheDirectory) {
            if (cacheDirectory != null && !cacheDirectory.isDirectory()) {
                throw new IllegalArgumentException(Messages.getString("imageio.0B"));
            }
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                String filepath = cacheDirectory == null ? System.getProperty("java.io.tmpdir") : cacheDirectory.getPath();
                security.checkWrite(filepath);
            }
            this.cacheDirectory = cacheDirectory;
        }

        public boolean getUseCache() {
            return this.useCache;
        }

        public void setUseCache(boolean useCache) {
            this.useCache = useCache;
        }
    }
}

