/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.Rectangle;
import javax.imageio.IIOParamController;
import javax.imageio.ImageTypeSpecifier;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public abstract class IIOParam {
    protected Rectangle sourceRegion;
    protected int sourceXSubsampling = 1;
    protected int sourceYSubsampling = 1;
    protected int subsamplingXOffset;
    protected int subsamplingYOffset;
    protected int[] sourceBands;
    protected ImageTypeSpecifier destinationType;
    protected Point destinationOffset = new Point(0, 0);
    protected IIOParamController defaultController;
    protected IIOParamController controller;

    protected IIOParam() {
    }

    public void setSourceRegion(Rectangle sourceRegion) {
        if (sourceRegion != null) {
            if (sourceRegion.x < 0) {
                throw new IllegalArgumentException(Messages.getString("imageio.15"));
            }
            if (sourceRegion.y < 0) {
                throw new IllegalArgumentException(Messages.getString("imageio.16"));
            }
            if (sourceRegion.width <= 0) {
                throw new IllegalArgumentException(Messages.getString("imageio.17"));
            }
            if (sourceRegion.height <= 0) {
                throw new IllegalArgumentException(Messages.getString("imageio.18"));
            }
            if (sourceRegion.width <= this.subsamplingXOffset) {
                throw new IllegalArgumentException(Messages.getString("imageio.19"));
            }
            if (sourceRegion.height <= this.subsamplingYOffset) {
                throw new IllegalArgumentException(Messages.getString("imageio.1A"));
            }
            this.sourceRegion = (Rectangle)sourceRegion.clone();
        } else {
            this.sourceRegion = null;
        }
    }

    public Rectangle getSourceRegion() {
        if (this.sourceRegion == null) {
            return null;
        }
        return (Rectangle)this.sourceRegion.clone();
    }

    public void setSourceSubsampling(int sourceXSubsampling, int sourceYSubsampling, int subsamplingXOffset, int subsamplingYOffset) {
        if (sourceXSubsampling <= 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.1B"));
        }
        if (sourceYSubsampling <= 0) {
            throw new IllegalArgumentException(Messages.getString("imageio.1C"));
        }
        if (subsamplingXOffset < 0 || subsamplingXOffset >= sourceXSubsampling) {
            throw new IllegalArgumentException(Messages.getString("imageio.1D"));
        }
        if (subsamplingYOffset < 0 || subsamplingYOffset >= sourceYSubsampling) {
            throw new IllegalArgumentException(Messages.getString("imageio.1E"));
        }
        if (this.sourceRegion != null && (this.sourceRegion.width <= subsamplingXOffset || this.sourceRegion.height <= subsamplingYOffset)) {
            throw new IllegalArgumentException(Messages.getString("imageio.1F"));
        }
        this.sourceXSubsampling = sourceXSubsampling;
        this.sourceYSubsampling = sourceYSubsampling;
        this.subsamplingXOffset = subsamplingXOffset;
        this.subsamplingYOffset = subsamplingYOffset;
    }

    public int getSourceXSubsampling() {
        return this.sourceXSubsampling;
    }

    public int getSourceYSubsampling() {
        return this.sourceYSubsampling;
    }

    public int getSubsamplingXOffset() {
        return this.subsamplingXOffset;
    }

    public int getSubsamplingYOffset() {
        return this.subsamplingYOffset;
    }

    public void setSourceBands(int[] sourceBands) {
        if (sourceBands == null) {
            this.sourceBands = null;
        } else {
            for (int i = 0; i < sourceBands.length; ++i) {
                if (sourceBands[i] < 0) {
                    throw new IllegalArgumentException(Messages.getString("imageio.20"));
                }
                for (int j = i + 1; j < sourceBands.length; ++j) {
                    if (sourceBands[i] != sourceBands[j]) continue;
                    throw new IllegalArgumentException(Messages.getString("imageio.21"));
                }
            }
            this.sourceBands = (int[])sourceBands.clone();
        }
    }

    public int[] getSourceBands() {
        return this.sourceBands != null ? (int[])this.sourceBands.clone() : null;
    }

    public void setDestinationType(ImageTypeSpecifier destinationType) {
        this.destinationType = destinationType;
    }

    public ImageTypeSpecifier getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationOffset(Point destinationOffset) {
        if (destinationOffset == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.22"));
        }
        this.destinationOffset = (Point)destinationOffset.clone();
    }

    public Point getDestinationOffset() {
        return (Point)this.destinationOffset.clone();
    }

    public void setController(IIOParamController controller) {
        this.controller = controller;
    }

    public IIOParamController getController() {
        return this.controller;
    }

    public IIOParamController getDefaultController() {
        return this.defaultController;
    }

    public boolean hasController() {
        return this.controller != null;
    }

    public boolean activateController() {
        IIOParamController controller = this.getController();
        if (controller == null) {
            throw new IllegalStateException(Messages.getString("imageio.23"));
        }
        return controller.activate(this);
    }
}

