/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.List;
import javax.imageio.metadata.IIOMetadata;
import org.apache.harmony.x.imageio.internal.nls.Messages;

public class IIOImage {
    protected RenderedImage image;
    protected Raster raster;
    protected List<? extends BufferedImage> thumbnails;
    protected IIOMetadata metadata;

    public IIOImage(RenderedImage image, List<? extends BufferedImage> thumbnails, IIOMetadata metadata) {
        if (image == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.27"));
        }
        this.raster = null;
        this.image = image;
        this.thumbnails = thumbnails;
        this.metadata = metadata;
    }

    public IIOImage(Raster raster, List<? extends BufferedImage> thumbnails, IIOMetadata metadata) {
        if (raster == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.5F"));
        }
        this.image = null;
        this.raster = raster;
        this.thumbnails = thumbnails;
        this.metadata = metadata;
    }

    public RenderedImage getRenderedImage() {
        return this.image;
    }

    public void setRenderedImage(RenderedImage image) {
        if (image == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.27"));
        }
        this.raster = null;
        this.image = image;
    }

    public boolean hasRaster() {
        return this.raster != null;
    }

    public Raster getRaster() {
        return this.raster;
    }

    public void setRaster(Raster raster) {
        if (raster == null) {
            throw new IllegalArgumentException(Messages.getString("imageio.5F"));
        }
        this.image = null;
        this.raster = raster;
    }

    public int getNumThumbnails() {
        return this.thumbnails != null ? this.thumbnails.size() : 0;
    }

    public BufferedImage getThumbnail(int index) {
        if (this.thumbnails != null) {
            return this.thumbnails.get(index);
        }
        throw new IndexOutOfBoundsException(Messages.getString("imageio.60"));
    }

    public List<? extends BufferedImage> getThumbnails() {
        return this.thumbnails;
    }

    public void setThumbnails(List<? extends BufferedImage> thumbnails) {
        this.thumbnails = thumbnails;
    }

    public IIOMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(IIOMetadata metadata) {
        this.metadata = metadata;
    }
}

