/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;
import org.apache.harmony.awt.internal.nls.Messages;

public class RenderableImageOp
implements RenderableImage {
    ContextualRenderedImageFactory CRIF;
    ParameterBlock paramBlock;
    float minX;
    float minY;
    float width;
    float height;

    public RenderableImageOp(ContextualRenderedImageFactory CRIF, ParameterBlock paramBlock) {
        this.CRIF = CRIF;
        this.paramBlock = (ParameterBlock)paramBlock.clone();
        Rectangle2D r = CRIF.getBounds2D(paramBlock);
        this.minX = (float)r.getMinX();
        this.minY = (float)r.getMinY();
        this.width = (float)r.getWidth();
        this.height = (float)r.getHeight();
    }

    @Override
    public Object getProperty(String name) {
        return this.CRIF.getProperty(this.paramBlock, name);
    }

    public ParameterBlock setParameterBlock(ParameterBlock paramBlock) {
        ParameterBlock oldParam = this.paramBlock;
        this.paramBlock = (ParameterBlock)paramBlock.clone();
        return oldParam;
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Vector<RenderableImage> sources = this.getSources();
        ParameterBlock rdParam = (ParameterBlock)this.paramBlock.clone();
        if (sources != null) {
            Vector<Object> rdSources = new Vector<Object>();
            for (int i = 0; i < sources.size(); ++i) {
                RenderContext newContext = this.CRIF.mapRenderContext(i, renderContext, this.paramBlock, this);
                RenderedImage rdim = sources.elementAt(i).createRendering(newContext);
                if (rdim == null) continue;
                rdSources.addElement(rdim);
            }
            if (rdSources.size() > 0) {
                rdParam.setSources(rdSources);
            }
        }
        return this.CRIF.create(renderContext, rdParam);
    }

    @Override
    public RenderedImage createScaledRendering(int w, int h, RenderingHints hints) {
        if (w == 0 && h == 0) {
            throw new IllegalArgumentException(Messages.getString("awt.60"));
        }
        if (w == 0) {
            w = Math.round((float)h * (this.getWidth() / this.getHeight()));
        }
        if (h == 0) {
            h = Math.round((float)w * (this.getHeight() / this.getWidth()));
        }
        double sx = (double)w / (double)this.getWidth();
        double sy = (double)h / (double)this.getHeight();
        AffineTransform at = AffineTransform.getScaleInstance(sx, sy);
        RenderContext context = new RenderContext(at, hints);
        return this.createRendering(context);
    }

    @Override
    public Vector<RenderableImage> getSources() {
        if (this.paramBlock.getNumSources() == 0) {
            return null;
        }
        Vector<RenderableImage> v = new Vector<RenderableImage>();
        for (int i = 0; i < this.paramBlock.getNumSources(); ++i) {
            Object o = this.paramBlock.getSource(i);
            if (!(o instanceof RenderableImage)) continue;
            v.addElement((RenderableImage)o);
        }
        return v;
    }

    @Override
    public String[] getPropertyNames() {
        return this.CRIF.getPropertyNames();
    }

    public ParameterBlock getParameterBlock() {
        return this.paramBlock;
    }

    @Override
    public RenderedImage createDefaultRendering() {
        AffineTransform at = new AffineTransform();
        RenderContext context = new RenderContext(at);
        return this.createRendering(context);
    }

    @Override
    public boolean isDynamic() {
        return this.CRIF.isDynamic();
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getMinY() {
        return this.minY;
    }

    @Override
    public float getMinX() {
        return this.minX;
    }

    @Override
    public float getHeight() {
        return this.height;
    }
}

