/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.util.Vector;

public class ParameterBlock
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7577115551785240750L;
    protected Vector<Object> sources = new Vector();
    protected Vector<Object> parameters = new Vector();

    public ParameterBlock(Vector<Object> sources, Vector<Object> parameters) {
        this.setSources(sources);
        this.setParameters(parameters);
    }

    public ParameterBlock(Vector<Object> sources) {
        this.setSources(sources);
    }

    public ParameterBlock() {
    }

    public ParameterBlock setSource(Object source, int index) {
        if (this.sources.size() < index + 1) {
            this.sources.setSize(index + 1);
        }
        this.sources.setElementAt(source, index);
        return this;
    }

    public ParameterBlock set(Object obj, int index) {
        if (this.parameters.size() < index + 1) {
            this.parameters.setSize(index + 1);
        }
        this.parameters.setElementAt(obj, index);
        return this;
    }

    public ParameterBlock addSource(Object source) {
        this.sources.addElement(source);
        return this;
    }

    public ParameterBlock add(Object obj) {
        this.parameters.addElement(obj);
        return this;
    }

    public void setSources(Vector<Object> sources) {
        this.sources = sources;
    }

    public void setParameters(Vector<Object> parameters) {
        this.parameters = parameters;
    }

    public Vector<Object> getSources() {
        return this.sources;
    }

    public Vector<Object> getParameters() {
        return this.parameters;
    }

    public Object getSource(int index) {
        return this.sources.elementAt(index);
    }

    public Object getObjectParameter(int index) {
        return this.parameters.elementAt(index);
    }

    public Object shallowClone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object clone() {
        ParameterBlock replica;
        try {
            replica = (ParameterBlock)super.clone();
        }
        catch (Exception e) {
            return null;
        }
        if (this.sources != null) {
            replica.setSources((Vector)this.sources.clone());
        }
        if (this.parameters != null) {
            replica.setParameters((Vector)this.parameters.clone());
        }
        return replica;
    }

    public Class[] getParamClasses() {
        int count = this.parameters.size();
        Class[] paramClasses = new Class[count];
        for (int i = 0; i < count; ++i) {
            paramClasses[i] = this.parameters.elementAt(i).getClass();
        }
        return paramClasses;
    }

    public RenderableImage getRenderableSource(int index) {
        return (RenderableImage)this.sources.elementAt(index);
    }

    public ParameterBlock set(short s, int index) {
        return this.set(new Short(s), index);
    }

    public ParameterBlock add(short s) {
        return this.add(new Short(s));
    }

    public ParameterBlock set(long l, int index) {
        return this.set(new Long(l), index);
    }

    public ParameterBlock add(long l) {
        return this.add(new Long(l));
    }

    public ParameterBlock set(int i, int index) {
        return this.set(new Integer(i), index);
    }

    public ParameterBlock add(int i) {
        return this.add(new Integer(i));
    }

    public ParameterBlock set(float f, int index) {
        return this.set(new Float(f), index);
    }

    public ParameterBlock add(float f) {
        return this.add(new Float(f));
    }

    public ParameterBlock set(double d, int index) {
        return this.set(new Double(d), index);
    }

    public ParameterBlock add(double d) {
        return this.add(new Double(d));
    }

    public ParameterBlock set(char c, int index) {
        return this.set(new Character(c), index);
    }

    public ParameterBlock add(char c) {
        return this.add(new Character(c));
    }

    public ParameterBlock set(byte b, int index) {
        return this.set(new Byte(b), index);
    }

    public ParameterBlock add(byte b) {
        return this.add(new Byte(b));
    }

    public RenderedImage getRenderedSource(int index) {
        return (RenderedImage)this.sources.elementAt(index);
    }

    public short getShortParameter(int index) {
        return (Short)this.parameters.elementAt(index);
    }

    public long getLongParameter(int index) {
        return (Long)this.parameters.elementAt(index);
    }

    public int getIntParameter(int index) {
        return (Integer)this.parameters.elementAt(index);
    }

    public float getFloatParameter(int index) {
        return ((Float)this.parameters.elementAt(index)).floatValue();
    }

    public double getDoubleParameter(int index) {
        return (Double)this.parameters.elementAt(index);
    }

    public char getCharParameter(int index) {
        return ((Character)this.parameters.elementAt(index)).charValue();
    }

    public byte getByteParameter(int index) {
        return (Byte)this.parameters.elementAt(index);
    }

    public void removeSources() {
        this.sources.removeAllElements();
    }

    public void removeParameters() {
        this.parameters.removeAllElements();
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public int getNumParameters() {
        return this.parameters.size();
    }
}

