/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;
import org.apache.harmony.awt.internal.nls.Messages;

public class SinglePixelPackedSampleModel
extends SampleModel {
    private int[] bitMasks;
    private int[] bitOffsets;
    private int[] bitSizes;
    private int scanlineStride;
    private int maxBitSize;

    public SinglePixelPackedSampleModel(int dataType, int w, int h, int[] bitMasks) {
        this(dataType, w, h, w, bitMasks);
    }

    public SinglePixelPackedSampleModel(int dataType, int w, int h, int scanlineStride, int[] bitMasks) {
        super(dataType, w, h, bitMasks.length);
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.61", dataType));
        }
        this.scanlineStride = scanlineStride;
        this.bitMasks = (int[])bitMasks.clone();
        this.bitOffsets = new int[this.numBands];
        this.bitSizes = new int[this.numBands];
        this.maxBitSize = 0;
        for (int i = 0; i < this.numBands; ++i) {
            int offset = 0;
            int size = 0;
            int mask = bitMasks[i];
            if (mask != 0) {
                while ((mask & 1) == 0) {
                    mask >>>= 1;
                    ++offset;
                }
                while ((mask & 1) == 1) {
                    mask >>>= 1;
                    ++size;
                }
                if (mask != 0) {
                    throw new IllegalArgumentException(Messages.getString("awt.62", bitMasks[i]));
                }
            }
            this.bitOffsets[i] = offset;
            this.bitSizes[i] = size;
            if (this.maxBitSize >= size) continue;
            this.maxBitSize = size;
        }
    }

    @Override
    public Object getDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        switch (this.getTransferType()) {
            case 0: {
                byte[] bdata = obj == null ? new byte[1] : (byte[])obj;
                bdata[0] = (byte)data.getElem(y * this.scanlineStride + x);
                obj = bdata;
                break;
            }
            case 1: {
                short[] sdata = obj == null ? new short[1] : (short[])obj;
                sdata[0] = (short)data.getElem(y * this.scanlineStride + x);
                obj = sdata;
                break;
            }
            case 3: {
                int[] idata = obj == null ? new int[1] : (int[])obj;
                idata[0] = data.getElem(y * this.scanlineStride + x);
                obj = idata;
            }
        }
        return obj;
    }

    @Override
    public void setDataElements(int x, int y, Object obj, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        switch (this.getTransferType()) {
            case 0: {
                data.setElem(y * this.scanlineStride + x, ((byte[])obj)[0] & 0xFF);
                break;
            }
            case 1: {
                data.setElem(y * this.scanlineStride + x, ((short[])obj)[0] & 0xFFFF);
                break;
            }
            case 3: {
                data.setElem(y * this.scanlineStride + x, ((int[])obj)[0]);
            }
        }
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel model = (SinglePixelPackedSampleModel)o;
        return this.width == model.width && this.height == model.height && this.numBands == model.numBands && this.dataType == model.dataType && Arrays.equals(this.bitMasks, model.bitMasks) && Arrays.equals(this.bitOffsets, model.bitOffsets) && Arrays.equals(this.bitSizes, model.bitSizes) && this.scanlineStride == model.scanlineStride;
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        if (bands.length > this.numBands) {
            throw new RasterFormatException(Messages.getString("awt.64"));
        }
        int[] masks = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            masks[i] = this.bitMasks[bands[i]];
        }
        return new SinglePixelPackedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, masks);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        return new SinglePixelPackedSampleModel(this.dataType, w, h, this.bitMasks);
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int[] pixel = iArray == null ? new int[this.numBands] : iArray;
        for (int i = 0; i < this.numBands; ++i) {
            pixel[i] = this.getSample(x, y, i, data);
        }
        return pixel;
    }

    @Override
    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        for (int i = 0; i < this.numBands; ++i) {
            this.setSample(x, y, i, iArray[i], data);
        }
    }

    @Override
    public int getSample(int x, int y, int b, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int sample = data.getElem(y * this.scanlineStride + x);
        return (sample & this.bitMasks[b]) >>> this.bitOffsets[b];
    }

    @Override
    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || (long)x + (long)w > (long)this.width || (long)y + (long)h > (long)this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int[] pixels = iArray == null ? new int[w * h * this.numBands] : iArray;
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    pixels[idx++] = this.getSample(j, i, n, data);
                }
            }
        }
        return pixels;
    }

    @Override
    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || (long)x + (long)w > (long)this.width || (long)y + (long)h > (long)this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                for (int n = 0; n < this.numBands; ++n) {
                    this.setSample(j, i, n, iArray[idx++], data);
                }
            }
        }
    }

    @Override
    public void setSample(int x, int y, int b, int s, DataBuffer data) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int tmp = data.getElem(y * this.scanlineStride + x);
        tmp &= ~this.bitMasks[b];
        data.setElem(y * this.scanlineStride + x, tmp |= s << this.bitOffsets[b] & this.bitMasks[b]);
    }

    @Override
    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || (long)x + (long)w > (long)this.width || (long)y + (long)h > (long)this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        int[] samples = iArray == null ? new int[w * h] : iArray;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                samples[idx++] = this.getSample(j, i, b, data);
            }
        }
        return samples;
    }

    @Override
    public void setSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        if (x < 0 || y < 0 || (long)x + (long)w > (long)this.width || (long)y + (long)h > (long)this.height) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.63"));
        }
        int idx = 0;
        for (int i = y; i < y + h; ++i) {
            for (int j = x; j < x + w; ++j) {
                this.setSample(x + j, y + i, b, iArray[idx++], data);
            }
        }
    }

    @Override
    public DataBuffer createDataBuffer() {
        DataBuffer data = null;
        int size = (this.height - 1) * this.scanlineStride + this.width;
        switch (this.dataType) {
            case 0: {
                data = new DataBufferByte(size);
                break;
            }
            case 1: {
                data = new DataBufferUShort(size);
                break;
            }
            case 3: {
                data = new DataBufferInt(size);
            }
        }
        return data;
    }

    public int getOffset(int x, int y) {
        return y * this.scanlineStride + x;
    }

    @Override
    public int getSampleSize(int band) {
        return this.bitSizes[band];
    }

    @Override
    public int[] getSampleSize() {
        return (int[])this.bitSizes.clone();
    }

    public int[] getBitOffsets() {
        return (int[])this.bitOffsets.clone();
    }

    public int[] getBitMasks() {
        return (int[])this.bitMasks.clone();
    }

    public int hashCode() {
        int hash = 0;
        int tmp = 0;
        hash = this.width;
        tmp = hash >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.height) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.numBands) >>> 24;
        hash <<= 8;
        hash |= tmp;
        tmp = (hash ^= this.dataType) >>> 24;
        hash <<= 8;
        hash |= tmp;
        for (int element : this.bitMasks) {
            tmp = (hash ^= element) >>> 24;
            hash <<= 8;
            hash |= tmp;
        }
        for (int element : this.bitOffsets) {
            tmp = (hash ^= element) >>> 24;
            hash <<= 8;
            hash |= tmp;
        }
        for (int element : this.bitSizes) {
            tmp = (hash ^= element) >>> 24;
            hash <<= 8;
            hash |= tmp;
        }
        return hash ^= this.scanlineStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    @Override
    public int getNumDataElements() {
        return 1;
    }
}

