/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;
import org.apache.harmony.awt.internal.nls.Messages;

public class ReplicateScaleFilter
extends ImageFilter {
    protected int srcWidth;
    protected int srcHeight;
    protected int destWidth;
    protected int destHeight;
    protected int[] srcrows;
    protected int[] srccols;
    protected Object outpixbuf;

    public ReplicateScaleFilter(int width, int height) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException(Messages.getString("awt.234"));
        }
        this.destWidth = width;
        this.destHeight = height;
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
        Hashtable fprops = props == null ? new Hashtable() : (Hashtable)props.clone();
        String propName = "Rescale Filters";
        String prop = "destWidth=" + this.destWidth + "; destHeight=" + this.destHeight;
        Object o = fprops.get(propName);
        if (o != null) {
            prop = o instanceof String ? (String)o + "; " + prop : o.toString() + "; " + prop;
        }
        fprops.put(propName, prop);
        this.consumer.setProperties(fprops);
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int dstY;
        int sy;
        int[] buff;
        if (this.srccols == null) {
            this.initArrays();
        }
        if (this.outpixbuf == null || !(this.outpixbuf instanceof int[])) {
            buff = new int[this.destWidth];
            this.outpixbuf = buff;
        } else {
            buff = (int[])this.outpixbuf;
        }
        int wa = this.srcWidth - 1 >>> 1;
        int ha = this.srcHeight - 1 >>> 1;
        int dstX = (x * this.destWidth + wa) / this.srcWidth;
        for (int dy = dstY = (y * this.destHeight + ha) / this.srcHeight; dy < this.destHeight && (sy = this.srcrows[dy]) < y + h; ++dy) {
            int sx;
            int dx;
            int srcOff = off + (sy - y) * scansize;
            for (dx = dstX; dx < this.destWidth && (sx = this.srccols[dx]) < x + w; ++dx) {
                buff[dx] = pixels[srcOff + (sx - x)];
            }
            this.consumer.setPixels(dstX, dy, dx - dstX, 1, model, buff, dstX, this.destWidth);
        }
    }

    @Override
    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int dstY;
        int sy;
        byte[] buff;
        if (this.srccols == null) {
            this.initArrays();
        }
        if (this.outpixbuf == null || !(this.outpixbuf instanceof byte[])) {
            buff = new byte[this.destWidth];
            this.outpixbuf = buff;
        } else {
            buff = (byte[])this.outpixbuf;
        }
        int wa = this.srcWidth - 1 >>> 1;
        int ha = this.srcHeight - 1 >>> 1;
        int dstX = (x * this.destWidth + wa) / this.srcWidth;
        for (int dy = dstY = (y * this.destHeight + ha) / this.srcHeight; dy < this.destHeight && (sy = this.srcrows[dy]) < y + h; ++dy) {
            int sx;
            int dx;
            int srcOff = off + (sy - y) * scansize;
            for (dx = dstX; dx < this.destWidth && (sx = this.srccols[dx]) < x + w; ++dx) {
                buff[dx] = pixels[srcOff + (sx - x)];
            }
            this.consumer.setPixels(dstX, dy, dx - dstX, 1, model, buff, dstX, this.destWidth);
        }
    }

    @Override
    public void setDimensions(int w, int h) {
        this.srcWidth = w;
        this.srcHeight = h;
        if (this.destWidth < 0 && this.destHeight < 0) {
            this.destWidth = this.srcWidth;
            this.destHeight = this.srcHeight;
        } else if (this.destWidth < 0) {
            this.destWidth = this.destHeight * this.srcWidth / this.srcHeight;
        } else if (this.destHeight < 0) {
            this.destHeight = this.destWidth * this.srcHeight / this.srcWidth;
        }
        this.consumer.setDimensions(this.destWidth, this.destHeight);
    }

    private void initArrays() {
        if (this.destWidth < 0 || this.destHeight < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.srccols = new int[this.destWidth];
        int ca = this.srcWidth >>> 1;
        for (int i = 0; i < this.destWidth; ++i) {
            this.srccols[i] = (i * this.srcWidth + ca) / this.destWidth;
        }
        this.srcrows = new int[this.destHeight];
        int ra = this.srcHeight >>> 1;
        for (int i = 0; i < this.destHeight; ++i) {
            this.srcrows[i] = (i * this.srcHeight + ra) / this.destHeight;
        }
    }
}

