/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.apache.harmony.awt.gl.image.OrdinaryWritableRaster;
import org.apache.harmony.awt.internal.nls.Messages;

public class Raster {
    protected DataBuffer dataBuffer;
    protected int height;
    protected int minX;
    protected int minY;
    protected int numBands;
    protected int numDataElements;
    protected Raster parent;
    protected SampleModel sampleModel;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected int width;

    public static WritableRaster createBandedRaster(DataBuffer dataBuffer, int w, int h, int scanlineStride, int[] bankIndices, int[] bandOffsets, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (bankIndices == null || bandOffsets == null) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.277"));
        }
        if (dataBuffer == null) {
            throw new NullPointerException(Messages.getString("awt.278"));
        }
        int dataType = dataBuffer.getDataType();
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        BandedSampleModel sampleModel = new BandedSampleModel(dataType, w, h, scanlineStride, bankIndices, bandOffsets);
        return new OrdinaryWritableRaster(sampleModel, dataBuffer, location);
    }

    public static WritableRaster createBandedRaster(int dataType, int w, int h, int scanlineStride, int[] bankIndices, int[] bandOffsets, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (bankIndices == null || bandOffsets == null) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.277"));
        }
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        int maxOffset = bandOffsets[0];
        int maxBank = bankIndices[0];
        for (int i = 0; i < bankIndices.length; ++i) {
            if (bandOffsets[i] > maxOffset) {
                maxOffset = bandOffsets[i];
            }
            if (bankIndices[i] <= maxBank) continue;
            maxBank = bankIndices[i];
        }
        int numBanks = maxBank + 1;
        int dataSize = scanlineStride * (h - 1) + w + maxOffset;
        DataBuffer data = null;
        switch (dataType) {
            case 0: {
                data = new DataBufferByte(dataSize, numBanks);
                break;
            }
            case 1: {
                data = new DataBufferUShort(dataSize, numBanks);
                break;
            }
            case 3: {
                data = new DataBufferInt(dataSize, numBanks);
            }
        }
        return Raster.createBandedRaster(data, w, h, scanlineStride, bankIndices, bandOffsets, location);
    }

    public static WritableRaster createBandedRaster(int dataType, int w, int h, int bands, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (bands < 1) {
            throw new ArrayIndexOutOfBoundsException(Messages.getString("awt.279"));
        }
        int[] bandOffsets = new int[bands];
        int[] bankIndices = new int[bands];
        for (int i = 0; i < bands; ++i) {
            bandOffsets[i] = 0;
            bankIndices[i] = i;
        }
        return Raster.createBandedRaster(dataType, w, h, w, bankIndices, bandOffsets, location);
    }

    public static WritableRaster createInterleavedRaster(DataBuffer dataBuffer, int w, int h, int scanlineStride, int pixelStride, int[] bandOffsets, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (dataBuffer == null) {
            throw new NullPointerException(Messages.getString("awt.278"));
        }
        int dataType = dataBuffer.getDataType();
        if (dataType != 0 && dataType != 1) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        if (dataBuffer.getNumBanks() > 1) {
            throw new RasterFormatException(Messages.getString("awt.27A"));
        }
        if (bandOffsets == null) {
            throw new NullPointerException(Messages.getString("awt.27B"));
        }
        PixelInterleavedSampleModel sampleModel = new PixelInterleavedSampleModel(dataType, w, h, pixelStride, scanlineStride, bandOffsets);
        return new OrdinaryWritableRaster(sampleModel, dataBuffer, location);
    }

    public static WritableRaster createInterleavedRaster(int dataType, int w, int h, int scanlineStride, int pixelStride, int[] bandOffsets, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (dataType != 0 && dataType != 1) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        if (bandOffsets == null) {
            throw new NullPointerException(Messages.getString("awt.27B"));
        }
        int minOffset = bandOffsets[0];
        for (int i = 1; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] >= minOffset) continue;
            minOffset = bandOffsets[i];
        }
        int size = (h - 1) * scanlineStride + w * pixelStride + minOffset;
        DataBuffer data = null;
        switch (dataType) {
            case 0: {
                data = new DataBufferByte(size);
                break;
            }
            case 1: {
                data = new DataBufferUShort(size);
            }
        }
        return Raster.createInterleavedRaster(data, w, h, scanlineStride, pixelStride, bandOffsets, location);
    }

    public static WritableRaster createInterleavedRaster(int dataType, int w, int h, int bands, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (dataType != 0 && dataType != 1) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        int[] bandOffsets = new int[bands];
        for (int i = 0; i < bands; ++i) {
            bandOffsets[i] = i;
        }
        return Raster.createInterleavedRaster(dataType, w, h, w * bands, bands, bandOffsets, location);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int w, int h, int scanlineStride, int[] bandMasks, Point location) {
        if (dataBuffer == null) {
            throw new NullPointerException(Messages.getString("awt.278"));
        }
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (bandMasks == null) {
            throw new RasterFormatException(Messages.getString("awt.27C"));
        }
        if (dataBuffer.getNumBanks() > 1) {
            throw new RasterFormatException(Messages.getString("awt.27A"));
        }
        int dataType = dataBuffer.getDataType();
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(dataType, w, h, scanlineStride, bandMasks);
        return new OrdinaryWritableRaster(sampleModel, dataBuffer, location);
    }

    public static WritableRaster createPackedRaster(DataBuffer dataBuffer, int w, int h, int bitsPerPixel, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (dataBuffer == null) {
            throw new NullPointerException(Messages.getString("awt.278"));
        }
        if (dataBuffer.getNumBanks() > 1) {
            throw new RasterFormatException(Messages.getString("awt.27A"));
        }
        int dataType = dataBuffer.getDataType();
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        MultiPixelPackedSampleModel sampleModel = new MultiPixelPackedSampleModel(dataType, w, h, bitsPerPixel);
        return new OrdinaryWritableRaster(sampleModel, dataBuffer, location);
    }

    public static WritableRaster createPackedRaster(int dataType, int w, int h, int bands, int bitsPerBand, Point location) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (bands < 1 || bitsPerBand < 1) {
            throw new IllegalArgumentException(Messages.getString("awt.27D"));
        }
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        if (bitsPerBand * bands > DataBuffer.getDataTypeSize(dataType)) {
            throw new IllegalArgumentException(Messages.getString("awt.27E"));
        }
        if (bands > 1) {
            int[] bandMasks = new int[bands];
            int mask = (1 << bitsPerBand) - 1;
            for (int i = 0; i < bands; ++i) {
                bandMasks[i] = mask << bitsPerBand * (bands - 1 - i);
            }
            return Raster.createPackedRaster(dataType, w, h, bandMasks, location);
        }
        DataBuffer data = null;
        int size = (bitsPerBand * w + DataBuffer.getDataTypeSize(dataType) - 1) / DataBuffer.getDataTypeSize(dataType) * h;
        switch (dataType) {
            case 0: {
                data = new DataBufferByte(size);
                break;
            }
            case 1: {
                data = new DataBufferUShort(size);
                break;
            }
            case 3: {
                data = new DataBufferInt(size);
            }
        }
        return Raster.createPackedRaster(data, w, h, bitsPerBand, location);
    }

    public static WritableRaster createPackedRaster(int dataType, int w, int h, int[] bandMasks, Point location) {
        if (dataType != 0 && dataType != 1 && dataType != 3) {
            throw new IllegalArgumentException(Messages.getString("awt.230"));
        }
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        if ((long)location.x + (long)w > Integer.MAX_VALUE || (long)location.y + (long)h > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.276"));
        }
        if (bandMasks == null) {
            throw new NullPointerException(Messages.getString("awt.27C"));
        }
        DataBuffer data = null;
        switch (dataType) {
            case 0: {
                data = new DataBufferByte(w * h);
                break;
            }
            case 1: {
                data = new DataBufferUShort(w * h);
                break;
            }
            case 3: {
                data = new DataBufferInt(w * h);
            }
        }
        return Raster.createPackedRaster(data, w, h, w, bandMasks, location);
    }

    public static Raster createRaster(SampleModel sm, DataBuffer db, Point location) {
        if (sm == null || db == null) {
            throw new NullPointerException(Messages.getString("awt.27F"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        return new Raster(sm, db, location);
    }

    public static WritableRaster createWritableRaster(SampleModel sm, DataBuffer db, Point location) {
        if (sm == null || db == null) {
            throw new NullPointerException(Messages.getString("awt.27F"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        return new OrdinaryWritableRaster(sm, db, location);
    }

    public static WritableRaster createWritableRaster(SampleModel sm, Point location) {
        if (sm == null) {
            throw new NullPointerException(Messages.getString("awt.280"));
        }
        if (location == null) {
            location = new Point(0, 0);
        }
        return Raster.createWritableRaster(sm, sm.createDataBuffer(), location);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Point origin) {
        this(sampleModel, dataBuffer, new Rectangle(origin.x, origin.y, sampleModel.getWidth(), sampleModel.getHeight()), origin, null);
    }

    protected Raster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle aRegion, Point sampleModelTranslate, Raster parent) {
        if (sampleModel == null || dataBuffer == null || aRegion == null || sampleModelTranslate == null) {
            throw new NullPointerException(Messages.getString("awt.281"));
        }
        if (aRegion.width <= 0 || aRegion.height <= 0) {
            throw new RasterFormatException(Messages.getString("awt.282"));
        }
        if ((long)aRegion.x + (long)aRegion.width > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.283"));
        }
        if ((long)aRegion.y + (long)aRegion.height > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.284"));
        }
        Raster.validateDataBuffer(dataBuffer, aRegion.width, aRegion.height, sampleModel);
        this.sampleModel = sampleModel;
        this.dataBuffer = dataBuffer;
        this.minX = aRegion.x;
        this.minY = aRegion.y;
        this.width = aRegion.width;
        this.height = aRegion.height;
        this.sampleModelTranslateX = sampleModelTranslate.x;
        this.sampleModelTranslateY = sampleModelTranslate.y;
        this.parent = parent;
        this.numBands = sampleModel.getNumBands();
        this.numDataElements = sampleModel.getNumDataElements();
    }

    protected Raster(SampleModel sampleModel, Point origin) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(origin.x, origin.y, sampleModel.getWidth(), sampleModel.getHeight()), origin, null);
    }

    public Raster createChild(int parentX, int parentY, int width, int height, int childMinX, int childMinY, int[] bandList) {
        if (width <= 0 || height <= 0) {
            throw new RasterFormatException(Messages.getString("awt.285"));
        }
        if (parentX < this.minX || parentX + width > this.minX + this.width) {
            throw new RasterFormatException(Messages.getString("awt.286"));
        }
        if (parentY < this.minY || parentY + height > this.minY + this.height) {
            throw new RasterFormatException(Messages.getString("awt.287"));
        }
        if ((long)parentX + (long)width > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.288"));
        }
        if ((long)parentY + (long)height > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.289"));
        }
        if ((long)childMinX + (long)width > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.28A"));
        }
        if ((long)childMinY + (long)height > Integer.MAX_VALUE) {
            throw new RasterFormatException(Messages.getString("awt.28B"));
        }
        SampleModel childModel = bandList == null ? this.sampleModel : this.sampleModel.createSubsetSampleModel(bandList);
        int childTranslateX = childMinX - parentX;
        int childTranslateY = childMinY - parentY;
        return new Raster(childModel, this.dataBuffer, new Rectangle(childMinX, childMinY, width, height), new Point(childTranslateX + this.sampleModelTranslateX, childTranslateY + this.sampleModelTranslateY), this);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return new OrdinaryWritableRaster(this.sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new RasterFormatException(Messages.getString("awt.22E"));
        }
        SampleModel sm = this.sampleModel.createCompatibleSampleModel(w, h);
        return new OrdinaryWritableRaster(sm, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.createCompatibleWritableRaster(w, h);
        return raster.createWritableChild(0, 0, w, h, x, y, null);
    }

    public WritableRaster createCompatibleWritableRaster(Rectangle rect) {
        if (rect == null) {
            throw new NullPointerException(Messages.getString("awt.28C"));
        }
        return this.createCompatibleWritableRaster(rect.x, rect.y, rect.width, rect.height);
    }

    public Raster createTranslatedChild(int childMinX, int childMinY) {
        return this.createChild(this.minX, this.minY, this.width, this.height, childMinX, childMinY, null);
    }

    public Rectangle getBounds() {
        return new Rectangle(this.minX, this.minY, this.width, this.height);
    }

    public DataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public Object getDataElements(int x, int y, int w, int h, Object outData) {
        return this.sampleModel.getDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, outData, this.dataBuffer);
    }

    public Object getDataElements(int x, int y, Object outData) {
        return this.sampleModel.getDataElements(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, outData, this.dataBuffer);
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public final int getNumDataElements() {
        return this.numDataElements;
    }

    public Raster getParent() {
        return this.parent;
    }

    public double[] getPixel(int x, int y, double[] dArray) {
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    public float[] getPixel(int x, int y, float[] fArray) {
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    public int[] getPixel(int x, int y, int[] iArray) {
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, iArray, this.dataBuffer);
    }

    public double[] getPixels(int x, int y, int w, int h, double[] dArray) {
        return this.sampleModel.getPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, dArray, this.dataBuffer);
    }

    public float[] getPixels(int x, int y, int w, int h, float[] fArray) {
        return this.sampleModel.getPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, fArray, this.dataBuffer);
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray) {
        return this.sampleModel.getPixels(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, iArray, this.dataBuffer);
    }

    public int getSample(int x, int y, int b) {
        return this.sampleModel.getSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    public double getSampleDouble(int x, int y, int b) {
        return this.sampleModel.getSampleDouble(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    public float getSampleFloat(int x, int y, int b) {
        return this.sampleModel.getSampleFloat(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public final int getSampleModelTranslateX() {
        return this.sampleModelTranslateX;
    }

    public final int getSampleModelTranslateY() {
        return this.sampleModelTranslateY;
    }

    public double[] getSamples(int x, int y, int w, int h, int b, double[] dArray) {
        return this.sampleModel.getSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, dArray, this.dataBuffer);
    }

    public float[] getSamples(int x, int y, int w, int h, int b, float[] fArray) {
        return this.sampleModel.getSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, fArray, this.dataBuffer);
    }

    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray) {
        return this.sampleModel.getSamples(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, w, h, b, iArray, this.dataBuffer);
    }

    public final int getTransferType() {
        return this.sampleModel.getTransferType();
    }

    public final int getWidth() {
        return this.width;
    }

    private static void validateDataBuffer(DataBuffer dataBuffer, int w, int h, SampleModel sampleModel) {
        int size = 0;
        if (sampleModel instanceof ComponentSampleModel) {
            ComponentSampleModel csm = (ComponentSampleModel)sampleModel;
            int[] offsets = csm.getBandOffsets();
            int maxOffset = offsets[0];
            for (int i = 1; i < offsets.length; ++i) {
                if (offsets[i] <= maxOffset) continue;
                maxOffset = offsets[i];
            }
            int scanlineStride = csm.getScanlineStride();
            int pixelStride = csm.getPixelStride();
            size = (h - 1) * scanlineStride + (w - 1) * pixelStride + maxOffset + 1;
        } else if (sampleModel instanceof MultiPixelPackedSampleModel) {
            MultiPixelPackedSampleModel mppsm = (MultiPixelPackedSampleModel)sampleModel;
            int scanlineStride = mppsm.getScanlineStride();
            int dataBitOffset = mppsm.getDataBitOffset();
            int dataType = dataBuffer.getDataType();
            size = scanlineStride * h;
            switch (dataType) {
                case 0: {
                    size += (dataBitOffset + 7) / 8;
                    break;
                }
                case 1: {
                    size += (dataBitOffset + 15) / 16;
                    break;
                }
                case 3: {
                    size += (dataBitOffset + 31) / 32;
                }
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel sppsm = (SinglePixelPackedSampleModel)sampleModel;
            int scanlineStride = sppsm.getScanlineStride();
            size = (h - 1) * scanlineStride + w;
        }
        if (dataBuffer.getSize() < size) {
            throw new RasterFormatException(Messages.getString("awt.298"));
        }
    }
}

