/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.SampleModel;
import org.apache.harmony.awt.internal.nls.Messages;

public class PixelInterleavedSampleModel
extends ComponentSampleModel {
    public PixelInterleavedSampleModel(int dataType, int w, int h, int pixelStride, int scanlineStride, int[] bandOffsets) {
        super(dataType, w, h, pixelStride, scanlineStride, bandOffsets);
        int maxOffset = bandOffsets[0];
        int minOffset = bandOffsets[0];
        for (int i = 1; i < bandOffsets.length; ++i) {
            if (bandOffsets[i] > maxOffset) {
                maxOffset = bandOffsets[i];
            }
            if (bandOffsets[i] >= minOffset) continue;
            minOffset = bandOffsets[i];
        }
        if ((maxOffset -= minOffset) > scanlineStride) {
            throw new IllegalArgumentException(Messages.getString("awt.241"));
        }
        if (maxOffset > pixelStride) {
            throw new IllegalArgumentException(Messages.getString("awt.242"));
        }
        if (pixelStride * w > scanlineStride) {
            throw new IllegalArgumentException(Messages.getString("awt.243"));
        }
    }

    @Override
    public SampleModel createSubsetSampleModel(int[] bands) {
        int[] newOffsets = new int[bands.length];
        for (int i = 0; i < bands.length; ++i) {
            newOffsets[i] = this.bandOffsets[bands[i]];
        }
        return new PixelInterleavedSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, newOffsets);
    }

    @Override
    public SampleModel createCompatibleSampleModel(int w, int h) {
        int[] newOffsets;
        int i;
        int minOffset = this.bandOffsets[0];
        for (i = 1; i < this.numBands; ++i) {
            if (this.bandOffsets[i] >= minOffset) continue;
            minOffset = this.bandOffsets[i];
        }
        if (minOffset > 0) {
            newOffsets = new int[this.numBands];
            for (i = 0; i < this.numBands; ++i) {
                newOffsets[i] = this.bandOffsets[i] - minOffset;
            }
        } else {
            newOffsets = this.bandOffsets;
        }
        return new PixelInterleavedSampleModel(this.dataType, w, h, this.pixelStride, this.pixelStride * w, newOffsets);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        int tmp = hash >>> 8;
        hash <<= 8;
        return (hash |= tmp) ^ 0x66;
    }
}

