/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;
import org.apache.harmony.awt.internal.nls.Messages;

public class PixelGrabber
implements ImageConsumer {
    int width;
    int height;
    int X;
    int Y;
    int offset;
    int scanline;
    ImageProducer producer;
    byte[] bData;
    int[] iData;
    ColorModel cm;
    private int grabberStatus;
    private int dataType;
    private boolean isGrabbing;
    private boolean isRGB;
    private static final int DATA_TYPE_BYTE = 0;
    private static final int DATA_TYPE_INT = 1;
    private static final int DATA_TYPE_UNDEFINED = 2;
    private static final int ALL_BITS = 48;
    private static final int GRABBING_STOP = 112;

    public PixelGrabber(ImageProducer ip, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this.initialize(ip, x, y, w, h, pix, off, scansize, true);
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, int[] pix, int off, int scansize) {
        this.initialize(img.getSource(), x, y, w, h, pix, off, scansize, true);
    }

    public PixelGrabber(Image img, int x, int y, int w, int h, boolean forceRGB) {
        this.initialize(img.getSource(), x, y, w, h, null, 0, 0, forceRGB);
    }

    @Override
    public void setProperties(Hashtable<?, ?> props) {
    }

    public synchronized Object getPixels() {
        switch (this.dataType) {
            case 0: {
                return this.bData;
            }
            case 1: {
                return this.iData;
            }
        }
        return null;
    }

    @Override
    public void setColorModel(ColorModel model) {
    }

    @Override
    public void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel model, byte[] pixels, int srcOff, int srcScan) {
        int delta;
        if (srcY < this.Y) {
            delta = this.Y - srcY;
            if (delta >= this.height) {
                return;
            }
            srcY += delta;
            srcH -= delta;
            srcOff += srcScan * delta;
        }
        if (srcY + srcH > this.Y + this.height && (srcH = this.Y + this.height - srcY) <= 0) {
            return;
        }
        if (srcX < this.X) {
            delta = this.X - srcX;
            if (delta >= this.width) {
                return;
            }
            srcW -= delta;
            srcX += delta;
            srcOff += delta;
        }
        if (srcX + srcW > this.X + this.width && (srcW = this.X + this.width - srcX) <= 0) {
            return;
        }
        if (this.scanline == 0) {
            this.scanline = this.width;
        }
        int realOff = this.offset + (srcY - this.Y) * this.scanline + (srcX - this.X);
        switch (this.dataType) {
            case 2: {
                this.cm = model;
                if (model != ColorModel.getRGBdefault()) {
                    this.bData = new byte[this.width * this.height];
                    this.isRGB = false;
                    this.dataType = 0;
                } else {
                    this.iData = new int[this.width * this.height];
                    this.isRGB = true;
                    this.dataType = 1;
                }
            }
            case 0: {
                if (!this.isRGB && this.cm == model) {
                    for (int y = 0; y < srcH; ++y) {
                        System.arraycopy(pixels, srcOff, this.bData, realOff, srcW);
                        srcOff += srcScan;
                        realOff += this.scanline;
                    }
                    break;
                }
                this.forceToRGB();
            }
            case 1: {
                for (int y = 0; y < srcH; ++y) {
                    for (int x = 0; x < srcW; ++x) {
                        this.iData[realOff + x] = this.cm.getRGB(pixels[srcOff + x] & 0xFF);
                    }
                    srcOff += srcScan;
                    realOff += this.scanline;
                }
                break;
            }
        }
    }

    @Override
    public void setPixels(int srcX, int srcY, int srcW, int srcH, ColorModel model, int[] pixels, int srcOff, int srcScan) {
        int delta;
        if (srcY < this.Y) {
            delta = this.Y - srcY;
            if (delta >= this.height) {
                return;
            }
            srcY += delta;
            srcH -= delta;
            srcOff += srcScan * delta;
        }
        if (srcY + srcH > this.Y + this.height && (srcH = this.Y + this.height - srcY) <= 0) {
            return;
        }
        if (srcX < this.X) {
            delta = this.X - srcX;
            if (delta >= this.width) {
                return;
            }
            srcW -= delta;
            srcX += delta;
            srcOff += delta;
        }
        if (srcX + srcW > this.X + this.width && (srcW = this.X + this.width - srcX) <= 0) {
            return;
        }
        if (this.scanline == 0) {
            this.scanline = this.width;
        }
        int realOff = this.offset + (srcY - this.Y) * this.scanline + (srcX - this.X);
        int mask = 255;
        switch (this.dataType) {
            case 2: {
                this.cm = model;
                this.iData = new int[this.width * this.height];
                this.dataType = 1;
                this.isRGB = this.cm == ColorModel.getRGBdefault();
            }
            case 1: {
                if (this.cm == model) {
                    for (int y = 0; y < srcH; ++y) {
                        System.arraycopy(pixels, srcOff, this.iData, realOff, srcW);
                        srcOff += srcScan;
                        realOff += this.scanline;
                    }
                    break;
                }
                mask = -1;
            }
            case 0: {
                this.forceToRGB();
                for (int y = 0; y < srcH; ++y) {
                    for (int x = 0; x < srcW; ++x) {
                        this.iData[realOff + x] = this.cm.getRGB(pixels[srcOff + x] & mask);
                    }
                    srcOff += srcScan;
                    realOff += this.scanline;
                }
                break;
            }
        }
    }

    public synchronized ColorModel getColorModel() {
        return this.cm;
    }

    public synchronized boolean grabPixels(long ms) throws InterruptedException {
        if ((this.grabberStatus & 0x70) != 0) {
            return (this.grabberStatus & 0x30) != 0;
        }
        long start = System.currentTimeMillis();
        if (!this.isGrabbing) {
            this.isGrabbing = true;
            this.grabberStatus &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
        while ((this.grabberStatus & 0x70) == 0 && (ms == 0L || (ms = start + ms - System.currentTimeMillis()) > 0L)) {
            this.wait(ms);
        }
        return (this.grabberStatus & 0x30) != 0;
    }

    @Override
    public void setDimensions(int w, int h) {
        if (this.width < 0) {
            this.width = w - this.X;
        }
        if (this.height < 0) {
            this.height = h - this.Y;
        }
        this.grabberStatus |= 3;
        if (this.width <= 0 || this.height <= 0) {
            this.imageComplete(3);
            return;
        }
        if (this.isRGB && this.dataType == 2) {
            this.iData = new int[this.width * this.height];
            this.dataType = 1;
            this.scanline = this.width;
        }
    }

    @Override
    public void setHints(int hints) {
    }

    @Override
    public synchronized void imageComplete(int status) {
        switch (status) {
            case 4: {
                this.grabberStatus |= 0x80;
                break;
            }
            case 1: {
                this.grabberStatus |= 0xC0;
                break;
            }
            case 2: {
                this.grabberStatus |= 0x10;
                break;
            }
            case 3: {
                this.grabberStatus |= 0x20;
                break;
            }
            default: {
                throw new IllegalArgumentException(Messages.getString("awt.26A"));
            }
        }
        this.isGrabbing = false;
        this.producer.removeConsumer(this);
        this.notifyAll();
    }

    public boolean grabPixels() throws InterruptedException {
        return this.grabPixels(0L);
    }

    public synchronized void startGrabbing() {
        if ((this.grabberStatus & 0x70) != 0) {
            return;
        }
        if (!this.isGrabbing) {
            this.isGrabbing = true;
            this.grabberStatus &= 0xFFFFFF7F;
            this.producer.startProduction(this);
        }
    }

    public synchronized void abortGrabbing() {
        this.imageComplete(4);
    }

    public synchronized int status() {
        return this.grabberStatus;
    }

    public synchronized int getWidth() {
        if (this.width < 0) {
            return -1;
        }
        return this.width;
    }

    public synchronized int getStatus() {
        return this.grabberStatus;
    }

    public synchronized int getHeight() {
        if (this.height < 0) {
            return -1;
        }
        return this.height;
    }

    private void initialize(ImageProducer ip, int x, int y, int w, int h, int[] pixels, int off, int scansize, boolean forceRGB) {
        this.producer = ip;
        this.X = x;
        this.Y = y;
        this.width = w;
        this.height = h;
        this.iData = pixels;
        this.dataType = pixels == null ? 2 : 1;
        this.offset = off;
        this.scanline = scansize;
        if (forceRGB) {
            this.cm = ColorModel.getRGBdefault();
            this.isRGB = true;
        }
    }

    private void forceToRGB() {
        if (this.isRGB) {
            return;
        }
        switch (this.dataType) {
            case 0: {
                this.iData = new int[this.width * this.height];
                for (int i = 0; i < this.iData.length; ++i) {
                    this.iData[i] = this.cm.getRGB(this.bData[i] & 0xFF);
                }
                this.dataType = 1;
                this.bData = null;
                break;
            }
            case 1: {
                int[] buff = new int[this.width * this.height];
                for (int i = 0; i < this.iData.length; ++i) {
                    buff[i] = this.cm.getRGB(this.iData[i]);
                }
                this.iData = buff;
            }
        }
        this.offset = 0;
        this.scanline = this.width;
        this.cm = ColorModel.getRGBdefault();
        this.isRGB = true;
    }
}

